/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class EnumeratedTypeSet
extends TypeSet {
    private static int sCount = 0;
    Set fMembers = new LinkedHashSet();
    private static final int sMaxElements = 10;

    public static int getCount() {
        return sCount;
    }

    public static void resetCount() {
        sCount = 0;
    }

    public EnumeratedTypeSet(Iterator iterator, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        while (iterator.hasNext()) {
            this.fMembers.add(iterator.next());
        }
        ++sCount;
    }

    public EnumeratedTypeSet(TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        ++sCount;
    }

    public EnumeratedTypeSet(TType tType, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        Assert.isNotNull((Object)tType);
        this.fMembers.add(tType);
        ++sCount;
    }

    public boolean isUniverse() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet enumeratedTypeSet = (EnumeratedTypeSet)object;
            return this.fMembers.equals(enumeratedTypeSet.fMembers);
        }
        if (object instanceof SingletonTypeSet) {
            SingletonTypeSet singletonTypeSet = (SingletonTypeSet)object;
            return this.fMembers.size() == 1 && this.fMembers.contains(singletonTypeSet.anyMember());
        }
        if (object instanceof TypeSet) {
            TypeSet typeSet = (TypeSet)object;
            Iterator iterator = typeSet.iterator();
            while (iterator.hasNext()) {
                if (this.fMembers.contains(iterator.next())) continue;
                return false;
            }
            iterator = this.fMembers.iterator();
            while (iterator.hasNext()) {
                if (typeSet.contains((TType)iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 37 + this.fMembers.hashCode();
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        if (typeSet instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            enumeratedTypeSet.addAll(this);
            enumeratedTypeSet.retainAll(typeSet);
            if (enumeratedTypeSet.size() > 0) {
                return enumeratedTypeSet;
            }
            return this.getTypeSetEnvironment().getEmptyTypeSet();
        }
        return null;
    }

    public void intersectWith(TypeSet typeSet) {
        if (this.isUniverse()) {
            if (typeSet.isUniverse()) {
                return;
            }
            EnumeratedTypeSet enumeratedTypeSet = (EnumeratedTypeSet)typeSet;
            this.fMembers = new LinkedHashSet();
            this.fMembers.addAll(enumeratedTypeSet.fMembers);
        } else {
            this.retainAll(typeSet);
        }
    }

    public TypeSet subTypes() {
        if (this.isUniverse()) {
            return this.makeClone();
        }
        if (this.fMembers.contains(this.getJavaLangObject())) {
            return this.getTypeSetEnvironment().getUniverseTypeSet();
        }
        return this.getTypeSetEnvironment().createSubTypesSet(this);
    }

    public static EnumeratedTypeSet makeArrayTypesForElements(Iterator iterator, TypeSetEnvironment typeSetEnvironment) {
        EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(typeSetEnvironment);
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            enumeratedTypeSet.add(TTypes.createArrayType(tType, 1));
        }
        return enumeratedTypeSet;
    }

    public TypeSet superTypes() {
        if (this.isUniverse()) {
            return this.makeClone();
        }
        return this.getTypeSetEnvironment().createSuperTypesSet(this);
    }

    public TypeSet makeClone() {
        EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        enumeratedTypeSet.fMembers.addAll(this.fMembers);
        enumeratedTypeSet.initComplete();
        return enumeratedTypeSet;
    }

    public int size() {
        return this.fMembers.size();
    }

    public void clear() {
        if (this.isUniverse()) {
            this.fMembers = new LinkedHashSet();
        } else {
            this.fMembers.clear();
        }
    }

    public boolean isEmpty() {
        return this.fMembers.isEmpty();
    }

    public TType[] toArray() {
        return this.fMembers.toArray(new TType[this.fMembers.size()]);
    }

    public boolean add(TType tType) {
        Assert.isTrue((!this.isUniverse() ? 1 : 0) != 0, (String)"Someone's trying to expand the universe!");
        return this.fMembers.add(tType);
    }

    public boolean contains(TType tType) {
        if (this.isUniverse()) {
            return true;
        }
        return this.fMembers.contains(tType);
    }

    public boolean remove(TType tType) {
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(this.fMembers);
        }
        return this.fMembers.remove(tType);
    }

    private Set cloneSet(Set set) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(set);
        return linkedHashSet;
    }

    public boolean addAll(TypeSet typeSet) {
        if (typeSet instanceof EnumeratedTypeSet) {
            EnumeratedTypeSet enumeratedTypeSet = (EnumeratedTypeSet)typeSet;
            return this.fMembers.addAll(enumeratedTypeSet.fMembers);
        }
        EnumeratedTypeSet enumeratedTypeSet = typeSet.enumerate();
        return this.fMembers.addAll(enumeratedTypeSet.fMembers);
    }

    public TypeSet addedTo(TypeSet typeSet) {
        EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        enumeratedTypeSet.addAll(this);
        enumeratedTypeSet.addAll(typeSet);
        enumeratedTypeSet.initComplete();
        return enumeratedTypeSet;
    }

    public boolean containsAll(TypeSet typeSet) {
        if (this.isUniverse()) {
            return true;
        }
        if (typeSet.isUniverse()) {
            return false;
        }
        EnumeratedTypeSet enumeratedTypeSet = typeSet.enumerate();
        return this.fMembers.containsAll(enumeratedTypeSet.fMembers);
    }

    public boolean removeAll(EnumeratedTypeSet enumeratedTypeSet) {
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(this.fMembers);
        }
        return this.fMembers.removeAll(enumeratedTypeSet.fMembers);
    }

    public boolean retainAll(TypeSet typeSet) {
        if (typeSet.isUniverse()) {
            return false;
        }
        EnumeratedTypeSet enumeratedTypeSet = (EnumeratedTypeSet)typeSet;
        if (this.isUniverse()) {
            this.fMembers = this.cloneSet(enumeratedTypeSet.fMembers);
            return true;
        }
        return this.fMembers.retainAll(enumeratedTypeSet.fMembers);
    }

    public boolean isSingleton() {
        return this.fMembers.size() == 1;
    }

    public TType anyMember() {
        return (TType)this.fMembers.iterator().next();
    }

    public TypeSet upperBound() {
        if (this.fMembers.size() == 1) {
            return new SingletonTypeSet((TType)this.fMembers.iterator().next(), this.getTypeSetEnvironment());
        }
        if (this.fMembers.contains(this.getJavaLangObject())) {
            return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
        }
        EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        enumeratedTypeSet.fMembers.addAll(this.fMembers);
        Iterator iterator = this.fMembers.iterator();
        while (iterator.hasNext()) {
            Object object;
            TType tType = (TType)iterator.next();
            if (tType.isArrayType()) {
                object = (ArrayType)tType;
                int n = ((ArrayType)object).getDimensions();
                Iterator iterator2 = TTypes.getAllSubTypesIterator(((ArrayType)object).getElementType());
                while (iterator2.hasNext()) {
                    enumeratedTypeSet.fMembers.remove(TTypes.createArrayType((TType)iterator2.next(), n));
                }
                continue;
            }
            object = TTypes.getAllSubTypesIterator(tType);
            while (object.hasNext()) {
                enumeratedTypeSet.fMembers.remove(object.next());
            }
        }
        enumeratedTypeSet.initComplete();
        return enumeratedTypeSet;
    }

    public TypeSet lowerBound() {
        if (this.fMembers.size() == 1) {
            return new SingletonTypeSet((TType)this.fMembers.iterator().next(), this.getTypeSetEnvironment());
        }
        EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(this.getTypeSetEnvironment());
        enumeratedTypeSet.fMembers.addAll(this.fMembers);
        Iterator iterator = this.fMembers.iterator();
        while (iterator.hasNext()) {
            Object object;
            TType tType = (TType)iterator.next();
            if (tType.equals(this.getJavaLangObject())) {
                enumeratedTypeSet.fMembers.remove(tType);
                continue;
            }
            if (tType instanceof ArrayType) {
                object = (ArrayType)tType;
                int n = ((ArrayType)object).getDimensions();
                Iterator iterator2 = TTypes.getAllSuperTypesIterator(((ArrayType)object).getElementType());
                while (iterator2.hasNext()) {
                    enumeratedTypeSet.fMembers.remove(TTypes.createArrayType((TType)iterator2.next(), n));
                }
                continue;
            }
            object = TTypes.getAllSuperTypesIterator(tType);
            while (object.hasNext()) {
                enumeratedTypeSet.fMembers.remove(object.next());
            }
        }
        if (enumeratedTypeSet.size() > 0) {
            return enumeratedTypeSet;
        }
        return this.getTypeSetEnvironment().getEmptyTypeSet();
    }

    public boolean hasUniqueLowerBound() {
        return this.fMembers.size() == 1;
    }

    public boolean hasUniqueUpperBound() {
        return this.fMembers.size() == 1;
    }

    public TType uniqueLowerBound() {
        if (this.fMembers.size() == 1) {
            return (TType)this.fMembers.iterator().next();
        }
        return null;
    }

    public TType uniqueUpperBound() {
        if (this.fMembers.size() == 1) {
            return (TType)this.fMembers.iterator().next();
        }
        return null;
    }

    public Iterator iterator() {
        return this.fMembers.iterator();
    }

    public TType[] toArray(TType[] tTypeArray) {
        return this.fMembers.toArray(tTypeArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{" + this.fID + ":");
        if (this.isUniverse()) {
            stringBuffer.append(" <universe>");
        } else {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && n < 10) {
                TType tType = (TType)iterator.next();
                stringBuffer.append(' ').append(tType.getPrettySignature());
                if (iterator.hasNext()) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            if (iterator.hasNext()) {
                stringBuffer.append(" ...");
            }
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public EnumeratedTypeSet enumerate() {
        return this;
    }

    public void initComplete() {
        Assert.isTrue((!this.fMembers.isEmpty() ? 1 : 0) != 0);
    }
}

