/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetIntersection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SubTypesSet
extends TypeSet {
    private TypeSet fUpperBounds;
    private EnumeratedTypeSet fEnumCache = null;

    SubTypesSet(TypeSet typeSet) {
        super(typeSet.getTypeSetEnvironment());
        this.fUpperBounds = typeSet;
    }

    public boolean isUniverse() {
        return this.fUpperBounds.isUniverse() || this.fUpperBounds.contains(this.getJavaLangObject());
    }

    public TypeSet makeClone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof SubTypesSet) {
            SubTypesSet subTypesSet = (SubTypesSet)object;
            return subTypesSet.fUpperBounds.equals(this.fUpperBounds);
        }
        return false;
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        Object object;
        Object object2;
        TypeSet typeSet2;
        if (this.fUpperBounds.equals(typeSet)) {
            return typeSet;
        }
        if (typeSet instanceof SubTypesSet) {
            typeSet2 = (SubTypesSet)typeSet;
            if (this.fUpperBounds.isSingleton() && ((SubTypesSet)typeSet2).fUpperBounds.isSingleton()) {
                object2 = this.fUpperBounds.anyMember();
                object = ((SubTypesSet)typeSet2).fUpperBounds.anyMember();
                if (TTypes.canAssignTo((TType)object, (TType)object2)) {
                    return new SubTypesSet(((SubTypesSet)typeSet2).fUpperBounds);
                }
            } else if (this.fUpperBounds instanceof SubTypesSet && ((SubTypesSet)(object2 = (SubTypesSet)this.fUpperBounds)).lowerBound().equals(((SubTypesSet)typeSet2).lowerBound())) {
                return typeSet2;
            }
        }
        if (typeSet instanceof SubTypesOfSingleton) {
            typeSet2 = (SubTypesOfSingleton)typeSet;
            if (this.fUpperBounds.isSingleton()) {
                object2 = this.fUpperBounds.anyMember();
                object = ((SubTypesOfSingleton)typeSet2).uniqueUpperBound();
                if (TTypes.canAssignTo((TType)object, (TType)object2)) {
                    return this.getTypeSetEnvironment().createSubTypesOfSingleton((TType)object);
                }
            } else if (this.fUpperBounds instanceof SubTypesOfSingleton && ((SubTypesOfSingleton)(object2 = (SubTypesOfSingleton)this.fUpperBounds)).uniqueLowerBound().equals(((SubTypesOfSingleton)typeSet2).uniqueLowerBound())) {
                return typeSet2;
            }
        }
        if (typeSet instanceof SuperTypesSet) {
            typeSet2 = (SuperTypesSet)typeSet;
            if (this.fUpperBounds.equals(((SuperTypesSet)typeSet2).lowerBound())) {
                return this.fUpperBounds;
            }
            if (this.fUpperBounds instanceof TypeSetIntersection) {
                object2 = (TypeSetIntersection)this.fUpperBounds;
                object = ((TypeSetIntersection)object2).getLHS();
                TypeSet typeSet3 = ((TypeSetIntersection)object2).getRHS();
                if (object.equals(((SuperTypesSet)typeSet2).lowerBound())) {
                    return new TypeSetIntersection(typeSet, new SubTypesSet(typeSet3));
                }
            }
        }
        return null;
    }

    public TypeSet subTypes() {
        return this;
    }

    public boolean isEmpty() {
        return this.fUpperBounds.isEmpty();
    }

    public boolean contains(TType tType) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.contains(tType);
        }
        if (this.fUpperBounds.contains(tType)) {
            return true;
        }
        Iterator iterator = this.fUpperBounds.upperBound().iterator();
        while (iterator.hasNext()) {
            TType tType2 = (TType)iterator.next();
            if (!TTypes.canAssignTo(tType, tType2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(TypeSet typeSet) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.containsAll(typeSet);
        }
        if (this.fUpperBounds.containsAll(typeSet)) {
            return true;
        }
        Iterator iterator = typeSet.iterator();
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            boolean bl = false;
            Iterator iterator2 = this.fUpperBounds.iterator();
            while (iterator2.hasNext()) {
                TType tType2 = (TType)iterator2.next();
                if (!TTypes.canAssignTo(tType, tType2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private TType getElementTypeOf(TType tType) {
        if (tType instanceof ArrayType) {
            return ((ArrayType)tType).getElementType();
        }
        return tType;
    }

    public boolean isSingleton() {
        if (!this.fUpperBounds.isSingleton()) {
            return false;
        }
        TType tType = this.fUpperBounds.anyMember();
        return this.getElementTypeOf(tType).getSubTypes().length == 0;
    }

    public TType anyMember() {
        return this.fUpperBounds.anyMember();
    }

    public TypeSet upperBound() {
        return this.fUpperBounds;
    }

    public TypeSet lowerBound() {
        return this.enumerate().lowerBound();
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public String toString() {
        return "<" + this.fID + ": subTypes(" + this.fUpperBounds + ")>";
    }

    public boolean hasUniqueLowerBound() {
        return false;
    }

    public boolean hasUniqueUpperBound() {
        return this.fUpperBounds.isSingleton();
    }

    public TType uniqueLowerBound() {
        return null;
    }

    public TType uniqueUpperBound() {
        return this.fUpperBounds.isSingleton() ? this.fUpperBounds.anyMember() : null;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            Iterator iterator = this.fUpperBounds.iterator();
            while (iterator.hasNext()) {
                Object object;
                TType tType = (TType)iterator.next();
                if (tType instanceof ArrayType) {
                    object = (ArrayType)tType;
                    int n = ((ArrayType)object).getDimensions();
                    Iterator iterator2 = TTypes.getAllSubTypesIterator(((ArrayType)object).getElementType());
                    while (iterator2.hasNext()) {
                        this.fEnumCache.add(TTypes.createArrayType((TType)iterator2.next(), n));
                    }
                } else {
                    object = TTypes.getAllSubTypesIterator(tType);
                    while (object.hasNext()) {
                        this.fEnumCache.fMembers.add(object.next());
                    }
                }
                this.fEnumCache.add(tType);
            }
        }
        return this.fEnumCache;
    }
}

