/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class QualifiedNameSearchResult {
    private Map fChanges = new HashMap();

    public TextChange getChange(IFile iFile) {
        TextChange textChange = (TextChange)this.fChanges.get(iFile);
        if (textChange == null) {
            textChange = new TextFileChange(iFile.getName(), iFile);
            this.fChanges.put(iFile, textChange);
        }
        return textChange;
    }

    public TextChange[] getAllChanges() {
        Collection collection = this.fChanges.values();
        return collection.toArray(new TextChange[collection.size()]);
    }

    public IFile[] getAllFiles() {
        Set set = this.fChanges.keySet();
        return set.toArray(new IFile[set.size()]);
    }

    public Change getSingleChange(IFile[] iFileArray) {
        Collection collection = this.fChanges.values();
        if (collection.size() == 0) {
            return null;
        }
        CompositeChange compositeChange = new CompositeChange(RefactoringCoreMessages.QualifiedNameSearchResult_change_name);
        compositeChange.markAsSynthetic();
        List<IFile> list = Arrays.asList(iFileArray);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TextFileChange textFileChange = (TextFileChange)iterator.next();
            if (list.contains(textFileChange.getFile())) continue;
            compositeChange.add((Change)textFileChange);
        }
        return compositeChange;
    }
}

