/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IOpenable;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile[] getFiles(ICompilationUnit[] iCompilationUnitArray) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iCompilationUnitArray.length);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            IResource iResource = iCompilationUnitArray[n].getResource();
            if (iResource != null && iResource.getType() == 1) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    public static IFile getFile(ICompilationUnit iCompilationUnit) {
        IResource iResource = iCompilationUnit.getResource();
        if (iResource != null && iResource.getType() == 1) {
            return (IFile)iResource;
        }
        return null;
    }

    public static IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IJavaElement) {
            return ResourceUtil.getResource((IJavaElement)object);
        }
        return null;
    }

    private static IResource getResource(IJavaElement iJavaElement) {
        if (iJavaElement.getElementType() == 5) {
            return ((ICompilationUnit)iJavaElement).getResource();
        }
        if (iJavaElement instanceof IOpenable) {
            return iJavaElement.getResource();
        }
        return null;
    }
}

