/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.CommentAnalyzer;

public class StatementAnalyzer
extends SelectionAnalyzer {
    protected ICompilationUnit fCUnit;
    private TokenScanner fScanner;
    private RefactoringStatus fStatus;

    public StatementAnalyzer(ICompilationUnit iCompilationUnit, Selection selection, boolean bl) throws JavaModelException {
        super(selection, bl);
        Assert.isNotNull((Object)iCompilationUnit);
        this.fCUnit = iCompilationUnit;
        this.fStatus = new RefactoringStatus();
        this.fScanner = new TokenScanner(this.fCUnit);
    }

    protected void checkSelectedNodes() {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (aSTNodeArray.length == 0) {
            return;
        }
        ASTNode aSTNode = aSTNodeArray[0];
        int n = this.getSelection().getOffset();
        try {
            int n2 = this.fScanner.getNextStartOffset(n, true);
            if (n2 == aSTNode.getStartPosition()) {
                int n3;
                int n4 = ASTNodes.getExclusiveEnd(aSTNodeArray[aSTNodeArray.length - 1]);
                n2 = this.fScanner.getNextStartOffset(n4, true);
                if (n2 <= (n3 = this.getSelection().getInclusiveEnd())) {
                    SourceRange sourceRange = new SourceRange(n4, n2 - n4);
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_end_of_selection, JavaStatusContext.create((ITypeRoot)this.fCUnit, sourceRange));
                }
                return;
            }
        }
        catch (CoreException coreException) {}
        SourceRange sourceRange = new SourceRange(n, aSTNode.getStartPosition() - n + 1);
        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_beginning_of_selection, JavaStatusContext.create((ITypeRoot)this.fCUnit, sourceRange));
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    protected TokenScanner getTokenScanner() {
        return this.fScanner;
    }

    public void endVisit(CompilationUnit compilationUnit) {
        if (!this.hasSelectedNodes()) {
            super.endVisit(compilationUnit);
            return;
        }
        ASTNode aSTNode = this.getFirstSelectedNode();
        Selection selection = this.getSelection();
        if (compilationUnit != aSTNode) {
            ASTNode aSTNode2 = aSTNode.getParent();
            this.fStatus.merge(CommentAnalyzer.perform(selection, this.fScanner.getScanner(), aSTNode2.getStartPosition(), aSTNode2.getLength()));
        }
        if (!this.fStatus.hasFatalError()) {
            this.checkSelectedNodes();
        }
        super.endVisit(compilationUnit);
    }

    public void endVisit(DoStatement doStatement) {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)doStatement, aSTNodeArray) && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)doStatement.getBody()) && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)doStatement.getExpression())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_do_body_expression);
        }
        super.endVisit(doStatement);
    }

    public void endVisit(ForStatement forStatement) {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)forStatement, aSTNodeArray)) {
            boolean bl = StatementAnalyzer.contains(aSTNodeArray, (ASTNode)forStatement.getExpression());
            boolean bl2 = StatementAnalyzer.contains(aSTNodeArray, forStatement.updaters());
            if (StatementAnalyzer.contains(aSTNodeArray, forStatement.initializers()) && bl) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_initializer_expression);
            } else if (bl && bl2) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_expression_updater);
            } else if (bl2 && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)forStatement.getBody())) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_updater_body);
            }
        }
        super.endVisit(forStatement);
    }

    public void endVisit(ForInStatement forInStatement) {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)forInStatement, aSTNodeArray)) {
            boolean bl = StatementAnalyzer.contains(aSTNodeArray, (ASTNode)forInStatement.getIterationVariable());
            boolean bl2 = StatementAnalyzer.contains(aSTNodeArray, (ASTNode)forInStatement.getCollection());
            if (bl && bl2) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_expression_updater);
            } else if (bl2 && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)forInStatement.getBody())) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_for_updater_body);
            }
        }
        super.endVisit(forInStatement);
    }

    public void endVisit(SwitchStatement switchStatement) {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)switchStatement, aSTNodeArray)) {
            List list = StatementAnalyzer.getSwitchCases(switchStatement);
            int n = 0;
            while (n < aSTNodeArray.length) {
                ASTNode aSTNode = aSTNodeArray[n];
                if (list.contains(aSTNode)) {
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_switch_statement);
                    break;
                }
                ++n;
            }
        }
        super.endVisit(switchStatement);
    }

    public void endVisit(SynchronizedStatement synchronizedStatement) {
        ASTNode aSTNode = this.getFirstSelectedNode();
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)synchronizedStatement) == 2 && aSTNode == synchronizedStatement.getBody()) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_synchronized_statement);
        }
        super.endVisit(synchronizedStatement);
    }

    public void endVisit(TryStatement tryStatement) {
        ASTNode aSTNode = this.getFirstSelectedNode();
        if (this.getSelection().getEndVisitSelectionMode((ASTNode)tryStatement) == 3) {
            if (aSTNode == tryStatement.getBody() || aSTNode == tryStatement.getFinally()) {
                this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_try_statement);
            } else {
                List list = tryStatement.catchClauses();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    CatchClause catchClause = (CatchClause)iterator.next();
                    if (catchClause == aSTNode || catchClause.getBody() == aSTNode) {
                        this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_try_statement);
                        continue;
                    }
                    if (catchClause.getException() != aSTNode) continue;
                    this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_catch_argument);
                }
            }
        }
        super.endVisit(tryStatement);
    }

    public void endVisit(WhileStatement whileStatement) {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)whileStatement, aSTNodeArray) && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)whileStatement.getExpression()) && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)whileStatement.getBody())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_while_expression_body);
        }
        super.endVisit(whileStatement);
    }

    public void endVisit(WithStatement withStatement) {
        ASTNode[] aSTNodeArray = this.getSelectedNodes();
        if (this.doAfterValidation((ASTNode)withStatement, aSTNodeArray) && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)withStatement.getExpression()) && StatementAnalyzer.contains(aSTNodeArray, (ASTNode)withStatement.getBody())) {
            this.invalidSelection(RefactoringCoreMessages.StatementAnalyzer_while_expression_body);
        }
        super.endVisit(withStatement);
    }

    private boolean doAfterValidation(ASTNode aSTNode, ASTNode[] aSTNodeArray) {
        return aSTNodeArray.length > 0 && aSTNode == aSTNodeArray[0].getParent() && this.getSelection().getEndVisitSelectionMode(aSTNode) == 3;
    }

    protected void invalidSelection(String string) {
        this.fStatus.addFatalError(string);
        this.reset();
    }

    protected void invalidSelection(String string, RefactoringStatusContext refactoringStatusContext) {
        this.fStatus.addFatalError(string, refactoringStatusContext);
        this.reset();
    }

    private static List getSwitchCases(SwitchStatement switchStatement) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = switchStatement.statements().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SwitchCase)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    protected static boolean contains(ASTNode[] aSTNodeArray, ASTNode aSTNode) {
        int n = 0;
        while (n < aSTNodeArray.length) {
            if (aSTNodeArray[n] == aSTNode) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static boolean contains(ASTNode[] aSTNodeArray, List list) {
        int n = 0;
        while (n < aSTNodeArray.length) {
            if (list.contains(aSTNodeArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

