/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaVariable;
import org.eclipse.wst.jsdt.internal.corext.template.java.LocalVarResolver;
import org.eclipse.wst.jsdt.internal.corext.template.java.NameResolver;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariable;

public class JavaContextType
extends CompilationUnitContextType {
    public static final String NAME = "javaScript";

    public JavaContextType() {
        super(NAME);
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver(new CompilationUnitContextType.File());
        this.addResolver(new CompilationUnitContextType.PrimaryTypeName());
        this.addResolver(new CompilationUnitContextType.ReturnType());
        this.addResolver(new CompilationUnitContextType.Method());
        this.addResolver(new CompilationUnitContextType.Type());
        this.addResolver(new CompilationUnitContextType.Package());
        this.addResolver(new CompilationUnitContextType.Project());
        this.addResolver(new CompilationUnitContextType.Arguments());
        this.addResolver(new Array());
        this.addResolver(new ArrayType());
        this.addResolver(new ArrayElement());
        this.addResolver(new Index());
        this.addResolver(new Iterator());
        this.addResolver(new Collection());
        this.addResolver(new Iterable());
        this.addResolver(new IterableType());
        this.addResolver(new IterableElement());
        this.addResolver(new Todo());
    }

    public CompilationUnitContext createContext(IDocument iDocument, int n, int n2, ICompilationUnit iCompilationUnit) {
        return new JavaContext(this, iDocument, n, n2, iCompilationUnit);
    }

    public CompilationUnitContext createContext(IDocument iDocument, Position position, ICompilationUnit iCompilationUnit) {
        return new JavaContext(this, iDocument, position, iCompilationUnit);
    }

    protected static abstract class AbstractIterable
    extends TemplateVariableResolver {
        public AbstractIterable(String string, String string2) {
            super(string, string2);
        }

        protected String[] resolveAll(TemplateContext templateContext) {
            JavaContext javaContext = (JavaContext)templateContext;
            CompilationUnitCompletion.Variable[] variableArray = this.getLocalVariables(javaContext);
            String[] stringArray = new String[variableArray.length];
            int n = 0;
            while (n < variableArray.length) {
                stringArray[n] = variableArray[n].getName();
                ++n;
            }
            if (stringArray.length > 0) {
                javaContext.markAsUsed(stringArray[0]);
            }
            return stringArray;
        }

        protected abstract CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext var1);

        public void resolve(TemplateVariable templateVariable, TemplateContext templateContext) {
            if (templateVariable instanceof MultiVariable) {
                JavaContext javaContext = (JavaContext)templateContext;
                JavaVariable javaVariable = (JavaVariable)templateVariable;
                Object[] objectArray = this.getLocalVariables(javaContext);
                if (objectArray.length > 0) {
                    javaVariable.setChoices(objectArray);
                    javaContext.markAsUsed(((CompilationUnitCompletion.Variable)objectArray[0]).getName());
                    if (objectArray.length > 1) {
                        templateVariable.setUnambiguous(false);
                    } else {
                        templateVariable.setUnambiguous(this.isUnambiguous(templateContext));
                    }
                    return;
                }
            }
            super.resolve(templateVariable, templateContext);
        }
    }

    protected static abstract class AbstractIterableElement
    extends TemplateVariableResolver {
        private String fMasterName;

        public AbstractIterableElement(String string, String string2, String string3) {
            super(string, string2);
            this.fMasterName = string3;
        }

        protected String[] resolveAll(TemplateContext templateContext) {
            JavaContext javaContext = (JavaContext)templateContext;
            CompilationUnitCompletion.Variable[] variableArray = this.getLocalVariables(javaContext);
            String[] stringArray = new String[variableArray.length];
            int n = 0;
            while (n < variableArray.length) {
                stringArray[n] = javaContext.suggestVariableNames(variableArray[n].getMemberTypeNames()[0])[0];
                if (n == 0) {
                    javaContext.markAsUsed(stringArray[0]);
                }
                ++n;
            }
            return stringArray;
        }

        protected abstract CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext var1);

        public void resolve(TemplateVariable templateVariable, TemplateContext templateContext) {
            if (templateVariable instanceof MultiVariable) {
                JavaContext javaContext = (JavaContext)templateContext;
                MultiVariable multiVariable = (MultiVariable)templateVariable;
                CompilationUnitCompletion.Variable[] variableArray = this.getLocalVariables(javaContext);
                if (variableArray.length > 0) {
                    Object[] objectArray;
                    int n = 0;
                    while (n < variableArray.length) {
                        objectArray = javaContext.suggestVariableNames(variableArray[n].getMemberTypeNames()[0]);
                        multiVariable.setChoices(variableArray[n], objectArray);
                        ++n;
                    }
                    TemplateVariable templateVariable2 = javaContext.getTemplateVariable(this.fMasterName);
                    if (templateVariable2 instanceof MultiVariable) {
                        objectArray = (MultiVariable)templateVariable2;
                        javaContext.addDependency((MultiVariable)objectArray, multiVariable);
                        multiVariable.setKey(objectArray.getCurrentChoice());
                    }
                    javaContext.markAsUsed(multiVariable.getDefaultValue());
                    if (variableArray.length > 1 || variableArray.length == 1 && multiVariable.getChoices().length > 1) {
                        templateVariable.setUnambiguous(false);
                    } else {
                        templateVariable.setUnambiguous(this.isUnambiguous(templateContext));
                    }
                    return;
                }
            }
            super.resolve(templateVariable, templateContext);
        }
    }

    protected static abstract class AbstractIterableType
    extends TemplateVariableResolver {
        private String fMasterName;

        public AbstractIterableType(String string, String string2, String string3) {
            super(string, string2);
            this.fMasterName = string3;
        }

        protected String[] resolveAll(TemplateContext templateContext) {
            JavaContext javaContext = (JavaContext)templateContext;
            CompilationUnitCompletion.Variable[] variableArray = this.getLocalVariables(javaContext);
            String[] stringArray = new String[variableArray.length];
            int n = 0;
            while (n < variableArray.length) {
                stringArray[n] = variableArray[n].getMemberTypeNames()[0];
                ++n;
            }
            return stringArray;
        }

        protected abstract CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext var1);

        public void resolve(TemplateVariable templateVariable, TemplateContext templateContext) {
            if (templateVariable instanceof MultiVariable) {
                JavaContext javaContext = (JavaContext)templateContext;
                MultiVariable multiVariable = (MultiVariable)templateVariable;
                CompilationUnitCompletion.Variable[] variableArray = this.getLocalVariables(javaContext);
                if (variableArray.length > 0) {
                    int n = 0;
                    while (n < variableArray.length) {
                        multiVariable.setChoices(variableArray[n], variableArray[n].getMemberTypeNames());
                        ++n;
                    }
                    TemplateVariable templateVariable2 = javaContext.getTemplateVariable(this.fMasterName);
                    if (templateVariable2 instanceof MultiVariable) {
                        MultiVariable multiVariable2 = (MultiVariable)templateVariable2;
                        javaContext.addDependency(multiVariable2, multiVariable);
                        multiVariable.setKey(multiVariable2.getCurrentChoice());
                    }
                    if (variableArray.length > 1 || variableArray.length == 1 && multiVariable.getChoices().length > 1) {
                        templateVariable.setUnambiguous(false);
                    } else {
                        templateVariable.setUnambiguous(this.isUnambiguous(templateContext));
                    }
                    return;
                }
            }
            super.resolve(templateVariable, templateContext);
        }
    }

    protected static class Array
    extends AbstractIterable {
        public Array() {
            super("array", JavaTemplateMessages.JavaContextType_variable_description_array);
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext javaContext) {
            return javaContext.getArrays();
        }
    }

    protected static class ArrayElement
    extends AbstractIterableElement {
        public ArrayElement() {
            super("array_element", JavaTemplateMessages.JavaContextType_variable_description_array_element, "array");
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext javaContext) {
            return javaContext.getArrays();
        }
    }

    protected static class ArrayType
    extends AbstractIterableType {
        public ArrayType() {
            super("array_type", JavaTemplateMessages.JavaContextType_variable_description_array_type, "array");
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext javaContext) {
            return javaContext.getArrays();
        }
    }

    protected static class Collection
    extends LocalVarResolver {
        public Collection() {
            super("java.util.Collection");
            this.setType("collection");
            this.setDescription(JavaTemplateMessages.JavaContextType_variable_description_collection);
        }
    }

    protected static class Index
    extends NameResolver {
        public Index() {
            super("int");
            this.setType("index");
            this.setDescription(JavaTemplateMessages.JavaContextType_variable_description_index);
        }
    }

    protected static class Iterable
    extends AbstractIterable {
        public Iterable() {
            super("iterable", JavaTemplateMessages.JavaContextType_variable_description_iterable);
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext javaContext) {
            return javaContext.getIterables();
        }
    }

    protected static class IterableElement
    extends AbstractIterableElement {
        public IterableElement() {
            super("iterable_element", JavaTemplateMessages.JavaContextType_variable_description_iterable_element, "iterable");
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext javaContext) {
            return javaContext.getIterables();
        }
    }

    protected static class IterableType
    extends AbstractIterableType {
        public IterableType() {
            super("iterable_type", JavaTemplateMessages.JavaContextType_variable_description_iterable_type, "iterable");
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext javaContext) {
            return javaContext.getIterables();
        }
    }

    protected static class Iterator
    extends NameResolver {
        public Iterator() {
            super("java.util.Iterator");
            this.setType("iterator");
            this.setDescription(JavaTemplateMessages.JavaContextType_variable_description_iterator);
        }
    }

    protected static class Todo
    extends TemplateVariableResolver {
        public Todo() {
            super("todo", JavaTemplateMessages.JavaContextType_variable_description_todo);
        }

        protected String resolve(TemplateContext templateContext) {
            JavaContext javaContext = (JavaContext)templateContext;
            ICompilationUnit iCompilationUnit = javaContext.getCompilationUnit();
            if (iCompilationUnit == null) {
                return "XXX";
            }
            IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
            String string = StubUtility.getTodoTaskTag(iJavaProject);
            if (string == null) {
                return "XXX";
            }
            return string;
        }
    }
}

