/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class JdtFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private JdtFlags() {
    }

    public static boolean isAbstract(IMember iMember) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationMethod(iMember)) {
            return true;
        }
        return Flags.isAbstract((int)iMember.getFlags());
    }

    public static boolean isAbstract(IMethodBinding iMethodBinding) {
        if (JdtFlags.isInterfaceOrAnnotationMember((IBinding)iMethodBinding)) {
            return true;
        }
        return Modifier.isAbstract((int)iMethodBinding.getModifiers());
    }

    public static boolean isDeprecated(IMember iMember) throws JavaModelException {
        return Flags.isDeprecated((int)iMember.getFlags());
    }

    public static boolean isFinal(IMember iMember) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationField(iMember)) {
            return true;
        }
        if (JdtFlags.isAnonymousType(iMember)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(iMember)) {
            return true;
        }
        return Flags.isFinal((int)iMember.getFlags());
    }

    public static boolean isNative(IMember iMember) throws JavaModelException {
        return Flags.isNative((int)iMember.getFlags());
    }

    public static boolean isPackageVisible(IMember iMember) throws JavaModelException {
        return !JdtFlags.isPrivate(iMember) && !JdtFlags.isProtected(iMember) && !JdtFlags.isPublic(iMember);
    }

    public static boolean isPackageVisible(BodyDeclaration bodyDeclaration) {
        return !JdtFlags.isPrivate(bodyDeclaration) && !JdtFlags.isProtected(bodyDeclaration) && !JdtFlags.isPublic(bodyDeclaration);
    }

    public static boolean isPackageVisible(IBinding iBinding) {
        return !JdtFlags.isPrivate(iBinding) && !JdtFlags.isProtected(iBinding) && !JdtFlags.isPublic(iBinding);
    }

    public static boolean isPrivate(IMember iMember) throws JavaModelException {
        return Flags.isPrivate((int)iMember.getFlags());
    }

    public static boolean isPrivate(BodyDeclaration bodyDeclaration) {
        return Modifier.isPrivate((int)bodyDeclaration.getModifiers());
    }

    public static boolean isPrivate(IBinding iBinding) {
        return Modifier.isPrivate((int)iBinding.getModifiers());
    }

    public static boolean isProtected(IMember iMember) throws JavaModelException {
        return Flags.isProtected((int)iMember.getFlags());
    }

    public static boolean isProtected(BodyDeclaration bodyDeclaration) {
        return Modifier.isProtected((int)bodyDeclaration.getModifiers());
    }

    public static boolean isProtected(IBinding iBinding) {
        return Modifier.isProtected((int)iBinding.getModifiers());
    }

    public static boolean isPublic(IMember iMember) throws JavaModelException {
        if (JdtFlags.isInterfaceOrAnnotationMember(iMember)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(iMember)) {
            return true;
        }
        return Flags.isPublic((int)iMember.getFlags());
    }

    public static boolean isPublic(IBinding iBinding) {
        if (JdtFlags.isInterfaceOrAnnotationMember(iBinding)) {
            return true;
        }
        return Modifier.isPublic((int)iBinding.getModifiers());
    }

    public static boolean isPublic(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isInterfaceOrAnnotationMember(bodyDeclaration)) {
            return true;
        }
        return Modifier.isPublic((int)bodyDeclaration.getModifiers());
    }

    public static boolean isStatic(IMember iMember) throws JavaModelException {
        if (JdtFlags.isNestedInterfaceOrAnnotation(iMember)) {
            return true;
        }
        if (iMember.getElementType() != 9 && JdtFlags.isInterfaceOrAnnotationMember(iMember)) {
            return true;
        }
        if (JdtFlags.isEnumConstant(iMember)) {
            return true;
        }
        return Flags.isStatic((int)iMember.getFlags());
    }

    public static boolean isStatic(IMethodBinding iMethodBinding) {
        return Modifier.isStatic((int)iMethodBinding.getModifiers());
    }

    public static boolean isStatic(IVariableBinding iVariableBinding) {
        if (JdtFlags.isInterfaceOrAnnotationMember((IBinding)iVariableBinding)) {
            return true;
        }
        return Modifier.isStatic((int)iVariableBinding.getModifiers());
    }

    public static boolean isStrictfp(IMember iMember) throws JavaModelException {
        return Flags.isStrictfp((int)iMember.getFlags());
    }

    public static boolean isSynchronized(IMember iMember) throws JavaModelException {
        return Flags.isSynchronized((int)iMember.getFlags());
    }

    public static boolean isSynthetic(IMember iMember) throws JavaModelException {
        return Flags.isSynthetic((int)iMember.getFlags());
    }

    public static boolean isAnnotation(IMember iMember) throws JavaModelException {
        return Flags.isAnnotation((int)iMember.getFlags());
    }

    public static boolean isEnum(IMember iMember) throws JavaModelException {
        return Flags.isEnum((int)iMember.getFlags());
    }

    public static boolean isVarargs(IMethod iMethod) throws JavaModelException {
        return Flags.isVarargs((int)iMethod.getFlags());
    }

    public static boolean isTransient(IMember iMember) throws JavaModelException {
        return Flags.isTransient((int)iMember.getFlags());
    }

    public static boolean isVolatile(IMember iMember) throws JavaModelException {
        return Flags.isVolatile((int)iMember.getFlags());
    }

    private static boolean isInterfaceOrAnnotationMethod(IMember iMember) throws JavaModelException {
        return iMember.getElementType() == 9 && JdtFlags.isInterfaceOrAnnotationMember(iMember);
    }

    private static boolean isInterfaceOrAnnotationField(IMember iMember) throws JavaModelException {
        return iMember.getElementType() == 8 && JdtFlags.isInterfaceOrAnnotationMember(iMember);
    }

    private static boolean isInterfaceOrAnnotationMember(IMember iMember) throws JavaModelException {
        return iMember.getDeclaringType() != null && JavaModelUtil.isInterfaceOrAnnotation(iMember.getDeclaringType());
    }

    private static boolean isInterfaceOrAnnotationMember(IBinding iBinding) {
        ITypeBinding iTypeBinding = null;
        if (iBinding instanceof IVariableBinding) {
            iTypeBinding = ((IVariableBinding)iBinding).getDeclaringClass();
        } else if (iBinding instanceof IMethodBinding) {
            iTypeBinding = ((IMethodBinding)iBinding).getDeclaringClass();
        } else if (iBinding instanceof ITypeBinding) {
            iTypeBinding = ((ITypeBinding)iBinding).getDeclaringClass();
        }
        return iTypeBinding != null && (iTypeBinding.isInterface() || iTypeBinding.isAnnotation());
    }

    private static boolean isInterfaceOrAnnotationMember(BodyDeclaration bodyDeclaration) {
        boolean bl = bodyDeclaration.getParent() instanceof TypeDeclaration && ((TypeDeclaration)bodyDeclaration.getParent()).isInterface();
        boolean bl2 = bodyDeclaration.getParent() instanceof AnnotationTypeDeclaration;
        return bl || bl2;
    }

    private static boolean isNestedInterfaceOrAnnotation(IMember iMember) throws JavaModelException {
        return iMember.getElementType() == 7 && iMember.getDeclaringType() != null && JavaModelUtil.isInterfaceOrAnnotation((IType)iMember);
    }

    private static boolean isEnumConstant(IMember iMember) throws JavaModelException {
        return iMember.getElementType() == 8 && JdtFlags.isEnum(iMember);
    }

    private static boolean isAnonymousType(IMember iMember) throws JavaModelException {
        return iMember.getElementType() == 7 && ((IType)iMember).isAnonymous();
    }

    public static int getVisibilityCode(IMember iMember) throws JavaModelException {
        if (JdtFlags.isPublic(iMember)) {
            return 1;
        }
        if (JdtFlags.isProtected(iMember)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(iMember)) {
            return 0;
        }
        if (JdtFlags.isPrivate(iMember)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static int getVisibilityCode(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isPublic(bodyDeclaration)) {
            return 1;
        }
        if (JdtFlags.isProtected(bodyDeclaration)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(bodyDeclaration)) {
            return 0;
        }
        if (JdtFlags.isPrivate(bodyDeclaration)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static int getVisibilityCode(IBinding iBinding) {
        if (JdtFlags.isPublic(iBinding)) {
            return 1;
        }
        if (JdtFlags.isProtected(iBinding)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(iBinding)) {
            return 0;
        }
        if (JdtFlags.isPrivate(iBinding)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static String getVisibilityString(int n) {
        if (Modifier.isPublic((int)n)) {
            return VISIBILITY_STRING_PUBLIC;
        }
        if (Modifier.isProtected((int)n)) {
            return VISIBILITY_STRING_PROTECTED;
        }
        if (Modifier.isPrivate((int)n)) {
            return VISIBILITY_STRING_PRIVATE;
        }
        return VISIBILITY_STRING_PACKAGE;
    }

    public static int getVisibilityCode(String string) {
        Assert.isNotNull((Object)string);
        if (VISIBILITY_STRING_PACKAGE.equals(string)) {
            return 0;
        }
        if (VISIBILITY_STRING_PRIVATE.equals(string)) {
            return 2;
        }
        if (VISIBILITY_STRING_PROTECTED.equals(string)) {
            return 4;
        }
        if (VISIBILITY_STRING_PUBLIC.equals(string)) {
            return 1;
        }
        return -1;
    }

    public static void assertVisibility(int n) {
        Assert.isTrue((n == 1 || n == 4 || n == 0 || n == 2 ? 1 : 0) != 0);
    }

    public static boolean isHigherVisibility(int n, int n2) {
        JdtFlags.assertVisibility(n2);
        JdtFlags.assertVisibility(n);
        switch (n2) {
            case 2: {
                return n == 0 || n == 1 || n == 4;
            }
            case 0: {
                return n == 1 || n == 4;
            }
            case 4: {
                return n == 1;
            }
            case 1: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    public static int getLowerVisibility(int n, int n2) {
        if (JdtFlags.isHigherVisibility(n, n2)) {
            return n2;
        }
        return n;
    }

    public static int clearAccessModifiers(int n) {
        return JdtFlags.clearFlag(7, n);
    }

    public static int clearFlag(int n, int n2) {
        return n2 & ~n;
    }
}

