/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.wst.jsdt.internal.corext.template.java.CodeTemplates;
import org.eclipse.wst.jsdt.internal.corext.template.java.TemplateSet;

public final class CompatibilityTemplateStore
extends ContributionTemplateStore {
    private TemplateSet fLegacySet;

    public CompatibilityTemplateStore(ContextTypeRegistry contextTypeRegistry, IPreferenceStore iPreferenceStore, String string, TemplateSet templateSet) {
        super(contextTypeRegistry, iPreferenceStore, string);
        this.fLegacySet = templateSet;
    }

    public void load() throws IOException {
        super.load();
        if (this.fLegacySet != null) {
            ArrayList<Template> arrayList = new ArrayList<Template>(Arrays.asList(this.fLegacySet.getTemplates()));
            this.fLegacySet.clear();
            TemplatePersistenceData[] templatePersistenceDataArray = this.getTemplateData(true);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Template template = (Template)listIterator.next();
                TemplatePersistenceData templatePersistenceData = CompatibilityTemplateStore.findSimilarTemplate(templatePersistenceDataArray, template, this.isCodeTemplates());
                if (templatePersistenceData == null) {
                    if (this.isCodeTemplates()) continue;
                    this.add(new TemplatePersistenceData(template, true));
                    continue;
                }
                if (templatePersistenceData.getTemplate().getPattern().equals(template.getPattern())) continue;
                templatePersistenceData.setTemplate(template);
            }
            this.save();
            this.fLegacySet = null;
        }
    }

    private static TemplatePersistenceData findSimilarTemplate(TemplatePersistenceData[] templatePersistenceDataArray, Template template, boolean bl) {
        int n = 0;
        while (n < templatePersistenceDataArray.length) {
            TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n];
            Template template2 = templatePersistenceData.getTemplate();
            if (CompatibilityTemplateStore.isSimilar(template, template2, bl)) {
                return templatePersistenceData;
            }
            ++n;
        }
        return null;
    }

    private static boolean isSimilar(Template template, Template template2, boolean bl) {
        return template2.getName().equals(template.getName()) && template2.getContextTypeId().equals(template.getContextTypeId()) && (bl || template2.getDescription().equals(template.getDescription()));
    }

    private boolean isCodeTemplates() {
        return this.fLegacySet instanceof CodeTemplates;
    }

    public static void pruneDuplicates(TemplateStore templateStore, boolean bl) {
        TemplatePersistenceData[] templatePersistenceDataArray = templateStore.getTemplateData(true);
        int n = templatePersistenceDataArray.length - 1;
        while (n >= 0) {
            TemplatePersistenceData templatePersistenceData;
            TemplatePersistenceData templatePersistenceData2 = templatePersistenceDataArray[n];
            if (templatePersistenceData2.isUserAdded() && (templatePersistenceData = CompatibilityTemplateStore.findSimilarTemplate(templatePersistenceDataArray, templatePersistenceData2.getTemplate(), bl)) != templatePersistenceData2 && !templatePersistenceData.isUserAdded()) {
                templatePersistenceData.setTemplate(templatePersistenceData2.getTemplate());
                templateStore.delete(templatePersistenceData2);
            }
            --n;
        }
        if (bl) {
            templatePersistenceDataArray = templateStore.getTemplateData(true);
            n = templatePersistenceDataArray.length - 1;
            while (n >= 0) {
                if (templatePersistenceDataArray[n].isUserAdded()) {
                    templateStore.delete(templatePersistenceDataArray[n]);
                }
                --n;
            }
        }
    }
}

