/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackagesProvider;

class PackagesViewHierarchicalContentProvider
extends LogicalPackagesProvider
implements ITreeContentProvider {
    public PackagesViewHierarchicalContentProvider(StructuredViewer structuredViewer) {
        super(structuredViewer);
    }

    public Object[] getChildren(Object object) {
        try {
            if (object instanceof IJavaElement) {
                IJavaElement iJavaElement = (IJavaElement)object;
                int n = iJavaElement.getElementType();
                switch (n) {
                    case 2: {
                        IPackageFragmentRoot iPackageFragmentRoot;
                        Object object2;
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IJavaProject iJavaProject = (IJavaProject)object;
                        IPackageFragment[] iPackageFragmentArray = this.getTopLevelChildrenByElementName((IJavaElement[])iJavaProject.getPackageFragments());
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        int n2 = 0;
                        while (n2 < iPackageFragmentArray.length) {
                            object2 = iPackageFragmentArray[n2];
                            IJavaElement iJavaElement2 = object2.getParent();
                            if (!(!(iJavaElement2 instanceof IPackageFragmentRoot) || (iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement2).isArchive() && iPackageFragmentRoot.isExternal())) {
                                arrayList.add(object2);
                            }
                            ++n2;
                        }
                        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
                        object2 = new ArrayList();
                        int n3 = 0;
                        while (n3 < iPackageFragmentRootArray.length) {
                            iPackageFragmentRoot = iPackageFragmentRootArray[n3];
                            IResource iResource = iPackageFragmentRoot.getUnderlyingResource();
                            if (iResource != null && iResource instanceof IFolder) {
                                object2.addAll(this.getFolders(((IFolder)iResource).members()));
                            }
                            ++n3;
                        }
                        Object[] objectArray = this.combineSamePackagesIntoLogialPackages(arrayList.toArray(new IPackageFragment[arrayList.size()]));
                        if (object2.size() > 0) {
                            if (objectArray.length > 0) {
                                object2.addAll(Arrays.asList(objectArray));
                            }
                            return object2.toArray();
                        }
                        return objectArray;
                    }
                    case 3: {
                        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IResource iResource = iPackageFragmentRoot.getUnderlyingResource();
                        if (iPackageFragmentRoot.isArchive()) {
                            Object[] objectArray = new IPackageFragment[]{};
                            IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
                            objectArray = this.getTopLevelChildrenByElementName(iJavaElementArray);
                            this.addFragmentsToMap((IPackageFragment[])objectArray);
                            return objectArray;
                        }
                        if (iResource != null && iResource instanceof IFolder) {
                            List list = this.getFoldersAndElements(((IFolder)iResource).members());
                            IPackageFragment iPackageFragment = iPackageFragmentRoot.getPackageFragment("");
                            if (iPackageFragment.exists()) {
                                list.add(iPackageFragment);
                            }
                            this.addFragmentsToMap(list);
                            return list.toArray();
                        }
                        return NO_CHILDREN;
                    }
                    case 4: {
                        IPackageFragment iPackageFragment = (IPackageFragment)object;
                        if (iPackageFragment.isDefaultPackage()) {
                            return NO_CHILDREN;
                        }
                        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iPackageFragment.getParent();
                        Object[] objectArray = this.findNextLevelChildrenByElementName(iPackageFragmentRoot, iPackageFragment);
                        this.addFragmentsToMap((IPackageFragment[])objectArray);
                        Object[] objectArray2 = iPackageFragment.getNonJavaResources();
                        if (objectArray2.length == 0) {
                            return objectArray;
                        }
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.addAll(Arrays.asList(objectArray));
                        int n4 = 0;
                        while (n4 < objectArray2.length) {
                            Object object3 = objectArray2[n4];
                            if (object3 instanceof IFolder) {
                                arrayList.add(object3);
                            }
                            ++n4;
                        }
                        return arrayList.toArray();
                    }
                }
            } else {
                if (object instanceof LogicalPackage) {
                    ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
                    IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
                    int n = 0;
                    while (n < iPackageFragmentArray.length) {
                        IPackageFragment iPackageFragment = iPackageFragmentArray[n];
                        IPackageFragment[] iPackageFragmentArray2 = this.findNextLevelChildrenByElementName((IPackageFragmentRoot)iPackageFragment.getParent(), iPackageFragment);
                        arrayList.addAll(Arrays.asList(iPackageFragmentArray2));
                        ++n;
                    }
                    return this.combineSamePackagesIntoLogialPackages(arrayList.toArray(new IPackageFragment[arrayList.size()]));
                }
                if (object instanceof IFolder) {
                    IFolder iFolder = (IFolder)object;
                    IResource[] iResourceArray = iFolder.members();
                    List list = this.getFoldersAndElements(iResourceArray);
                    this.addFragmentsToMap(list);
                    return list.toArray();
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return NO_CHILDREN;
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    private void addFragmentsToMap(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IPackageFragment)) continue;
            arrayList.add(e);
        }
        this.addFragmentsToMap(arrayList.toArray(new IPackageFragment[arrayList.size()]));
    }

    private List getFoldersAndElements(IResource[] iResourceArray) throws CoreException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource instanceof IFolder) {
                IFolder iFolder = (IFolder)iResource;
                IJavaElement iJavaElement = JavaCore.create((IFolder)iFolder);
                if (iJavaElement instanceof IPackageFragment) {
                    arrayList.add(iJavaElement);
                } else {
                    arrayList.add(iFolder);
                }
            }
            ++n;
        }
        return arrayList;
    }

    private List getFolders(IResource[] iResourceArray) throws CoreException {
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>();
        int n = 0;
        while (n < iResourceArray.length) {
            IFolder iFolder;
            IJavaElement iJavaElement;
            IResource iResource = iResourceArray[n];
            if (iResource instanceof IFolder && (iJavaElement = JavaCore.create((IFolder)(iFolder = (IFolder)iResource))) == null) {
                arrayList.add(iFolder);
            }
            ++n;
        }
        return arrayList;
    }

    private IPackageFragment[] findNextLevelChildrenByElementName(IPackageFragmentRoot iPackageFragmentRoot, IPackageFragment iPackageFragment) {
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
        try {
            IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
            String string = iPackageFragment.getElementName();
            int n = 0;
            while (n < iJavaElementArray.length) {
                IJavaElement iJavaElement = iJavaElementArray[n];
                if (iJavaElement instanceof IPackageFragment) {
                    String string2;
                    IPackageFragment iPackageFragment2 = (IPackageFragment)iJavaElement;
                    String string3 = iJavaElement.getElementName();
                    if (string3.length() > string.length() && string3.charAt(string.length()) == '.' && iPackageFragment2.exists() && !"".equals(string) && string3.startsWith(string) && !string3.equals(string) && !"".equals(string2 = string3.substring(string.length() + 1)) && string2.indexOf(46) == -1) {
                        arrayList.add(iPackageFragment2);
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    private IPackageFragment[] getTopLevelChildrenByElementName(IJavaElement[] iJavaElementArray) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            if (iJavaElement instanceof IPackageFragment && iJavaElement.getElementName().indexOf(46) == -1) {
                arrayList.add(iJavaElement);
            }
            ++n;
        }
        return arrayList.toArray(new IPackageFragment[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getParent(Object object) {
        try {
            if (object instanceof IPackageFragment) {
                IPackageFragment iPackageFragment = (IPackageFragment)object;
                if (!iPackageFragment.exists()) {
                    return null;
                }
                Object object2 = this.getHierarchicalParent(iPackageFragment);
                if (!(object2 instanceof IPackageFragment)) return object2;
                IPackageFragment iPackageFragment2 = (IPackageFragment)object2;
                LogicalPackage logicalPackage = this.findLogicalPackage(iPackageFragment2);
                if (logicalPackage != null) {
                    return logicalPackage;
                }
                LogicalPackage logicalPackage2 = this.createLogicalPackage(iPackageFragment2);
                if (logicalPackage2 != null) return logicalPackage2;
                return iPackageFragment2;
            }
            if (!(object instanceof LogicalPackage)) {
                if (!(object instanceof IFolder)) return null;
                IFolder iFolder = (IFolder)object;
                IContainer iContainer = iFolder.getParent();
                IJavaElement iJavaElement = JavaCore.create((IResource)iContainer);
                if (iJavaElement == null) return iContainer;
                return iJavaElement;
            }
            LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
            IPackageFragment iPackageFragment = logicalPackage.getFragments()[0];
            Object object3 = this.getHierarchicalParent(iPackageFragment);
            if (!(object3 instanceof IPackageFragment)) return iPackageFragment.getJavaProject();
            IPackageFragment iPackageFragment3 = (IPackageFragment)object3;
            LogicalPackage logicalPackage3 = this.findLogicalPackage(iPackageFragment3);
            if (logicalPackage3 != null) {
                return logicalPackage3;
            }
            LogicalPackage logicalPackage4 = this.createLogicalPackage(iPackageFragment3);
            if (logicalPackage4 != null) return logicalPackage4;
            return iPackageFragment3;
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return null;
    }

    private LogicalPackage createLogicalPackage(IPackageFragment iPackageFragment) {
        if (!this.fInputIsProject) {
            return null;
        }
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
        try {
            IPackageFragment iPackageFragment2;
            Object object;
            IPackageFragmentRoot[] iPackageFragmentRootArray = iPackageFragment.getJavaProject().getPackageFragmentRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                object = iPackageFragmentRootArray[n];
                iPackageFragment2 = object.getPackageFragment(iPackageFragment.getElementName());
                if (iPackageFragment2.exists() && !iPackageFragment2.equals(iPackageFragment)) {
                    arrayList.add(iPackageFragment2);
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                LogicalPackage logicalPackage = new LogicalPackage(iPackageFragment);
                this.fMapToLogicalPackage.put(this.getKey(iPackageFragment), logicalPackage);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    iPackageFragment2 = (IPackageFragment)object.next();
                    if (!logicalPackage.belongs(iPackageFragment2)) continue;
                    logicalPackage.add(iPackageFragment2);
                    this.fMapToLogicalPackage.put(this.getKey(iPackageFragment2), logicalPackage);
                }
                return logicalPackage;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return null;
    }

    private Object getHierarchicalParent(IPackageFragment iPackageFragment) throws JavaModelException {
        IJavaElement iJavaElement = iPackageFragment.getParent();
        if (iJavaElement instanceof IPackageFragmentRoot && iJavaElement.exists()) {
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
            if (iPackageFragmentRoot.isArchive() || !iPackageFragment.exists()) {
                return this.findNextLevelParentByElementName(iPackageFragment);
            }
            IResource iResource = iPackageFragment.getUnderlyingResource();
            if (iResource != null && iResource instanceof IFolder) {
                IFolder iFolder = (IFolder)iResource;
                IContainer iContainer = iFolder.getParent();
                IJavaElement iJavaElement2 = JavaCore.create((IResource)iContainer);
                if (iJavaElement2 != null) {
                    return iJavaElement2;
                }
                return iContainer;
            }
        }
        return iJavaElement;
    }

    private Object findNextLevelParentByElementName(IPackageFragment iPackageFragment) {
        String string = iPackageFragment.getElementName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(0, n);
            IPackageFragment iPackageFragment2 = ((IPackageFragmentRoot)iPackageFragment.getParent()).getPackageFragment(string2);
            if (iPackageFragment2.exists()) {
                return iPackageFragment2;
            }
        }
        return iPackageFragment.getParent();
    }

    public boolean hasChildren(Object object) {
        IPackageFragment iPackageFragment;
        if (object instanceof IPackageFragment && ((iPackageFragment = (IPackageFragment)object).isDefaultPackage() || !iPackageFragment.exists())) {
            return false;
        }
        return this.getChildren(object).length > 0;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    protected void processDelta(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        Object object;
        int n = iJavaElementDelta.getKind();
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        if (this.isClassPathChange(iJavaElementDelta) && (object = this.fViewer.getInput()) != null) {
            if (this.fInputIsProject && object.equals(iJavaElement.getJavaProject())) {
                this.postRefresh(object);
                return;
            }
            if (!this.fInputIsProject && object.equals(iJavaElement)) {
                if (iJavaElement.exists()) {
                    this.postRefresh(object);
                } else {
                    this.postRemove(object);
                }
                return;
            }
        }
        if (n == 2 && (object = this.fViewer.getInput()) != null && object.equals(iJavaElement)) {
            this.postRemove(object);
            return;
        }
        if (iJavaElement instanceof IPackageFragment) {
            object = (IPackageFragment)iJavaElement;
            if (n == 2) {
                this.removeElement((IPackageFragment)object);
                return;
            }
            if (n == 1) {
                Object object2 = this.getParent(object);
                this.addElement((IPackageFragment)object, object2);
                return;
            }
            if (n == 4) {
                LogicalPackage logicalPackage = this.findLogicalPackage((IPackageFragment)object);
                if (logicalPackage != null) {
                    this.postRefresh(this.findElementToRefresh((Object)logicalPackage));
                } else {
                    this.postRefresh(this.findElementToRefresh(object));
                }
                return;
            }
        }
        this.processAffectedChildren(iJavaElementDelta);
    }

    private Object findElementToRefresh(Object object) {
        Object object2 = object;
        if (this.fViewer.testFindItem(object) == null) {
            Object object3 = this.getParent(object);
            if (object3 instanceof IPackageFragmentRoot && this.fInputIsProject) {
                object3 = ((IPackageFragmentRoot)object3).getJavaProject();
            }
            if (object3 != null) {
                object2 = object3;
            }
        }
        return object2;
    }

    private void processAffectedChildren(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        int n = 0;
        while (n < iJavaElementDeltaArray.length) {
            if (!(iJavaElementDeltaArray[n] instanceof ICompilationUnit)) {
                this.processDelta(iJavaElementDeltaArray[n]);
            }
            ++n;
        }
    }

    private void postAdd(final Object object, final Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).add(object2, object);
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).remove(object);
                }
            }
        });
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).refresh(object);
                }
            }
        });
    }

    private void postRunnable(Runnable runnable) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            Display display = Display.getCurrent();
            if (display != null && display.equals(control.getDisplay())) {
                control.getDisplay().syncExec(runnable);
            } else {
                control.getDisplay().asyncExec(runnable);
            }
        }
    }

    private void addElement(IPackageFragment iPackageFragment, Object object) {
        String string = this.getKey(iPackageFragment);
        LogicalPackage logicalPackage = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(string));
        if (logicalPackage != null && logicalPackage.belongs(iPackageFragment)) {
            logicalPackage.add(iPackageFragment);
            return;
        }
        IPackageFragment iPackageFragment2 = (IPackageFragment)this.fMapToPackageFragments.get(string);
        if (iPackageFragment2 != null && !iPackageFragment2.equals(iPackageFragment)) {
            logicalPackage = new LogicalPackage(iPackageFragment2);
            logicalPackage.add(iPackageFragment);
            this.fMapToLogicalPackage.put(string, logicalPackage);
            if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
                if (this.fInputIsProject) {
                    this.postRefresh(iPackageFragmentRoot.getJavaProject());
                } else {
                    this.postRefresh(iPackageFragmentRoot);
                }
            } else {
                this.postAdd((Object)logicalPackage, object);
                this.postRemove(iPackageFragment2);
            }
        } else {
            this.fMapToPackageFragments.put(string, iPackageFragment);
            if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
                if (this.fInputIsProject) {
                    this.postAdd(iPackageFragment, iPackageFragmentRoot.getJavaProject());
                } else {
                    this.postAdd(iPackageFragment, iPackageFragmentRoot);
                }
            } else {
                this.postAdd(iPackageFragment, object);
            }
        }
    }

    private void removeElement(IPackageFragment iPackageFragment) {
        String string = this.getKey(iPackageFragment);
        LogicalPackage logicalPackage = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(string));
        if (logicalPackage != null) {
            logicalPackage.remove(iPackageFragment);
            if (logicalPackage.getFragments().length == 1) {
                IPackageFragment iPackageFragment2 = logicalPackage.getFragments()[0];
                this.fMapToPackageFragments.put(string, iPackageFragment2);
                this.fMapToLogicalPackage.remove(string);
                this.postRemove((Object)logicalPackage);
                Object object = this.getParent(iPackageFragment2);
                if (object instanceof IPackageFragmentRoot) {
                    object = ((IPackageFragmentRoot)object).getJavaProject();
                }
                this.postAdd(iPackageFragment2, object);
            }
        } else {
            IPackageFragment iPackageFragment3 = (IPackageFragment)this.fMapToPackageFragments.get(string);
            if (iPackageFragment3 != null && iPackageFragment3.equals(iPackageFragment)) {
                this.fMapToPackageFragments.remove(string);
                this.postRemove(iPackageFragment);
            }
        }
    }
}

