/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.IPackagesViewViewer;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;

public class PackagesViewTreeViewer
extends ProblemTreeViewer
implements IPackagesViewViewer {
    public PackagesViewTreeViewer(Composite composite, int n) {
        super(composite, n);
        ColoredViewersManager.install((StructuredViewer)this);
    }

    public void mapElement(Object object, Widget widget) {
        if (object instanceof LogicalPackage && widget instanceof Item) {
            LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
            IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment = iPackageFragmentArray[n];
                this.fResourceToItemsMapper.addToMap(iPackageFragment, (Item)widget);
                ++n;
            }
        }
        super.mapElement(object, widget);
    }

    public void unmapElement(Object object, Widget widget) {
        if (object instanceof LogicalPackage && widget instanceof Item) {
            LogicalPackage logicalPackage = (LogicalPackage)((Object)object);
            IPackageFragment[] iPackageFragmentArray = logicalPackage.getFragments();
            int n = 0;
            while (n < iPackageFragmentArray.length) {
                IPackageFragment iPackageFragment = iPackageFragmentArray[n];
                this.fResourceToItemsMapper.removeFromMap(iPackageFragment, (Item)widget);
                ++n;
            }
        }
        super.unmapElement(object, widget);
    }

    protected boolean isFiltered(Object object, Object object2, ViewerFilter[] viewerFilterArray) {
        boolean bl = super.isFiltered(object, object2, viewerFilterArray);
        if (bl && this.isEssential(object)) {
            return false;
        }
        return bl;
    }

    private boolean isEssential(Object object) {
        try {
            LogicalPackage logicalPackage;
            if (object instanceof IPackageFragment) {
                IPackageFragment iPackageFragment = (IPackageFragment)object;
                if (!iPackageFragment.isDefaultPackage() && iPackageFragment.hasSubpackages()) {
                    return this.hasFilteredChildren(iPackageFragment);
                }
            } else if (object instanceof LogicalPackage && !(logicalPackage = (LogicalPackage)((Object)object)).isDefaultPackage() && logicalPackage.hasSubpackages()) {
                return !this.hasFilteredChildren(object);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return false;
    }

    public Widget doFindItem(Object object) {
        return super.doFindItem(object);
    }

    public Widget doFindInputItem(Object object) {
        return super.doFindInputItem(object);
    }

    public List getSelectionFromWidget() {
        return super.getSelectionFromWidget();
    }

    public void doUpdateItem(Widget widget, Object object, boolean bl) {
        super.doUpdateItem(widget, object, bl);
    }

    public void internalRefresh(Object object) {
        super.internalRefresh(object);
    }

    public void setSelectionToWidget(List list, boolean bl) {
        super.setSelectionToWidget(list, bl);
    }
}

