/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareDialog;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class JavaCompareAction
implements IActionDelegate {
    private static final String BUNDLE_NAME = "org.eclipse.wst.jsdt.internal.ui.compare.CompareAction";
    private ISourceReference fLeft;
    private ISourceReference fRight;
    private JavaElementLabelProvider fJavaElementLabelProvider;

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        iAction.setEnabled(this.isEnabled(iSelection));
    }

    public void run(IAction iAction) {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        CompareDialog compareDialog = new CompareDialog(shell, resourceBundle);
        String string = null;
        String string2 = null;
        try {
            string = this.getExtendedSource(this.fLeft);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        try {
            string2 = this.getExtendedSource(this.fRight);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        this.fJavaElementLabelProvider = new JavaElementLabelProvider(82);
        if (string == null || string2 == null) {
            String string3 = JavaCompareUtilities.getString(resourceBundle, "errorTitle");
            String string4 = JavaCompareUtilities.getString(resourceBundle, "errorFormat");
            ISourceReference iSourceReference = null;
            iSourceReference = string == null ? this.fLeft : this.fRight;
            String string5 = Messages.format(string4, new String[]{this.fJavaElementLabelProvider.getText(iSourceReference)});
            MessageDialog.openError((Shell)shell, (String)string3, (String)string5);
            return;
        }
        compareDialog.compare((ICompareInput)new DiffNode((ITypedElement)new TypedElement(this.fLeft, string), (ITypedElement)new TypedElement(this.fRight, string2)));
        this.fJavaElementLabelProvider.dispose();
        this.fJavaElementLabelProvider = null;
    }

    protected boolean isEnabled(ISelection iSelection) {
        Object[] objectArray;
        if (iSelection instanceof IStructuredSelection && (objectArray = ((IStructuredSelection)iSelection).toArray()).length == 2) {
            int n = 0;
            while (n < 2) {
                Object object = objectArray[n];
                if (!(object instanceof ISourceReference)) {
                    return false;
                }
                ++n;
            }
            this.fLeft = (ISourceReference)objectArray[0];
            this.fRight = (ISourceReference)objectArray[1];
            return true;
        }
        return false;
    }

    private String getExtendedSource(ISourceReference iSourceReference) throws JavaModelException {
        ISourceReference iSourceReference2;
        String string;
        IJavaElement iJavaElement;
        if (iSourceReference instanceof IJavaElement && (iJavaElement = ((IJavaElement)iSourceReference).getParent()) instanceof ISourceReference && (string = (iSourceReference2 = (ISourceReference)iJavaElement).getSource()) != null) {
            ISourceRange iSourceRange = iSourceReference2.getSourceRange();
            ISourceRange iSourceRange2 = iSourceReference.getSourceRange();
            int n = iSourceRange2.getOffset() - iSourceRange.getOffset();
            int n2 = n + iSourceRange2.getLength();
            while (n > 0) {
                char c = string.charAt(n - 1);
                if (c == '\n' || c == '\r') break;
                --n;
            }
            return string.substring(n, n2);
        }
        return iSourceReference.getSource();
    }

    class TypedElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private ISourceReference fSource;
        private String fContents;

        TypedElement(ISourceReference iSourceReference, String string) {
            this.fSource = iSourceReference;
            this.fContents = string;
        }

        public String getName() {
            return JavaCompareAction.this.fJavaElementLabelProvider.getText(this.fSource);
        }

        public String getType() {
            return "JAVA";
        }

        public Image getImage() {
            return JavaCompareAction.this.fJavaElementLabelProvider.getImage(this.fSource);
        }

        public InputStream getContents() throws CoreException {
            byte[] byArray;
            try {
                byArray = this.fContents.getBytes("UTF-16");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = this.fContents.getBytes();
            }
            return new ByteArrayInputStream(byArray);
        }

        public String getCharset() {
            return "UTF-16";
        }
    }
}

