/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;

public class JavaTokenComparator
implements ITokenComparator {
    private static final boolean DEBUG = false;
    private final String fText;
    private final ITokenComparatorFactory fTextTokenComparatorFactory;
    private int fCount;
    private int[] fStarts;
    private int[] fLengths;

    public JavaTokenComparator(String string) {
        this(string, null);
    }

    public JavaTokenComparator(String string, ITokenComparatorFactory iTokenComparatorFactory) {
        this.fTextTokenComparatorFactory = iTokenComparatorFactory;
        Assert.isLegal((string != null ? 1 : 0) != 0);
        this.fText = string;
        int n = this.fText.length();
        this.fStarts = new int[n];
        this.fLengths = new int[n];
        this.fCount = 0;
        IScanner iScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
        iScanner.setSource(this.fText.toCharArray());
        int n2 = 0;
        try {
            int n3;
            while ((n3 = iScanner.getNextToken()) != 158) {
                int n4 = iScanner.getCurrentTokenStartPosition();
                int n5 = iScanner.getCurrentTokenEndPosition() + 1;
                if (TokenScanner.isComment(n3) || n3 == 45) {
                    int n6 = this.fTextTokenComparatorFactory == null ? JavaTokenComparator.getCommentStartTokenLength(n3) : 0;
                    this.recordTokenRange(n4, n6);
                    this.parseText(n4 + n6, string.substring(n4 + n6, n5));
                } else {
                    this.recordTokenRange(n4, n5 - n4);
                }
                n2 = n5;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        if (n2 < n) {
            this.recordTokenRange(n2, n - n2);
        }
    }

    private void recordTokenRange(int n, int n2) {
        this.fStarts[this.fCount] = n;
        this.fLengths[this.fCount] = n2;
        ++this.fCount;
    }

    private void parseText(int n, String string) {
        JavaTokenComparator javaTokenComparator = this.fTextTokenComparatorFactory == null ? new JavaTokenComparator(string) : this.fTextTokenComparatorFactory.createTokenComparator(string);
        int n2 = javaTokenComparator.getRangeCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = javaTokenComparator.getTokenStart(n3);
            int n5 = javaTokenComparator.getTokenLength(n3);
            this.recordTokenRange(n + n4, n5);
            ++n3;
        }
    }

    private static int getCommentStartTokenLength(int n) {
        if (n == 1003) {
            return 3;
        }
        if (n == 45) {
            return 1;
        }
        return 2;
    }

    public int getRangeCount() {
        return this.fCount;
    }

    public int getTokenStart(int n) {
        if (n >= 0 && n < this.fCount) {
            return this.fStarts[n];
        }
        if (this.fCount > 0) {
            return this.fStarts[this.fCount - 1] + this.fLengths[this.fCount - 1];
        }
        return 0;
    }

    public int getTokenLength(int n) {
        if (n < this.fCount) {
            return this.fLengths[n];
        }
        return 0;
    }

    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        if (iRangeComparator != null && this.getClass() == iRangeComparator.getClass()) {
            int n3;
            JavaTokenComparator javaTokenComparator = (JavaTokenComparator)iRangeComparator;
            int n4 = this.getTokenLength(n);
            if (n4 == (n3 = javaTokenComparator.getTokenLength(n2))) {
                return this.fText.regionMatches(false, this.getTokenStart(n), javaTokenComparator.fText, javaTokenComparator.getTokenStart(n2), n4);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int n, int n2, IRangeComparator iRangeComparator) {
        if (this.getRangeCount() < 50 || iRangeComparator.getRangeCount() < 50) {
            return false;
        }
        if (n2 < 100) {
            return false;
        }
        if (n < 100) {
            return false;
        }
        if (n2 > 800) {
            return true;
        }
        return n >= n2 / 4;
    }

    public static interface ITokenComparatorFactory {
        public ITokenComparator createTokenComparator(String var1);
    }
}

