/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class MultiMainTypeSelectionDialog
extends ElementListSelectionDialog {
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fStyle;

    public MultiMainTypeSelectionDialog(Shell shell, IRunnableContext iRunnableContext, IJavaSearchScope iJavaSearchScope, int n) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(2114));
        this.setMultipleSelection(true);
        Assert.isNotNull((Object)iRunnableContext);
        Assert.isNotNull((Object)iJavaSearchScope);
        this.fRunnableContext = iRunnableContext;
        this.fScope = iJavaSearchScope;
        this.fStyle = n;
    }

    public int open() {
        Object[] objectArray;
        MainMethodSearchEngine mainMethodSearchEngine = new MainMethodSearchEngine();
        try {
            objectArray = mainMethodSearchEngine.searchMainMethods(this.fRunnableContext, this.fScope, this.fStyle);
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, JavaUIMessages.MultiMainTypeSelectionDialog_errorTitle, invocationTargetException.getMessage());
            return 1;
        }
        this.setElements(objectArray);
        return super.open();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.multi_main_type_selection_dialog_context");
    }
}

