/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TypeInfoViewer;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.wst.jsdt.ui.dialogs.TypeSelectionExtension;

public class TypeSelectionComponent
extends Composite
implements ITypeSelectionComponent {
    private IDialogSettings fSettings;
    private boolean fMultipleSelection;
    private ITitleLabel fTitleLabel;
    private ToolBar fToolBar;
    private ToolItem fToolItem;
    private MenuManager fMenuManager;
    private WorkingSetFilterActionGroup fFilterActionGroup;
    private TypeSelectionExtension fTypeSelectionExtension;
    private Text fFilter;
    private String fInitialFilterText;
    private IJavaSearchScope fScope;
    private TypeInfoViewer fViewer;
    private ViewForm fForm;
    private CLabel fLabel;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static final String DIALOG_SETTINGS = "org.eclipse.wst.jsdt.internal.ui.dialogs.TypeSelectionComponent";
    private static final String SHOW_STATUS_LINE = "show_status_line";
    private static final String FULLY_QUALIFY_DUPLICATES = "fully_qualify_duplicates";
    private static final String WORKINGS_SET_SETTINGS = "workingset_settings";

    public TypeSelectionComponent(Composite composite, int n, String string, boolean bl, IJavaSearchScope iJavaSearchScope, int n2, String string2, ITitleLabel iTitleLabel, TypeSelectionExtension typeSelectionExtension) {
        super(composite, n);
        this.setFont(composite.getFont());
        this.fMultipleSelection = bl;
        this.fScope = iJavaSearchScope;
        this.fInitialFilterText = string2;
        this.fTitleLabel = iTitleLabel;
        this.fTypeSelectionExtension = typeSelectionExtension;
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        this.fSettings = iDialogSettings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            iDialogSettings.addSection(this.fSettings);
        }
        if (this.fSettings.get(SHOW_STATUS_LINE) == null) {
            this.fSettings.put(SHOW_STATUS_LINE, true);
        }
        this.createContent(string, n2);
    }

    public void triggerSearch() {
        this.fViewer.forceSearch();
    }

    public TypeNameMatch[] getSelection() {
        return this.fViewer.getSelection();
    }

    public IJavaSearchScope getScope() {
        return this.fScope;
    }

    private void createContent(final String string, int n) {
        Control control;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Font font = this.getFont();
        Control control2 = this.createHeader(this, font, string);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        control2.setLayoutData((Object)gridData);
        this.fFilter = new Text((Composite)this, 0x800800);
        this.fFilter.setFont(font);
        if (this.fInitialFilterText != null) {
            this.fFilter.setText(this.fInitialFilterText);
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fFilter.setLayoutData((Object)gridData);
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TypeSelectionComponent.this.patternChanged((Text)modifyEvent.widget);
            }
        });
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x1000002) {
                    TypeSelectionComponent.this.fViewer.setFocus();
                }
            }
        });
        this.fFilter.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Strings.removeMnemonicIndicator(string);
            }
        });
        TextFieldNavigationHandler.install(this.fFilter);
        Label label = new Label((Composite)this, 0);
        label.setFont(font);
        label.setText(JavaUIMessages.TypeSelectionComponent_label);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 128 && traverseEvent.doit) {
                    traverseEvent.detail = 0;
                    TypeSelectionComponent.this.fViewer.setFocus();
                }
            }
        });
        label = new Label((Composite)this, 131072);
        label.setFont(font);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.fViewer = new TypeInfoViewer(this, this.fMultipleSelection ? 2 : 0, label, this.fScope, n, this.fInitialFilterText, this.fTypeSelectionExtension != null ? this.fTypeSelectionExtension.getFilterExtension() : null, this.fTypeSelectionExtension != null ? this.fTypeSelectionExtension.getImageProvider() : null);
        gridData = new GridData(1808);
        final Table table = this.fViewer.getTable();
        PixelConverter pixelConverter = new PixelConverter((Control)table);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(70);
        gridData.heightHint = SWTUtil.getTableHeightHint(table, 10);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (table.getSelectionCount() == 0) {
                    accessibleEvent.result = Strings.removeMnemonicIndicator(JavaUIMessages.TypeSelectionComponent_label);
                }
            }
        });
        this.fViewer.setFullyQualifyDuplicates(this.fSettings.getBoolean(FULLY_QUALIFY_DUPLICATES), false);
        if (this.fTypeSelectionExtension != null && (control = this.fTypeSelectionExtension.createContentArea(this)) != null) {
            control.setLayoutData((Object)new GridData(768));
        }
        if (!this.fMultipleSelection) {
            this.fForm = new ViewForm((Composite)this, 0x800800);
            this.fForm.setFont(font);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            boolean bl = this.fSettings.getBoolean(SHOW_STATUS_LINE);
            gridData.exclude = !bl;
            this.fForm.setVisible(bl);
            this.fForm.setLayoutData((Object)gridData);
            this.fLabel = new CLabel((Composite)this.fForm, 0x800000);
            this.fLabel.setFont(this.fForm.getFont());
            this.fForm.setContent((Control)this.fLabel);
            table.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private TypeNameMatchLabelProvider fLabelProvider = new TypeNameMatchLabelProvider(40);

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TypeNameMatch[] typeNameMatchArray = TypeSelectionComponent.this.fViewer.getSelection();
                    if (typeNameMatchArray.length != 1) {
                        TypeSelectionComponent.this.fLabel.setText("");
                        TypeSelectionComponent.this.fLabel.setImage(null);
                    } else {
                        TypeNameMatch typeNameMatch = typeNameMatchArray[0];
                        TypeSelectionComponent.this.fLabel.setText(TypeSelectionComponent.this.fViewer.getLabelProvider().getQualificationText(typeNameMatch));
                        TypeSelectionComponent.this.fLabel.setImage(this.fLabelProvider.getImage(typeNameMatch));
                    }
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TypeSelectionComponent.this.disposeComponent();
            }
        });
        if (this.fTypeSelectionExtension != null) {
            this.fTypeSelectionExtension.initialize(this);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.fViewer.getTable().addSelectionListener(selectionListener);
    }

    public void populate(int n) {
        if (this.fInitialFilterText != null) {
            switch (n) {
                case 1: {
                    this.fFilter.setSelection(0, 0);
                    break;
                }
                case 2: {
                    this.fFilter.setSelection(0, this.fInitialFilterText.length());
                }
            }
        }
        this.fFilter.setFocus();
        this.fViewer.startup();
    }

    private void patternChanged(Text text) {
        this.fViewer.setSearchPattern(text.getText());
    }

    private Control createHeader(Composite composite, Font font, String string) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(string);
        label.setFont(font);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 128 && traverseEvent.doit) {
                    traverseEvent.detail = 0;
                    TypeSelectionComponent.this.fFilter.setFocus();
                }
            }
        });
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.createViewMenu(composite2);
        return composite2;
    }

    private void createViewMenu(Composite composite) {
        this.fToolBar = new ToolBar(composite, 0x800000);
        this.fToolItem = new ToolItem(this.fToolBar, 8, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.fToolBar.setLayoutData((Object)gridData);
        this.fToolItem.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.elcl16view_menu.gif"));
        this.fToolItem.setDisabledImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.dlcl16view_menu.gif"));
        this.fToolItem.setToolTipText(JavaUIMessages.TypeSelectionComponent_menu);
        this.fToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TypeSelectionComponent.this.showViewMenu();
            }
        });
        this.fMenuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.fMenuManager);
    }

    private void showViewMenu() {
        Menu menu = this.fMenuManager.createContextMenu((Control)this.getShell());
        Rectangle rectangle = this.fToolItem.getBounds();
        Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
        point = this.fToolBar.toDisplay(point);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    private void fillViewMenu(IMenuManager iMenuManager) {
        Action action;
        if (!this.fMultipleSelection) {
            action = new ToggleStatusLineAction();
            action.setChecked(this.fSettings.getBoolean(SHOW_STATUS_LINE));
            iMenuManager.add((IAction)action);
        }
        action = new FullyQualifyDuplicatesAction();
        action.setChecked(this.fSettings.getBoolean(FULLY_QUALIFY_DUPLICATES));
        iMenuManager.add((IAction)action);
        if (this.fScope == null) {
            IWorkingSet iWorkingSet;
            this.fFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), JavaPlugin.getActivePage(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue();
                    if (iWorkingSet == null || iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty()) {
                        TypeSelectionComponent.this.fScope = SearchEngine.createWorkspaceScope();
                        TypeSelectionComponent.this.fTitleLabel.setText(null);
                    } else {
                        TypeSelectionComponent.this.fScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(iWorkingSet, true);
                        TypeSelectionComponent.this.fTitleLabel.setText(iWorkingSet.getLabel());
                    }
                    TypeSelectionComponent.this.fViewer.setSearchScope(TypeSelectionComponent.this.fScope, true);
                }
            });
            String string = this.fSettings.get(WORKINGS_SET_SETTINGS);
            if (string != null) {
                try {
                    iWorkingSet = XMLMemento.createReadRoot((Reader)new StringReader(string));
                    this.fFilterActionGroup.restoreState((IMemento)iWorkingSet);
                }
                catch (WorkbenchException workbenchException) {}
            }
            if ((iWorkingSet = this.fFilterActionGroup.getWorkingSet()) == null || iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty()) {
                this.fScope = SearchEngine.createWorkspaceScope();
                this.fTitleLabel.setText(null);
            } else {
                this.fScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(iWorkingSet, true);
                this.fTitleLabel.setText(iWorkingSet.getLabel());
            }
            this.fFilterActionGroup.fillViewMenu(iMenuManager);
        }
    }

    private void disposeComponent() {
        if (this.fFilterActionGroup != null) {
            XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"workingSet");
            this.fFilterActionGroup.saveState((IMemento)xMLMemento);
            this.fFilterActionGroup.dispose();
            StringWriter stringWriter = new StringWriter();
            try {
                xMLMemento.save((Writer)stringWriter);
                this.fSettings.put(WORKINGS_SET_SETTINGS, stringWriter.getBuffer().toString());
            }
            catch (IOException iOException) {}
        }
    }

    private class FullyQualifyDuplicatesAction
    extends Action {
        public FullyQualifyDuplicatesAction() {
            super(JavaUIMessages.TypeSelectionComponent_fully_qualify_duplicates_label, 2);
        }

        public void run() {
            boolean bl = this.isChecked();
            TypeSelectionComponent.this.fViewer.setFullyQualifyDuplicates(bl, true);
            TypeSelectionComponent.this.fSettings.put(TypeSelectionComponent.FULLY_QUALIFY_DUPLICATES, bl);
        }
    }

    public static interface ITitleLabel {
        public void setText(String var1);
    }

    private class ToggleStatusLineAction
    extends Action {
        public ToggleStatusLineAction() {
            super(JavaUIMessages.TypeSelectionComponent_show_status_line_label, 2);
        }

        public void run() {
            if (TypeSelectionComponent.this.fForm == null) {
                return;
            }
            GridData gridData = (GridData)TypeSelectionComponent.this.fForm.getLayoutData();
            boolean bl = this.isChecked();
            gridData.exclude = !bl;
            TypeSelectionComponent.this.fForm.setVisible(bl);
            TypeSelectionComponent.this.fSettings.put(TypeSelectionComponent.SHOW_STATUS_LINE, bl);
            TypeSelectionComponent.this.layout();
        }
    }
}

