/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.StringFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class StringCleanUp
extends AbstractCleanUp {
    public StringCleanUp(Map map) {
        super(map);
    }

    public StringCleanUp() {
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        return this.isEnabled("cleanup.add_missing_nls_tags") || this.isEnabled("cleanup.remove_unnecessary_nls_tags");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.add_missing_nls_tags"), this.isEnabled("cleanup.remove_unnecessary_nls_tags"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, iProblemLocationArray, this.isEnabled("cleanup.add_missing_nls_tags"), this.isEnabled("cleanup.remove_unnecessary_nls_tags"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_missing_nls_tags") || this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        }
        return hashtable;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_missing_nls_tags")) {
            arrayList.add(MultiFixMessages.StringMultiFix_AddMissingNonNls_description);
        }
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            arrayList.add(MultiFixMessages.StringMultiFix_RemoveUnnecessaryNonNls_description);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            stringBuffer.append("var s=\"\";");
        } else {
            stringBuffer.append("var s=\"\"; //$NON-NLS-1$");
        }
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        return StringFix.createFix(compilationUnit, iProblemLocation, this.isEnabled("cleanup.remove_unnecessary_nls_tags"), this.isEnabled("cleanup.add_missing_nls_tags")) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int n = 0;
        IProblem[] iProblemArray = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.add_missing_nls_tags")) {
            n += this.getNumberOfProblems(iProblemArray, 536871173);
        }
        if (this.isEnabled("cleanup.remove_unnecessary_nls_tags")) {
            n += this.getNumberOfProblems(iProblemArray, 536871177);
        }
        return n;
    }
}

