/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class UnnecessaryCodeCleanUp
extends AbstractCleanUp {
    public UnnecessaryCodeCleanUp(Map map) {
        super(map);
    }

    public UnnecessaryCodeCleanUp() {
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        return this.isEnabled("cleanup.remove_unnecessary_casts");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, iProblemLocationArray, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        }
        return hashtable;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            arrayList.add(MultiFixMessages.UnusedCodeCleanUp_RemoveUnusedCasts_description);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        IFix iFix;
        return this.isEnabled("cleanup.remove_unnecessary_casts") && (iFix = UnusedCodeFix.createRemoveUnusedCastFix(compilationUnit, iProblemLocation)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int n = 0;
        IProblem[] iProblemArray = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            n += this.getNumberOfProblems(iProblemArray, 553648309);
        }
        return n;
    }
}

