/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class UnusedCodeCleanUp
extends AbstractCleanUp {
    public UnusedCodeCleanUp(Map map) {
        super(map);
    }

    public UnusedCodeCleanUp() {
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        boolean bl = this.isEnabled("cleanup.remove_unused_private_members");
        return bl && this.isEnabled("cleanup.remove_unused_private_methods") || bl && this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_local_variables");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFix.createCleanUp(compilationUnit, bl && this.isEnabled("cleanup.remove_unused_private_methods"), bl && this.isEnabled("cleanup.remove_private_constructors"), bl && this.isEnabled("cleanup.remove_unused_private_fields"), bl && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false);
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFix.createCleanUp(compilationUnit, iProblemLocationArray, bl && this.isEnabled("cleanup.remove_unused_private_methods"), bl && this.isEnabled("cleanup.remove_private_constructors"), bl && this.isEnabled("cleanup.remove_unused_private_fields"), bl && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false);
    }

    public Map getRequiredOptions() {
        boolean bl;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedImport", "warning");
        }
        if ((bl = this.isEnabled("cleanup.remove_unused_private_members")) && (this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_private_types"))) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "warning");
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            hashtable.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "warning");
        }
        return hashtable;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            arrayList.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedMethod_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            arrayList.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedField_description);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            arrayList.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedVariable_description);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_fields")) {
            stringBuffer.append("    var fField;\n");
        }
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_methods")) {
            stringBuffer.append("    function foo() {}\n");
        }
        stringBuffer.append("    function bar() {\n");
        if (!this.isEnabled("cleanup.remove_unused_local_variables")) {
            stringBuffer.append("        var i= 10;\n");
        }
        stringBuffer.append("    }\n");
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        UnusedCodeFix unusedCodeFix;
        if (this.isEnabled("cleanup.remove_unused_imports") && (unusedCodeFix = UnusedCodeFix.createRemoveUnusedImportFix(compilationUnit, iProblemLocation)) != null) {
            return true;
        }
        return (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_local_variables")) && (unusedCodeFix = UnusedCodeFix.createUnusedMemberFix(compilationUnit, iProblemLocation, false)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int n = 0;
        IProblem[] iProblemArray = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            int n2 = 0;
            while (n2 < iProblemArray.length) {
                int n3 = iProblemArray[n2].getID();
                if (n3 == 268435844 || n3 == 268435842 || n3 == 0x10000181 || n3 == 268435843 || n3 == 268435846) {
                    ++n;
                }
                ++n2;
            }
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            n += this.getNumberOfProblems(iProblemArray, 603979894);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors")) {
            n += this.getNumberOfProblems(iProblemArray, 603979910);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types")) {
            n += this.getNumberOfProblems(iProblemArray, 553648135);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            n += this.getNumberOfProblems(iProblemArray, 570425421);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            n += this.getNumberOfProblems(iProblemArray, 536870973);
        }
        return n;
    }
}

