/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarimport;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.jarimport.JarImportData;
import org.eclipse.wst.jsdt.internal.ui.jarimport.JarImportMessages;
import org.eclipse.wst.jsdt.internal.ui.jarimport.JarImportWizardPage;
import org.eclipse.wst.jsdt.internal.ui.refactoring.binary.BinaryRefactoringHistoryWizard;

public final class JarImportWizard
extends BinaryRefactoringHistoryWizard
implements IImportWizard {
    private static String DIALOG_SETTINGS_KEY = "JarImportWizard";
    private final RefactoringHistoryProxy fHistoryProxy;
    private final JarImportData fImportData = new JarImportData();
    private JarImportWizardPage fImportPage = null;
    private boolean fImportWizard = true;
    private boolean fNewSettings;

    public static boolean isValidClassPathEntry(IClasspathEntry iClasspathEntry) {
        Assert.isNotNull((Object)iClasspathEntry);
        int n = iClasspathEntry.getEntryKind();
        if (n == 1) {
            return iClasspathEntry.getContentKind() == 2;
        }
        return n == 4;
    }

    public static boolean isValidJavaProject(IJavaProject iJavaProject) throws JavaModelException {
        Assert.isNotNull((Object)iJavaProject);
        return iJavaProject.getProject().isAccessible();
    }

    public JarImportWizard() {
        super(JarImportMessages.JarImportWizard_window_title, JarImportMessages.RefactoringImportPreviewPage_title, JarImportMessages.RefactoringImportPreviewPage_description);
        this.fImportData.setRefactoringAware(true);
        this.fImportData.setIncludeDirectoryEntries(true);
        this.fHistoryProxy = new RefactoringHistoryProxy();
        this.setInput(this.fHistoryProxy);
        IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (iDialogSettings == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(iDialogSettings);
        }
        this.setConfiguration(new RefactoringHistoryControlConfiguration(null, false, false){

            public String getProjectPattern() {
                return JarImportMessages.JarImportWizard_project_pattern;
            }

            public String getWorkspaceCaption() {
                return JarImportMessages.JarImportWizard_workspace_caption;
            }
        });
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_REPLACE_JAR);
    }

    public JarImportWizard(boolean bl) {
        this();
        this.fImportWizard = bl;
        this.setWindowTitle(JarImportMessages.JarImportWizard_replace_title);
    }

    protected void addUserDefinedPages() {
        this.fImportPage = new JarImportWizardPage(this, this.fImportWizard);
        this.addPage((IWizardPage)this.fImportPage);
    }

    public boolean canFinish() {
        return super.canFinish() && this.fImportData.getPackageFragmentRoot() != null && this.fImportData.getRefactoringFileLocation() != null;
    }

    protected boolean deconfigureClasspath(IClasspathEntry[] iClasspathEntryArray, IProgressMonitor iProgressMonitor) throws CoreException {
        IPackageFragmentRoot iPackageFragmentRoot;
        boolean bl = this.fImportData.isRenameJarFile();
        if (bl && !this.fCancelled && (iPackageFragmentRoot = this.getPackageFragmentRoot()) != null) {
            IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                IPath iPath;
                if (iClasspathEntryArray[n].equals(iClasspathEntry) && (iPath = this.getTargetPath(iClasspathEntryArray[n])) != null) {
                    iClasspathEntryArray[n] = JavaCore.newLibraryEntry((IPath)iPath, (IPath)iClasspathEntryArray[n].getSourceAttachmentPath(), (IPath)iClasspathEntryArray[n].getSourceAttachmentRootPath(), (IAccessRule[])iClasspathEntryArray[n].getAccessRules(), (IClasspathAttribute[])iClasspathEntryArray[n].getExtraAttributes(), (boolean)iClasspathEntryArray[n].isExported());
                }
                ++n;
            }
        }
        if (!this.fCancelled) {
            this.replaceJarFile((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100, 2));
        }
        return bl;
    }

    public JarImportData getImportData() {
        return this.fImportData;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (iWizardPage == this.fImportPage && this.fImportData.getRefactoringHistory() == null) {
            return null;
        }
        return super.getNextPage(iWizardPage);
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fImportData.getPackageFragmentRoot();
    }

    protected RefactoringHistory getRefactoringHistory() {
        return this.fHistoryProxy;
    }

    private IPath getTargetPath(IClasspathEntry iClasspathEntry) throws CoreException {
        URI uRI;
        URI uRI2 = JarImportWizard.getLocationURI(iClasspathEntry);
        if (uRI2 != null && (uRI = this.getTargetURI(uRI2)) != null) {
            IPath iPath;
            IPath iPath2 = URIUtil.toPath((URI)uRI);
            if (iPath2 != null && (iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation()).isPrefixOf(iPath2)) {
                iPath2 = iPath2.removeFirstSegments(iPath.segmentCount());
                iPath2 = iPath2.setDevice(null);
                iPath2 = iPath2.makeAbsolute();
            }
            return iPath2;
        }
        return null;
    }

    private URI getTargetURI(URI uRI) throws CoreException {
        URI uRI2;
        IFileStore iFileStore = EFS.getStore((URI)uRI).getParent();
        if (iFileStore != null && (uRI2 = this.fImportData.getRefactoringFileLocation()) != null) {
            return iFileStore.getChild(EFS.getStore((URI)uRI2).getName()).toURI();
        }
        return uRI;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection != null && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
            try {
                IClasspathEntry iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                if (JarImportWizard.isValidClassPathEntry(iClasspathEntry)) {
                    this.fImportData.setPackageFragmentRoot(iPackageFragmentRoot);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
    }

    public boolean performFinish() {
        if (this.fNewSettings) {
            IDialogSettings iDialogSettings = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_KEY);
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(iDialogSettings2);
        }
        this.fImportPage.performFinish();
        return super.performFinish();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceJarFile(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            URI uRI;
            IPackageFragmentRoot iPackageFragmentRoot;
            iProgressMonitor.beginTask(JarImportMessages.JarImportWizard_cleanup_import, 250);
            URI uRI2 = this.fImportData.getRefactoringFileLocation();
            if (uRI2 == null || (iPackageFragmentRoot = this.fImportData.getPackageFragmentRoot()) == null || (uRI = JarImportWizard.getLocationURI(iPackageFragmentRoot.getRawClasspathEntry())) == null) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, JarImportMessages.JarImportWizard_error_copying_jar, null));
            IFileStore iFileStore = EFS.getStore((URI)uRI2);
            if (this.fImportData.isRenameJarFile()) {
                URI uRI3 = this.getTargetURI(uRI);
                iFileStore.copy(EFS.getStore((URI)uRI3), 2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50, 2));
                if (!uRI.equals(uRI3)) {
                    EFS.getStore((URI)uRI).delete(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50, 2));
                }
            } else {
                iFileStore.copy(EFS.getStore((URI)uRI), 2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100, 2));
            }
            if (this.fJavaProject != null) {
                this.fJavaProject.getResource().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50, 2));
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    static /* synthetic */ JarImportData access$0(JarImportWizard jarImportWizard) {
        return jarImportWizard.fImportData;
    }

    private final class RefactoringHistoryProxy
    extends RefactoringHistory {
        private RefactoringDescriptorProxy[] fHistoryDelta = null;

        private RefactoringHistoryProxy() {
        }

        /*
         * Exception decompiling
         */
        public RefactoringDescriptorProxy[] getDescriptors() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [1 : 185->191)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean isEmpty() {
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = this.getDescriptors();
            if (refactoringDescriptorProxyArray != null) {
                return refactoringDescriptorProxyArray.length == 0;
            }
            return true;
        }

        public RefactoringHistory removeAll(RefactoringHistory refactoringHistory) {
            throw new UnsupportedOperationException();
        }
    }
}

