/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.util.IClassFileReader;
import org.eclipse.wst.jsdt.core.util.ISourceAttribute;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;
import org.eclipse.wst.jsdt.ui.jarpackager.JarWriter3;

public class JarFileExportOperation
extends WorkspaceModifyOperation
implements IJarExportRunnable {
    private JarWriter3 fJarWriter;
    private JarPackageData fJarPackage;
    private JarPackageData[] fJarPackages;
    private Shell fParentShell;
    private Map fJavaNameToClassFilesMap;
    private IContainer fClassFilesMapContainer;
    private Set fExportedClassContainers;
    private MessageMultiStatus fStatus;
    private StandardJavaElementContentProvider fJavaElementContentProvider;
    private boolean fFilesSaved;

    public JarFileExportOperation(JarPackageData jarPackageData, Shell shell) {
        this(new JarPackageData[]{jarPackageData}, shell);
    }

    public JarFileExportOperation(JarPackageData[] jarPackageDataArray, Shell shell) {
        this(shell);
        this.fJarPackages = jarPackageDataArray;
    }

    private JarFileExportOperation(Shell shell) {
        this.fParentShell = shell;
        this.fStatus = new MessageMultiStatus(JavaPlugin.getPluginId(), 0, "", null);
        this.fJavaElementContentProvider = new StandardJavaElementContentProvider();
    }

    private void addToStatus(CoreException coreException) {
        IStatus iStatus = coreException.getStatus();
        String string = coreException.getLocalizedMessage();
        if (string == null || string.length() < 1) {
            string = JarPackagerMessages.JarFileExportOperation_coreErrorDuringExport;
            iStatus = new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), string, (Throwable)coreException);
        }
        this.fStatus.add(iStatus);
    }

    protected void addInfo(String string, Throwable throwable) {
        this.fStatus.add((IStatus)new Status(1, JavaPlugin.getPluginId(), 10001, string, throwable));
    }

    private void addWarning(String string, Throwable throwable) {
        this.fStatus.add((IStatus)new Status(2, JavaPlugin.getPluginId(), 10001, string, throwable));
    }

    private void addError(String string, Throwable throwable) {
        this.fStatus.add((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, throwable));
    }

    private int countSelectedElements() {
        IContainer[] iContainerArray;
        Object object;
        HashSet<IContainer[]> hashSet = new HashSet<IContainer[]>(10);
        int n = 0;
        int n2 = this.fJarPackage.getElements().length;
        int n3 = 0;
        while (n3 < n2) {
            block11: {
                IResource iResource;
                block13: {
                    block12: {
                        object = this.fJarPackage.getElements()[n3];
                        iContainerArray = this.getEnclosingJavaProject(object);
                        if (iContainerArray != null) {
                            hashSet.add(iContainerArray);
                        }
                        iResource = null;
                        if (!(object instanceof IJavaElement)) break block12;
                        IJavaElement iJavaElement = (IJavaElement)object;
                        try {
                            iResource = iJavaElement.getUnderlyingResource();
                        }
                        catch (JavaModelException javaModelException) {
                            break block11;
                        }
                        if (iResource != null) break block13;
                        break block11;
                    }
                    iResource = (IResource)object;
                }
                if (iResource != null) {
                    n = iResource.getType() == 1 ? ++n : (n += this.getTotalChildCount((IContainer)iResource));
                }
            }
            ++n3;
        }
        if (this.fJarPackage.areOutputFoldersExported()) {
            if (!this.fJarPackage.areJavaFilesExported()) {
                n = 0;
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (IJavaProject)iterator.next();
                try {
                    iContainerArray = this.getOutputContainers((IJavaProject)object);
                }
                catch (CoreException coreException) {
                    this.addToStatus(coreException);
                    continue;
                }
                int n4 = 0;
                while (n4 < iContainerArray.length) {
                    n += this.getTotalChildCount(iContainerArray[n4]);
                    ++n4;
                }
            }
        }
        return n;
    }

    private int getTotalChildCount(IContainer iContainer) {
        IResource[] iResourceArray;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            n = iResourceArray[n2].getType() == 1 ? ++n : (n += this.getTotalChildCount((IContainer)iResourceArray[n2]));
            ++n2;
        }
        return n;
    }

    private void exportElement(Object object, IProgressMonitor iProgressMonitor) throws InterruptedException {
        IJavaElement iJavaElement;
        int n = 1;
        IPackageFragmentRoot iPackageFragmentRoot = null;
        boolean bl = false;
        IResource iResource = null;
        ITypeRoot iTypeRoot = null;
        IJavaProject iJavaProject = null;
        if (object instanceof IJavaElement) {
            bl = true;
            iJavaElement = (IJavaElement)object;
            if (!(iJavaElement instanceof ITypeRoot)) {
                this.exportJavaElement(iProgressMonitor, iJavaElement);
                return;
            }
            iTypeRoot = (ITypeRoot)iJavaElement;
            iJavaProject = iTypeRoot.getJavaProject();
            iPackageFragmentRoot = JavaModelUtil.getPackageFragmentRoot(iJavaElement);
            iResource = iTypeRoot.getResource();
        } else {
            iResource = (IResource)object;
        }
        if (!iResource.isAccessible()) {
            this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_resourceNotFound, iResource.getFullPath()), null);
            return;
        }
        if (iResource.getType() == 1) {
            if (!bl) {
                try {
                    bl = iResource.getProject().hasNature("org.eclipse.wst.jsdt.core.jsNature");
                }
                catch (CoreException coreException) {
                    this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_projectNatureNotDeterminable, iResource.getFullPath()), coreException);
                    return;
                }
                if (bl) {
                    iJavaProject = JavaCore.create((IProject)iResource.getProject());
                    try {
                        iJavaElement = iJavaProject.findPackageFragment(iResource.getFullPath().removeLastSegments(1));
                        iPackageFragmentRoot = iJavaElement != null ? JavaModelUtil.getPackageFragmentRoot(iJavaElement) : this.findPackageFragmentRoot(iJavaProject, iResource.getFullPath().removeLastSegments(1));
                    }
                    catch (JavaModelException javaModelException) {
                        this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_javaPackageNotDeterminable, iResource.getFullPath()), javaModelException);
                        return;
                    }
                }
            }
            if (iPackageFragmentRoot != null && iJavaProject != null) {
                n = iPackageFragmentRoot.getPath().segmentCount();
                boolean bl2 = iJavaProject.isOnClasspath(iResource);
                if (!bl2 || this.mustUseSourceFolderHierarchy() && !iPackageFragmentRoot.getElementName().equals("")) {
                    --n;
                }
            }
            IPath iPath = iResource.getFullPath().removeFirstSegments(n);
            boolean bl3 = false;
            if (bl && iJavaProject != null) {
                try {
                    bl3 = iJavaProject.getOutputLocation().isPrefixOf(iResource.getFullPath());
                }
                catch (JavaModelException javaModelException) {
                    bl3 = false;
                }
            }
            if (iTypeRoot != null) {
                this.exportClassFiles(iProgressMonitor, iTypeRoot, iPath);
            }
            this.exportResource(iProgressMonitor, iPackageFragmentRoot, bl, iResource, iPath, bl3);
            iProgressMonitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)iProgressMonitor);
        } else {
            this.exportContainer(iProgressMonitor, (IContainer)iResource);
        }
    }

    private void exportJavaElement(IProgressMonitor iProgressMonitor, IJavaElement iJavaElement) throws InterruptedException {
        if (iJavaElement.getElementType() == 3 && ((IPackageFragmentRoot)iJavaElement).isArchive()) {
            return;
        }
        Object[] objectArray = this.fJavaElementContentProvider.getChildren(iJavaElement);
        int n = 0;
        while (n < objectArray.length) {
            this.exportElement(objectArray[n], iProgressMonitor);
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportResource(IProgressMonitor var1_1, IResource var2_2, int var3_3) throws InterruptedException {
        if (var2_2 instanceof IContainer) {
            var4_4 = (IContainer)var2_2;
            try {
                var5_7 = var4_4.members();
            }
            catch (CoreException var6_9) {
                this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_errorDuringExport, var4_4.getFullPath()), var6_9);
                return;
            }
            var6_10 = 0;
            while (true) {
                if (var6_10 >= var5_7.length) {
                    return;
                }
                this.exportResource(var1_1, var5_7[var6_10], var3_3);
                ++var6_10;
            }
        }
        if (var2_2 instanceof IFile == false) return;
        try {
            try {
                var4_5 = var2_2.getFullPath().removeFirstSegments(var3_3);
                var1_1.subTask(Messages.format(JarPackagerMessages.JarFileExportOperation_exporting, var4_5.toString()));
                this.fJarWriter.write((IFile)var2_2, var4_5);
            }
            catch (CoreException var4_6) {
                block10: {
                    var5_8 = var4_6.getStatus().getException();
                    if (!(var5_8 instanceof ZipException) || var5_8.getMessage() == null || !var5_8.getMessage().startsWith("duplicate entry:")) break block10;
                    this.addWarning(var4_6.getMessage(), var5_8);
                    ** GOTO lbl-1000
                }
                this.addToStatus(var4_6);
            }
        }
        catch (Throwable var7_13) {
            var6_11 = null;
            var1_1.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)var1_1);
            throw var7_13;
        }
lbl-1000:
        // 3 sources

        {
            var6_12 = null;
        }
        var1_1.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)var1_1);
    }

    private void exportContainer(IProgressMonitor iProgressMonitor, IContainer iContainer) throws InterruptedException {
        if (iContainer.getType() == 2 && this.isOutputFolder((IFolder)iContainer)) {
            return;
        }
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_errorDuringExport, iContainer.getFullPath()), coreException);
        }
        if (iResourceArray != null) {
            int n = 0;
            while (n < iResourceArray.length) {
                this.exportElement(iResourceArray[n], iProgressMonitor);
                ++n;
            }
        }
    }

    private IPackageFragmentRoot findPackageFragmentRoot(IJavaProject iJavaProject, IPath iPath) throws JavaModelException {
        if (iJavaProject == null || iPath == null || iPath.segmentCount() <= 0) {
            return null;
        }
        IPackageFragmentRoot iPackageFragmentRoot = iJavaProject.findPackageFragmentRoot(iPath);
        if (iPackageFragmentRoot != null) {
            return iPackageFragmentRoot;
        }
        return this.findPackageFragmentRoot(iJavaProject, iPath.removeLastSegments(1));
    }

    private void exportResource(IProgressMonitor iProgressMonitor, IPackageFragmentRoot iPackageFragmentRoot, boolean bl, IResource iResource, IPath iPath, boolean bl2) {
        if (this.fJarPackage.areClassFilesExported() && iPath.toString().equals("META-INF/MANIFEST.MF")) {
            if (this.fJarPackage.isManifestGenerated()) {
                this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_didNotAddManifestToJar, iResource.getFullPath()), null);
            }
            return;
        }
        boolean bl3 = !bl || iPackageFragmentRoot == null;
        boolean bl4 = false;
        try {
            bl4 = iPackageFragmentRoot != null && !iPackageFragmentRoot.isArchive() && iPackageFragmentRoot.getKind() == 2;
        }
        catch (JavaModelException javaModelException) {
            this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_cantGetRootKind, iResource.getFullPath()), javaModelException);
        }
        if (this.fJarPackage.areClassFilesExported() && (bl3 || iPackageFragmentRoot != null && !this.isJavaFile(iResource) && !this.isClassFile(iResource) || bl4 && this.isClassFile(iResource)) || this.fJarPackage.areJavaFilesExported() && (bl3 || iPackageFragmentRoot != null && !this.isClassFile(iResource) || bl4 && this.isClassFile(iResource) && !this.fJarPackage.areClassFilesExported())) {
            try {
                iProgressMonitor.subTask(Messages.format(JarPackagerMessages.JarFileExportOperation_exporting, iPath.toString()));
                this.fJarWriter.write((IFile)iResource, iPath);
            }
            catch (CoreException coreException) {
                Throwable throwable = coreException.getStatus().getException();
                if (throwable instanceof ZipException && throwable.getMessage() != null && throwable.getMessage().startsWith("duplicate entry:")) {
                    this.addWarning(coreException.getMessage(), throwable);
                }
                this.addToStatus(coreException);
            }
        }
    }

    private boolean isOutputFolder(IFolder iFolder) {
        try {
            IJavaProject iJavaProject = JavaCore.create((IProject)iFolder.getProject());
            IPath iPath = iJavaProject.getOutputLocation();
            return iFolder.getFullPath().equals((Object)iPath);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void exportClassFiles(IProgressMonitor iProgressMonitor, ITypeRoot iTypeRoot, IPath iPath) {
        if (this.fJarPackage.areClassFilesExported()) {
            try {
                if (!iTypeRoot.exists()) {
                    return;
                }
                Iterator iterator = this.filesOnClasspath(iTypeRoot, iPath, iProgressMonitor);
                IPath iPath2 = iPath.removeLastSegments(1);
                while (iterator.hasNext()) {
                    IFile iFile = (IFile)iterator.next();
                    IPath iPath3 = iPath2.append(iFile.getName());
                    iProgressMonitor.subTask(Messages.format(JarPackagerMessages.JarFileExportOperation_exporting, iPath3.toString()));
                    this.fJarWriter.write(iFile, iPath3);
                }
            }
            catch (CoreException coreException) {
                this.addToStatus(coreException);
            }
        }
    }

    private void exportSelectedElements(IProgressMonitor iProgressMonitor) throws InterruptedException {
        this.fExportedClassContainers = new HashSet(10);
        HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>(10);
        int n = this.fJarPackage.getElements().length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject;
            Object object = this.fJarPackage.getElements()[n2];
            this.exportElement(object, iProgressMonitor);
            if (this.fJarPackage.areOutputFoldersExported() && (iJavaProject = this.getEnclosingJavaProject(object)) != null) {
                hashSet.add(iJavaProject);
            }
            ++n2;
        }
        if (this.fJarPackage.areOutputFoldersExported()) {
            this.exportOutputFolders(iProgressMonitor, hashSet);
        }
    }

    private IJavaProject getEnclosingJavaProject(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getJavaProject();
        }
        if (object instanceof IResource) {
            IProject iProject = ((IResource)object).getProject();
            try {
                if (iProject.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                    return JavaCore.create((IProject)iProject);
                }
            }
            catch (CoreException coreException) {
                this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_projectNatureNotDeterminable, iProject.getFullPath()), coreException);
            }
        }
        return null;
    }

    private void exportOutputFolders(IProgressMonitor iProgressMonitor, Set set) throws InterruptedException {
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IContainer[] iContainerArray;
            IJavaProject iJavaProject = (IJavaProject)iterator.next();
            try {
                iContainerArray = this.getOutputContainers(iJavaProject);
            }
            catch (CoreException coreException) {
                this.addToStatus(coreException);
                continue;
            }
            int n = 0;
            while (n < iContainerArray.length) {
                this.exportResource(iProgressMonitor, (IResource)iContainerArray[n], iContainerArray[n].getFullPath().segmentCount());
                ++n;
            }
        }
    }

    private IContainer[] getOutputContainers(IJavaProject iJavaProject) throws CoreException {
        IPath iPath;
        Object object;
        HashSet<IPath> hashSet = new HashSet<IPath>();
        boolean bl = false;
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            if (iPackageFragmentRootArray[n] != null && (object = iPackageFragmentRootArray[n].getRawClasspathEntry()).getEntryKind() == 3) {
                iPath = object.getOutputLocation();
                if (iPath != null) {
                    hashSet.add(iPath);
                } else {
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            hashSet.add(iJavaProject.getOutputLocation());
        }
        HashSet<Object> hashSet2 = new HashSet<Object>(hashSet.size());
        object = hashSet.iterator();
        while (object.hasNext()) {
            iPath = (IPath)object.next();
            if (iJavaProject.getProject().getFullPath().equals((Object)iPath)) {
                hashSet2.add(iJavaProject.getProject());
                continue;
            }
            IFolder iFolder = this.createFolderHandle(iPath);
            if (iFolder == null || !iFolder.isAccessible()) {
                String string = JarPackagerMessages.JarFileExportOperation_outputContainerNotAccessible;
                this.addToStatus(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, null)));
                continue;
            }
            hashSet2.add(iFolder);
        }
        return hashSet2.toArray(new IContainer[hashSet2.size()]);
    }

    private Iterator filesOnClasspath(ITypeRoot iTypeRoot, IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        IClasspathEntry iClasspathEntry;
        IFile iFile = (IFile)iTypeRoot.getResource();
        IJavaProject iJavaProject = iTypeRoot.getJavaProject();
        IPackageFragmentRoot iPackageFragmentRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)iTypeRoot);
        IFile[] iFileArray = this.fJarPackage.findClassfilesFor(iFile);
        if (iFileArray != null) {
            return Arrays.asList(iFileArray).iterator();
        }
        if (!this.isJavaFile((IResource)iFile)) {
            return Collections.EMPTY_LIST.iterator();
        }
        IPath iPath2 = null;
        if (iPackageFragmentRoot != null && (iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry()).getEntryKind() == 3) {
            iPath2 = iClasspathEntry.getOutputLocation();
        }
        if (iPath2 == null) {
            iPath2 = iJavaProject.getOutputLocation();
        }
        if (iJavaProject.getProject().getFullPath().equals((Object)iPath2)) {
            iClasspathEntry = iJavaProject.getProject();
        } else {
            iClasspathEntry = this.createFolderHandle(iPath2);
            if (iClasspathEntry == null || !iClasspathEntry.isAccessible()) {
                String string = JarPackagerMessages.JarFileExportOperation_outputContainerNotAccessible;
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, null));
            }
        }
        boolean bl = this.hasCompileErrors((IResource)iFile);
        boolean bl2 = this.hasCompileWarnings((IResource)iFile);
        boolean bl3 = this.canBeExported(bl, bl2);
        if (!bl3) {
            return Collections.EMPTY_LIST.iterator();
        }
        this.reportPossibleCompileProblems(iFile, bl, bl2, bl3);
        IClasspathEntry iClasspathEntry2 = iClasspathEntry;
        if (iPath.segmentCount() > 1) {
            iClasspathEntry2 = iClasspathEntry.getFolder(iPath.removeLastSegments(1));
        }
        if (this.fExportedClassContainers.contains(iClasspathEntry2)) {
            return Collections.EMPTY_LIST.iterator();
        }
        if ("enabled".equals(iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", true))) {
            ArrayList arrayList;
            if (this.fClassFilesMapContainer == null || !this.fClassFilesMapContainer.equals((Object)iClasspathEntry2)) {
                this.fJavaNameToClassFilesMap = this.buildJavaToClassMap((IContainer)iClasspathEntry2, iProgressMonitor);
                if (this.fJavaNameToClassFilesMap == null) {
                    String string = iClasspathEntry2.getFullPath().toString();
                    String string2 = Messages.format(JarPackagerMessages.JarFileExportOperation_missingSourceFileAttributeExportedAll, string);
                    this.addInfo(string2, null);
                    this.fExportedClassContainers.add(iClasspathEntry2);
                    return this.getClassesIn((IContainer)iClasspathEntry2);
                }
                this.fClassFilesMapContainer = iClasspathEntry2;
            }
            if ((arrayList = (ArrayList)this.fJavaNameToClassFilesMap.get(iFile.getName())) == null || arrayList.isEmpty()) {
                String string = Messages.format(JarPackagerMessages.JarFileExportOperation_classFileOnClasspathNotAccessible, iFile.getFullPath());
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, null));
            }
            return arrayList.iterator();
        }
        IRegion iRegion = JavaCore.newRegion();
        iRegion.add((IJavaElement)iTypeRoot);
        IResource[] iResourceArray = JavaCore.getGeneratedResources((IRegion)iRegion, (boolean)false);
        return Arrays.asList(iResourceArray).iterator();
    }

    private Iterator getClassesIn(IContainer iContainer) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iResourceArray.length);
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n].getType() == 1 && this.isClassFile(iResourceArray[n])) {
                arrayList.add(iResourceArray[n]);
            }
            ++n;
        }
        return arrayList.iterator();
    }

    private boolean isJavaFile(IResource iResource) {
        return iResource != null && iResource.getType() == 1 && iResource.getFileExtension() != null && JavaCore.isJavaLikeFileName((String)iResource.getName());
    }

    private boolean isClassFile(IResource iResource) {
        return iResource != null && iResource.getType() == 1 && iResource.getFileExtension() != null && iResource.getFileExtension().equalsIgnoreCase("class");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map buildJavaToClassMap(IContainer iContainer, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iContainer == null) return new HashMap(0);
        if (!iContainer.isAccessible()) {
            return new HashMap(0);
        }
        IClassFileReader iClassFileReader = null;
        IResource[] iResourceArray = iContainer.members();
        HashMap<String, IOException> hashMap = new HashMap<String, IOException>(iResourceArray.length);
        int n = 0;
        while (true) {
            block13: {
                Serializable serializable2;
                ISourceAttribute iSourceAttribute;
                IFile iFile;
                URI uRI;
                if (n >= iResourceArray.length) {
                    return hashMap;
                }
                if (!this.isClassFile(iResourceArray[n]) || (uRI = (iFile = (IFile)iResourceArray[n]).getLocationURI()) == null) break block13;
                InputStream inputStream = null;
                try {
                    inputStream = EFS.getStore((URI)uRI).openInputStream(0, iProgressMonitor);
                    iClassFileReader = ToolFactory.createDefaultClassFileReader((InputStream)inputStream, (int)17);
                }
                catch (Throwable throwable) {
                    iSourceAttribute = null;
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException serializable2) {
                        throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(JarPackagerMessages.JarFileExportOperation_errorCannotCloseConnection, Resources.getLocationString((IResource)iFile)), (Throwable)serializable2));
                    }
                }
                {
                    iSourceAttribute = null;
                }
                try {}
                catch (IOException serializable2) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(JarPackagerMessages.JarFileExportOperation_errorCannotCloseConnection, Resources.getLocationString((IResource)iFile)), (Throwable)serializable2));
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (iClassFileReader != null) {
                    iSourceAttribute = iClassFileReader.getSourceFileAttribute();
                    if (iSourceAttribute == null) {
                        this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_classFileWithoutSourceFileAttribute, Resources.getLocationString((IResource)iFile)), null);
                        return null;
                    }
                    String string = new String(iSourceAttribute.getSourceFileName());
                    serializable2 = hashMap.get(string);
                    if (serializable2 == null) {
                        serializable2 = new ArrayList(3);
                        hashMap.put(string, (IOException)serializable2);
                    }
                    ((ArrayList)serializable2).add(iFile);
                }
            }
            ++n;
        }
    }

    private IFolder createFolderHandle(IPath iPath) {
        if (iPath.isValidPath(iPath.toString()) && iPath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFolder(iPath);
        }
        return null;
    }

    public IStatus getStatus() {
        String string = null;
        switch (this.fStatus.getSeverity()) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = JarPackagerMessages.JarFileExportOperation_exportFinishedWithInfo;
                break;
            }
            case 2: {
                string = JarPackagerMessages.JarFileExportOperation_exportFinishedWithWarnings;
                break;
            }
            case 4: {
                if (this.fJarPackages.length > 1) {
                    string = JarPackagerMessages.JarFileExportOperation_creationOfSomeJARsFailed;
                    break;
                }
                string = JarPackagerMessages.JarFileExportOperation_jarCreationFailed;
                break;
            }
            default: {
                string = "";
            }
        }
        this.fStatus.setMessage(string);
        return this.fStatus;
    }

    private boolean canBeExported(boolean bl, boolean bl2) throws CoreException {
        return !bl && !bl2 || bl && this.fJarPackage.areErrorsExported() || bl2 && this.fJarPackage.exportWarnings();
    }

    private void reportPossibleCompileProblems(IFile iFile, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl3) {
                this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_exportedWithCompileErrors, iFile.getFullPath()), null);
            } else {
                this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_notExportedDueToCompileErrors, iFile.getFullPath()), null);
            }
        }
        if (bl2) {
            if (bl3) {
                this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_exportedWithCompileWarnings, iFile.getFullPath()), null);
            } else {
                this.addWarning(Messages.format(JarPackagerMessages.JarFileExportOperation_notExportedDueToCompileWarnings, iFile.getFullPath()), null);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        int n = this.fJarPackages.length;
        iProgressMonitor.beginTask("", n);
        try {
            int n2 = 0;
            while (n2 < n) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1, 4);
                this.fJarPackage = this.fJarPackages[n2];
                if (this.fJarPackage != null) {
                    this.singleRun((IProgressMonitor)subProgressMonitor);
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void singleRun(IProgressMonitor var1_1) throws InvocationTargetException, InterruptedException {
        block15: {
            try {
                try {
                    if (!this.preconditionsOK()) {
                        throw new InvocationTargetException(null, JarPackagerMessages.JarFileExportOperation_jarCreationFailedSeeDetails);
                    }
                    var2_2 = this.countSelectedElements();
                    if (this.fJarPackage.areGeneratedFilesExported() && (!this.isAutoBuilding() && this.fJarPackage.isBuildingIfNeeded() || this.isAutoBuilding() && this.fFilesSaved)) {
                        var3_4 = var2_2 / 10;
                        var1_1.beginTask("", var2_2 += var3_4);
                        var4_5 = new SubProgressMonitor(var1_1, var3_4, 4);
                        this.buildProjects((IProgressMonitor)var4_5);
                    } else {
                        var1_1.beginTask("", var2_2);
                    }
                    this.fJarWriter = this.fJarPackage.createJarWriter3(this.fParentShell);
                    this.exportSelectedElements(var1_1);
                    if (this.getStatus().getSeverity() != 4) {
                        var1_1.subTask(JarPackagerMessages.JarFileExportOperation_savingFiles);
                        this.saveFiles();
                    }
                }
                catch (CoreException var2_3) {
                    this.addToStatus(var2_3);
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                try {
                    if (this.fJarWriter != null) {
                        this.fJarWriter.close();
                    }
                }
                catch (CoreException var7_9) {
                    this.addToStatus(var7_9);
                }
                var1_1.done();
                throw var6_6;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 181->198)] { 
lbl37:
            // 1 sources

            if (this.fJarWriter != null) {
                this.fJarWriter.close();
            }
            break block15;
lbl40:
            // 1 sources

            catch (CoreException var7_10) {
                this.addToStatus(var7_10);
            }
        }
        var1_1.done();
    }

    private boolean preconditionsOK() {
        if (!this.fJarPackage.areGeneratedFilesExported() && !this.fJarPackage.areJavaFilesExported()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_noExportTypeChosen, null);
            return false;
        }
        if (this.fJarPackage.getElements() == null || this.fJarPackage.getElements().length == 0) {
            this.addError(JarPackagerMessages.JarFileExportOperation_noResourcesSelected, null);
            return false;
        }
        if (this.fJarPackage.getAbsoluteJarLocation() == null) {
            this.addError(JarPackagerMessages.JarFileExportOperation_invalidJarLocation, null);
            return false;
        }
        File file = this.fJarPackage.getAbsoluteJarLocation().toFile();
        if (file.exists() && !file.canWrite()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_jarFileExistsAndNotWritable, null);
            return false;
        }
        if (!this.fJarPackage.isManifestAccessible()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_manifestDoesNotExist, null);
            return false;
        }
        if (!this.fJarPackage.isMainClassValid(new BusyIndicatorRunnableContext())) {
            this.addError(JarPackagerMessages.JarFileExportOperation_invalidMainClass, null);
            return false;
        }
        if (this.fParentShell != null) {
            final boolean[] blArray = new boolean[1];
            this.fParentShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    RefactoringSaveHelper refactoringSaveHelper = new RefactoringSaveHelper(1);
                    blArray[0] = refactoringSaveHelper.saveEditors(JarFileExportOperation.this.fParentShell);
                    JarFileExportOperation.this.fFilesSaved = refactoringSaveHelper.hasFilesSaved();
                }
            });
            if (!blArray[0]) {
                this.addError(JarPackagerMessages.JarFileExportOperation_fileUnsaved, null);
                return false;
            }
        }
        return true;
    }

    private void saveFiles() {
        if (this.fJarPackage.areGeneratedFilesExported() && this.fJarPackage.isManifestGenerated() && this.fJarPackage.isManifestSaved()) {
            try {
                this.saveManifest();
            }
            catch (CoreException coreException) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingManifest, coreException);
            }
            catch (IOException iOException) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingManifest, iOException);
            }
        }
        if (this.fJarPackage.isDescriptionSaved()) {
            try {
                this.saveDescription();
            }
            catch (CoreException coreException) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingDescription, coreException);
            }
            catch (IOException iOException) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingDescription, iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveDescription() throws CoreException, IOException {
        IJarDescriptionWriter iJarDescriptionWriter;
        block10: {
            if (this.fJarPackage.isManifestReused()) {
                this.fJarPackage.setGenerateManifest(false);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IFile iFile = this.fJarPackage.getDescriptionFile();
            String string = "UTF-8";
            try {
                string = iFile.getCharset(true);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            iJarDescriptionWriter = this.fJarPackage.createJarDescriptionWriter(byteArrayOutputStream, string);
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                iJarDescriptionWriter.write(this.fJarPackage);
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                if (iFile.isAccessible()) {
                    if (this.fJarPackage.allowOverwrite() || JarPackagerUtil.askForOverwritePermission(this.fParentShell, iFile.getFullPath().toString())) {
                        iFile.setContents((InputStream)byteArrayInputStream, true, true, null);
                    }
                } else {
                    iFile.create((InputStream)byteArrayInputStream, true, null);
                }
                Object var6_9 = null;
                if (byteArrayInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                if (iJarDescriptionWriter == null) throw throwable;
                iJarDescriptionWriter.close();
                throw throwable;
            }
            byteArrayInputStream.close();
        }
        if (iJarDescriptionWriter == null) return;
        iJarDescriptionWriter.close();
    }

    private void saveManifest() throws CoreException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Manifest manifest = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
        manifest.write(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        IFile iFile = this.fJarPackage.getManifestFile();
        if (iFile.isAccessible()) {
            if (this.fJarPackage.allowOverwrite() || JarPackagerUtil.askForOverwritePermission(this.fParentShell, iFile.getFullPath().toString())) {
                iFile.setContents((InputStream)byteArrayInputStream, true, true, null);
            }
        } else {
            iFile.create((InputStream)byteArrayInputStream, true, null);
        }
    }

    private boolean isAutoBuilding() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildProjects(IProgressMonitor iProgressMonitor) {
        HashSet<IProject> hashSet = new HashSet<IProject>(10);
        Object[] objectArray = this.fJarPackage.getElements();
        int n = 0;
        while (n < objectArray.length) {
            IProject iProject = null;
            Object object = objectArray[n];
            if (object instanceof IResource) {
                iProject = ((IResource)object).getProject();
            } else if (object instanceof IJavaElement) {
                iProject = ((IJavaElement)object).getJavaProject().getProject();
            }
            if (iProject != null && !hashSet.contains(iProject)) {
                Object var9_9;
                try {
                    try {
                        iProject.build(10, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        String string = Messages.format(JarPackagerMessages.JarFileExportOperation_errorDuringProjectBuild, iProject.getFullPath());
                        this.addError(string, coreException);
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    hashSet.add(iProject);
                    throw throwable;
                }
                {
                    var9_9 = null;
                    hashSet.add(iProject);
                }
            }
            ++n;
        }
        return;
    }

    private boolean hasCompileErrors(IResource iResource) throws CoreException {
        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.wst.jsdt.core.problem", true, 2);
        int n = 0;
        while (n < iMarkerArray.length) {
            if (iMarkerArray[n].getAttribute("severity", -1) == 2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasCompileWarnings(IResource iResource) throws CoreException {
        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.wst.jsdt.core.problem", true, 2);
        int n = 0;
        while (n < iMarkerArray.length) {
            if (iMarkerArray[n].getAttribute("severity", -1) == 1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean mustUseSourceFolderHierarchy() {
        return this.fJarPackage.useSourceFolderHierarchy() && this.fJarPackage.areJavaFilesExported() && !this.fJarPackage.areGeneratedFilesExported();
    }

    private static class MessageMultiStatus
    extends MultiStatus {
        MessageMultiStatus(String string, int n, String string2, Throwable throwable) {
            super(string, n, string2, throwable);
        }

        protected void setMessage(String string) {
            super.setMessage(string);
        }
    }
}

