/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavadocWriter {
    private static final char PATH_SEPARATOR = '/';
    private final OutputStream fOutputStream;
    private final IJavaProject[] fJavaProjects;
    private final IPath fBasePath;
    private final String fEncoding;

    public JavadocWriter(OutputStream outputStream, String string, IPath iPath, IJavaProject[] iJavaProjectArray) {
        Assert.isNotNull((Object)outputStream);
        Assert.isNotNull((Object)string);
        this.fOutputStream = new BufferedOutputStream(outputStream);
        this.fEncoding = string;
        this.fBasePath = iPath;
        this.fJavaProjects = iJavaProjectArray;
    }

    public void writeXML(JavadocOptionsManager javadocOptionsManager) throws ParserConfigurationException, TransformerException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("project");
        document.appendChild(element);
        element.setAttribute("default", "javadoc");
        Element element2 = document.createElement("target");
        element.appendChild(element2);
        element2.setAttribute("name", "javadoc");
        Element element3 = document.createElement("javadoc");
        element2.appendChild(element3);
        if (!javadocOptionsManager.isFromStandard()) {
            this.xmlWriteDoclet(javadocOptionsManager, document, element3);
        } else {
            this.xmlWriteJavadocStandardParams(javadocOptionsManager, document, element3);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", this.fEncoding);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(this.fOutputStream);
        transformer.transform(dOMSource, streamResult);
    }

    private void xmlWriteJavadocStandardParams(JavadocOptionsManager javadocOptionsManager, Document document, Element element) throws DOMException {
        Object object;
        String string;
        String string2;
        String string3 = this.getPathString(Path.fromOSString((String)javadocOptionsManager.getDestination()));
        element.setAttribute(javadocOptionsManager.DESTINATION, string3);
        element.setAttribute(javadocOptionsManager.VISIBILITY, javadocOptionsManager.getAccess());
        String string4 = javadocOptionsManager.getSource();
        if (string4.length() > 0 && !string4.equals("-")) {
            element.setAttribute(javadocOptionsManager.SOURCE, javadocOptionsManager.getSource());
        }
        element.setAttribute(javadocOptionsManager.USE, this.booleanToString(javadocOptionsManager.getBoolean("use")));
        element.setAttribute(javadocOptionsManager.NOTREE, this.booleanToString(javadocOptionsManager.getBoolean("notree")));
        element.setAttribute(javadocOptionsManager.NONAVBAR, this.booleanToString(javadocOptionsManager.getBoolean("nonavbar")));
        element.setAttribute(javadocOptionsManager.NOINDEX, this.booleanToString(javadocOptionsManager.getBoolean("noindex")));
        element.setAttribute(javadocOptionsManager.SPLITINDEX, this.booleanToString(javadocOptionsManager.getBoolean("splitindex")));
        element.setAttribute(javadocOptionsManager.AUTHOR, this.booleanToString(javadocOptionsManager.getBoolean("author")));
        element.setAttribute(javadocOptionsManager.VERSION, this.booleanToString(javadocOptionsManager.getBoolean("version")));
        element.setAttribute(javadocOptionsManager.NODEPRECATEDLIST, this.booleanToString(javadocOptionsManager.getBoolean("nodeprecatedlist")));
        element.setAttribute(javadocOptionsManager.NODEPRECATED, this.booleanToString(javadocOptionsManager.getBoolean("nodeprecated")));
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.sortSourceElement(javadocOptionsManager.getSourceElements(), arrayList2, arrayList);
        if (!arrayList.isEmpty()) {
            element.setAttribute(javadocOptionsManager.PACKAGENAMES, this.toSeparatedList(arrayList));
        }
        if (!arrayList2.isEmpty()) {
            element.setAttribute(javadocOptionsManager.SOURCEFILES, this.toSeparatedList(arrayList2));
        }
        element.setAttribute(javadocOptionsManager.SOURCEPATH, this.getPathString(javadocOptionsManager.getSourcepath()));
        element.setAttribute(javadocOptionsManager.CLASSPATH, this.getPathString(javadocOptionsManager.getClasspath()));
        String string5 = javadocOptionsManager.getOverview();
        if (string5.length() > 0) {
            element.setAttribute(javadocOptionsManager.OVERVIEW, string5);
        }
        if ((string2 = javadocOptionsManager.getStyleSheet()).length() > 0) {
            element.setAttribute(javadocOptionsManager.STYLESHEETFILE, string2);
        }
        if ((string = javadocOptionsManager.getTitle()).length() > 0) {
            element.setAttribute(javadocOptionsManager.TITLE, string);
        }
        String string6 = javadocOptionsManager.getVMParams();
        String string7 = javadocOptionsManager.getAdditionalParams();
        if (string6.length() + string7.length() > 0) {
            object = String.valueOf(string6) + ' ' + string7;
            element.setAttribute(javadocOptionsManager.EXTRAOPTIONS, (String)object);
        }
        object = javadocOptionsManager.getHRefs();
        int n = 0;
        while (n < ((String[])object).length) {
            Element element2 = document.createElement("link");
            element.appendChild(element2);
            element2.setAttribute(javadocOptionsManager.HREF, object[n]);
            ++n;
        }
    }

    private void sortSourceElement(IJavaElement[] iJavaElementArray, List list, List list2) {
        int n = 0;
        while (n < iJavaElementArray.length) {
            IJavaElement iJavaElement = iJavaElementArray[n];
            IPath iPath = iJavaElement.getResource().getLocation();
            if (iPath != null) {
                if (iJavaElement instanceof ICompilationUnit) {
                    String string = this.getPathString(iPath);
                    list.add(string);
                } else if (iJavaElement instanceof IPackageFragment) {
                    list2.add(iJavaElement.getElementName());
                }
            }
            ++n;
        }
    }

    private String getPathString(IPath[] iPathArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < iPathArray.length) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(this.getPathString(iPathArray[n]));
            ++n;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    private boolean hasSameDevice(IPath iPath, IPath iPath2) {
        String string = iPath.getDevice();
        if (string == null) {
            return iPath2.getDevice() == null;
        }
        return string.equals(iPath2.getDevice());
    }

    private String getPathString(IPath iPath) {
        if (this.fBasePath == null || !this.hasSameDevice(iPath, this.fBasePath)) {
            return iPath.toOSString();
        }
        int n = this.fBasePath.matchingFirstSegments(iPath);
        if (this.fBasePath.segmentCount() == n) {
            return this.getRelativePath(iPath, n);
        }
        int n2 = 0;
        while (n2 < this.fJavaProjects.length) {
            IProject iProject = this.fJavaProjects[n2].getProject();
            IPath iPath2 = iProject.getLocation();
            if (iPath2 != null && iPath2.segmentCount() <= n && iPath2.isPrefixOf(iPath)) {
                return this.getRelativePath(iPath, n);
            }
            ++n2;
        }
        IPath iPath3 = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (iPath3.segmentCount() <= n && iPath3.isPrefixOf(iPath)) {
            return this.getRelativePath(iPath, n);
        }
        return iPath.toOSString();
    }

    private String getRelativePath(IPath iPath, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.fBasePath.segmentCount() - n;
        while (n2 > 0) {
            stringBuffer.append("..");
            stringBuffer.append('/');
            --n2;
        }
        int n3 = iPath.segmentCount();
        int n4 = n;
        while (n4 < n3) {
            if (n4 > n) {
                stringBuffer.append('/');
            }
            stringBuffer.append(iPath.segment(n4));
            ++n4;
        }
        return stringBuffer.toString();
    }

    private void xmlWriteDoclet(JavadocOptionsManager javadocOptionsManager, Document document, Element element) throws DOMException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.sortSourceElement(javadocOptionsManager.getSourceElements(), arrayList2, arrayList);
        if (!arrayList.isEmpty()) {
            element.setAttribute(javadocOptionsManager.PACKAGENAMES, this.toSeparatedList(arrayList));
        }
        if (!arrayList2.isEmpty()) {
            element.setAttribute(javadocOptionsManager.SOURCEFILES, this.toSeparatedList(arrayList2));
        }
        element.setAttribute(javadocOptionsManager.SOURCEPATH, this.getPathString(javadocOptionsManager.getSourcepath()));
        element.setAttribute(javadocOptionsManager.CLASSPATH, this.getPathString(javadocOptionsManager.getClasspath()));
        element.setAttribute(javadocOptionsManager.VISIBILITY, javadocOptionsManager.getAccess());
        Element element2 = document.createElement("doclet");
        element.appendChild(element2);
        element2.setAttribute(javadocOptionsManager.NAME, javadocOptionsManager.getDocletName());
        element2.setAttribute(javadocOptionsManager.PATH, javadocOptionsManager.getDocletPath());
        String string = javadocOptionsManager.getOverview();
        if (string.length() > 0) {
            element.setAttribute(javadocOptionsManager.OVERVIEW, string);
        }
        if ((string = javadocOptionsManager.getAdditionalParams()).length() > 0) {
            element.setAttribute(javadocOptionsManager.EXTRAOPTIONS, string);
        }
    }

    private String toSeparatedList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            ++n;
            String string = (String)iterator.next();
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String booleanToString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public void close() throws IOException {
        if (this.fOutputStream != null) {
            this.fOutputStream.close();
        }
    }
}

