/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;

public class NLSKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private AccessorClassReference fAccessorClassReference;
    private IEditorPart fEditor;
    private final String fKeyName;
    static /* synthetic */ Class class$0;

    public NLSKeyHyperlink(IRegion iRegion, String string, AccessorClassReference accessorClassReference, IEditorPart iEditorPart) {
        Assert.isNotNull((Object)iRegion);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)accessorClassReference);
        Assert.isNotNull((Object)iEditorPart);
        this.fRegion = iRegion;
        this.fKeyName = string;
        this.fAccessorClassReference = accessorClassReference;
        this.fEditor = iEditorPart;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        ITypeBinding iTypeBinding;
        IStorage iStorage = null;
        try {
            iTypeBinding = this.fAccessorClassReference.getBinding();
            iStorage = NLSHintHelper.getResourceBundle(iTypeBinding.getJavaElement().getJavaProject(), this.fAccessorClassReference);
        }
        catch (JavaModelException javaModelException) {}
        if (iStorage == null) {
            this.showErrorInStatusLine(this.fEditor, JavaEditorMessages.Editor_OpenPropertiesFile_error_fileNotFound_dialogMessage);
            return;
        }
        try {
            iTypeBinding = EditorUtility.openInEditor(iStorage, true);
        }
        catch (PartInitException partInitException) {
            this.handleOpenPropertiesFileFailed(iStorage);
            return;
        }
        catch (JavaModelException javaModelException) {
            this.handleOpenPropertiesFileFailed(iStorage);
            return;
        }
        if (iTypeBinding instanceof ITextEditor) {
            IRegion iRegion = null;
            boolean bl = false;
            IEditorInput iEditorInput = iTypeBinding.getEditorInput();
            IDocument iDocument = ((ITextEditor)iTypeBinding).getDocumentProvider().getDocument((Object)iEditorInput);
            if (iDocument != null) {
                FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(iDocument);
                PropertyKeyHyperlinkDetector propertyKeyHyperlinkDetector = new PropertyKeyHyperlinkDetector();
                propertyKeyHyperlinkDetector.setContext((IAdaptable)iTypeBinding);
                String string = PropertyFileDocumentModel.unwindEscapeChars(this.fKeyName);
                int n = iDocument.getLength() - 1;
                try {
                    while (!bl && n >= 0) {
                        iRegion = findReplaceDocumentAdapter.find(n, string, false, true, false, false);
                        if (iRegion == null) {
                            n = -1;
                            continue;
                        }
                        IHyperlink[] iHyperlinkArray = propertyKeyHyperlinkDetector.detectHyperlinks(null, iRegion, false);
                        if (iHyperlinkArray != null) {
                            int n2 = 0;
                            while (n2 < iHyperlinkArray.length) {
                                IRegion iRegion2 = iHyperlinkArray[n2].getHyperlinkRegion();
                                bl = string.equals(iDocument.get(iRegion2.getOffset(), iRegion2.getLength()));
                                ++n2;
                            }
                        } else if (iDocument instanceof IDocumentExtension3) {
                            ITypedRegion iTypedRegion = null;
                            iTypedRegion = ((IDocumentExtension3)iDocument).getPartition("___pf_partitioning", iRegion.getOffset(), false);
                            bl = "__dftl_partition_content_type".equals(iTypedRegion.getType()) && string.equals(iDocument.get(iTypedRegion.getOffset(), iTypedRegion.getLength()).trim());
                        }
                        n = n == iRegion.getOffset() ? -1 : iRegion.getOffset();
                    }
                }
                catch (BadLocationException badLocationException) {
                    bl = false;
                }
                catch (BadPartitioningException badPartitioningException) {
                    bl = false;
                }
            }
            if (bl) {
                EditorUtility.revealInEditor((IEditorPart)iTypeBinding, iRegion);
            } else {
                EditorUtility.revealInEditor((IEditorPart)iTypeBinding, 0, 0);
                this.showErrorInStatusLine((IEditorPart)iTypeBinding, Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_error_keyNotFound, this.fKeyName));
            }
        }
    }

    private void showErrorInStatusLine(IEditorPart iEditorPart, final String string) {
        IEditorStatusLine iEditorStatusLine;
        Display display = this.fEditor.getSite().getShell().getDisplay();
        display.beep();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    iEditorStatusLine.setMessage(true, string, null);
                }
            });
        }
    }

    private void handleOpenPropertiesFileFailed(IStorage iStorage) {
        this.showErrorInStatusLine(this.fEditor, Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_error_openEditor_dialogMessage, iStorage.getFullPath().toOSString()));
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }
}

