/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionHistory;

public abstract class StructureSelectionAction
extends Action {
    public static final String NEXT = "SelectNextElement";
    public static final String PREVIOUS = "SelectPreviousElement";
    public static final String ENCLOSING = "SelectEnclosingElement";
    public static final String HISTORY = "RestoreLastSelection";
    private JavaEditor fEditor;
    private SelectionHistory fSelectionHistory;

    protected StructureSelectionAction(String string, JavaEditor javaEditor, SelectionHistory selectionHistory) {
        super(string);
        Assert.isNotNull((Object)javaEditor);
        Assert.isNotNull((Object)selectionHistory);
        this.fEditor = javaEditor;
        this.fSelectionHistory = selectionHistory;
    }

    protected StructureSelectionAction() {
        super("");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        IJavaElement iJavaElement = EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
        if (!(iJavaElement instanceof ISourceReference)) return;
        if (!iJavaElement.exists()) {
            return;
        }
        ISourceReference iSourceReference = (ISourceReference)iJavaElement;
        try {
            ISourceRange iSourceRange = iSourceReference.getSourceRange();
            if (iSourceRange == null || iSourceRange.getLength() == 0) {
                MessageDialog.openInformation((Shell)this.fEditor.getEditorSite().getShell(), (String)SelectionActionMessages.StructureSelect_error_title, (String)SelectionActionMessages.StructureSelect_error_message);
                return;
            }
        }
        catch (JavaModelException javaModelException) {}
        ITextSelection iTextSelection = this.getTextSelection();
        ISourceRange iSourceRange = this.getNewSelectionRange(StructureSelectionAction.createSourceRange(iTextSelection), iSourceReference);
        if (iTextSelection.getOffset() == iSourceRange.getOffset() && iTextSelection.getLength() == iSourceRange.getLength()) {
            return;
        }
        this.fSelectionHistory.remember(new SourceRange(iTextSelection.getOffset(), iTextSelection.getLength()));
        try {
            this.fSelectionHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(iSourceRange.getOffset(), iSourceRange.getLength());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fSelectionHistory.listenToSelectionChanges();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fSelectionHistory.listenToSelectionChanges();
            return;
        }
    }

    public final ISourceRange getNewSelectionRange(ISourceRange iSourceRange, ISourceReference iSourceReference) {
        try {
            CompilationUnit compilationUnit = StructureSelectionAction.getAST(iSourceReference);
            if (compilationUnit == null) {
                return iSourceRange;
            }
            Selection selection = Selection.createFromStartLength(iSourceRange.getOffset(), iSourceRange.getLength());
            SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(selection, true);
            compilationUnit.accept((ASTVisitor)selectionAnalyzer);
            return this.internalGetNewSelectionRange(iSourceRange, iSourceReference, selectionAnalyzer);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
            return new SourceRange(iSourceRange.getOffset(), iSourceRange.getLength());
        }
    }

    abstract ISourceRange internalGetNewSelectionRange(ISourceRange var1, ISourceReference var2, SelectionAnalyzer var3) throws JavaModelException;

    protected final ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    protected static ISourceRange getLastCoveringNodeRange(ISourceRange iSourceRange, ISourceReference iSourceReference, SelectionAnalyzer selectionAnalyzer) throws JavaModelException {
        if (selectionAnalyzer.getLastCoveringNode() == null) {
            return iSourceRange;
        }
        return StructureSelectionAction.getSelectedNodeSourceRange(iSourceReference, selectionAnalyzer.getLastCoveringNode());
    }

    protected static ISourceRange getSelectedNodeSourceRange(ISourceReference iSourceReference, ASTNode aSTNode) throws JavaModelException {
        int n = aSTNode.getStartPosition();
        int n2 = Math.min(iSourceReference.getSourceRange().getLength(), aSTNode.getStartPosition() + aSTNode.getLength() - 1);
        return StructureSelectionAction.createSourceRange(n, n2);
    }

    private static ISourceRange createSourceRange(ITextSelection iTextSelection) {
        return new SourceRange(iTextSelection.getOffset(), iTextSelection.getLength());
    }

    private static CompilationUnit getAST(ISourceReference iSourceReference) {
        return ASTProvider.getASTProvider().getAST((IJavaElement)iSourceReference, ASTProvider.WAIT_YES, null);
    }

    static ISourceRange createSourceRange(int n, int n2) {
        int n3 = n2 - n + 1;
        if (n3 == 0) {
            n3 = 1;
        }
        return new SourceRange(Math.max(0, n), n3);
    }

    static ASTNode[] getSiblingNodes(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getParent();
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        if (structuralPropertyDescriptor.isChildListProperty()) {
            List list = (List)aSTNode2.getStructuralProperty(structuralPropertyDescriptor);
            return list.toArray(new ASTNode[list.size()]);
        }
        return null;
    }

    static int findIndex(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (object2 == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

