/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;

public abstract class AbstractConfigurationBlockPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceConfigurationBlock fConfigurationBlock;
    private OverlayPreferenceStore fOverlayStore;

    public AbstractConfigurationBlockPreferencePage() {
        this.setDescription();
        this.setPreferenceStore();
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), new OverlayPreferenceStore.OverlayKey[0]);
        this.fConfigurationBlock = this.createConfigurationBlock(this.fOverlayStore);
    }

    protected abstract IPreferenceConfigurationBlock createConfigurationBlock(OverlayPreferenceStore var1);

    protected abstract String getHelpId();

    protected abstract void setDescription();

    protected abstract void setPreferenceStore();

    public void init(IWorkbench iWorkbench) {
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpId());
    }

    protected Control createContents(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control control = this.fConfigurationBlock.createControl(composite);
        this.initialize();
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private void initialize() {
        this.fConfigurationBlock.initialize();
    }

    public boolean performOk() {
        this.fConfigurationBlock.performOk();
        this.fOverlayStore.propagate();
        JavaPlugin.getDefault().savePluginPreferences();
        return true;
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.fConfigurationBlock.performDefaults();
        super.performDefaults();
    }

    public void dispose() {
        this.fConfigurationBlock.dispose();
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }
}

