/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;

class SmartTypingConfigurationBlock
extends AbstractConfigurationBlock {
    public SmartTypingConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        super(overlayPreferenceStore);
        overlayPreferenceStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        return new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smartPaste"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "importsOnPaste"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeStrings"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBrackets"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBraces"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeJavaDocs"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wrapStrings"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "escapeStrings"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "addJavaDocTags"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_semicolon"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_tab"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_opening_brace")};
    }

    public Control createControl(Composite composite) {
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite, 768);
        scrolledPageContent.setExpandHorizontal(true);
        scrolledPageContent.setExpandVertical(true);
        Composite composite2 = new Composite((Composite)scrolledPageContent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.createSubsection(composite2, null, PreferencesMessages.SmartTypingConfigurationBlock_autoclose_title);
        this.addAutoclosingSection(composite3);
        composite3 = this.createSubsection(composite2, null, PreferencesMessages.SmartTypingConfigurationBlock_automove_title);
        this.addAutopositionSection(composite3);
        composite3 = this.createSubsection(composite2, null, PreferencesMessages.SmartTypingConfigurationBlock_tabs_title);
        this.addTabSection(composite3);
        composite3 = this.createSubsection(composite2, null, PreferencesMessages.SmartTypingConfigurationBlock_pasting_title);
        this.addPasteSection(composite3);
        composite3 = this.createSubsection(composite2, null, PreferencesMessages.SmartTypingConfigurationBlock_strings_title);
        this.addStringsSection(composite3);
        scrolledPageContent.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledPageContent.setMinSize(point.x, point.y);
        return scrolledPageContent;
    }

    private void addStringsSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.JavaEditorPreferencePage_wrapStrings;
        Button button = this.addCheckBox(composite, string, "wrapStrings", 0);
        string = PreferencesMessages.JavaEditorPreferencePage_escapeStrings;
        Button button2 = this.addCheckBox(composite, string, "escapeStrings", 0);
        this.createDependency(button, (Control)button2);
    }

    private void addPasteSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.JavaEditorPreferencePage_smartPaste;
        this.addCheckBox(composite, string, "smartPaste", 0);
        string = PreferencesMessages.JavaEditorPreferencePage_importsOnPaste;
        this.addCheckBox(composite, string, "importsOnPaste", 0);
    }

    private void addTabSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.JavaEditorPreferencePage_typing_smartTab;
        this.addCheckBox(composite, string, "smart_tab", 0);
        this.createMessage(composite);
    }

    private void addAutopositionSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.JavaEditorPreferencePage_typing_smartSemicolon;
        this.addCheckBox(composite, string, "smart_semicolon", 0);
        string = PreferencesMessages.JavaEditorPreferencePage_typing_smartOpeningBrace;
        this.addCheckBox(composite, string, "smart_opening_brace", 0);
    }

    private void addAutoclosingSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.JavaEditorPreferencePage_closeStrings;
        this.addCheckBox(composite, string, "closeStrings", 0);
        string = PreferencesMessages.JavaEditorPreferencePage_closeBrackets;
        this.addCheckBox(composite, string, "closeBrackets", 0);
        string = PreferencesMessages.JavaEditorPreferencePage_closeBraces;
        this.addCheckBox(composite, string, "closeBraces", 0);
        string = PreferencesMessages.JavaEditorPreferencePage_closeJavaDocs;
        Button button = this.addCheckBox(composite, string, "closeJavaDocs", 0);
        string = PreferencesMessages.JavaEditorPreferencePage_addJavaDocTags;
        Button button2 = this.addCheckBox(composite, string, "addJavaDocTags", 0);
        this.createDependency(button, (Control)button2);
    }

    private void createMessage(final Composite composite) {
        String string = PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tooltip;
        String string2 = JavaPlugin.getDefault().getCombinedPreferenceStore().getString("org.eclipse.wst.jsdt.core.formatter.tabulation.char");
        String string3 = "tab".equals(string2) ? Messages.format(PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tab_text, new String[]{Integer.toString(this.getTabDisplaySize())}) : Messages.format(PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_others_text, new String[]{Integer.toString(this.getTabDisplaySize()), Integer.toString(this.getIndentSize()), this.getIndentMode()});
        final Link link = new Link(composite, 0);
        link.setText(string3);
        link.setToolTipText(string);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 300;
        link.setLayoutData((Object)gridData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.wst.jsdt.ui.preferences.CodeFormatterPreferencePage", null, null);
            }
        });
        final IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){
            private boolean fHasRun = false;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (this.fHasRun) {
                    return;
                }
                if (composite.isDisposed()) {
                    return;
                }
                String string = propertyChangeEvent.getProperty();
                if ("org.eclipse.wst.jsdt.core.formatter.tabulation.char".equals(string) || "org.eclipse.wst.jsdt.core.formatter.tabulation.size".equals(string)) {
                    this.fHasRun = true;
                    link.dispose();
                    SmartTypingConfigurationBlock.this.createMessage(composite);
                    Dialog.applyDialogFont((Control)composite);
                    composite.redraw();
                    composite.layout();
                }
            }
        };
        iPreferenceStore.addPropertyChangeListener(iPropertyChangeListener);
        link.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                iPreferenceStore.removePropertyChangeListener(iPropertyChangeListener);
            }
        });
    }

    private String getIndentMode() {
        String string = JavaPlugin.getDefault().getCombinedPreferenceStore().getString("org.eclipse.wst.jsdt.core.formatter.tabulation.char");
        if ("space".equals(string)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_spaces;
        }
        if ("tab".equals(string)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tabs;
        }
        if ("mixed".equals(string)) {
            return PreferencesMessages.SmartTypingConfigurationBlock_tabs_message_tabsAndSpaces;
        }
        Assert.isTrue((boolean)false, (String)"Illegal indent mode - must not happen");
        return null;
    }

    private int getIndentSize() {
        return CodeFormatterUtil.getIndentWidth(null);
    }

    private int getTabDisplaySize() {
        return CodeFormatterUtil.getTabWidth(null);
    }
}

