/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.dialogs.EncodingFieldEditor;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;

public class SpellingConfigurationBlock
extends OptionsConfigurationBlock {
    private static final boolean SUPPORT_CONTENT_ASSIST_PROPOSALS = false;
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_DIGITS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_digits");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_MIXED = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_mixed");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_SENTENCE = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_sentence");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_UPPER = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_upper");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_JAVA_STRINGS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_java_stringsr");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_SINGLE_LETTERS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_single_letters");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_NON_LETTERS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_non_letters");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_URLS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_urls");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_AMPERSAND_IN_PROPERTIES = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_ampersand_in_properties");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_LOCALE = SpellingConfigurationBlock.getJDTUIKey("spelling_locale");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_PROPOSAL_THRESHOLD = SpellingConfigurationBlock.getJDTUIKey("spelling_proposal_threshold");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_USER_DICTIONARY = SpellingConfigurationBlock.getJDTUIKey("spelling_user_dictionary");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_USER_DICTIONARY_ENCODING = SpellingConfigurationBlock.getJDTUIKey("spelling_user_dictionary_encoding");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_ENABLE_CONTENTASSIST = SpellingConfigurationBlock.getJDTUIKey("spelling_enable_contentassist");
    private static final String PREF_VALUE_NO_LOCALE = "";
    private Text fDictionaryPath = null;
    private IStatus fFileStatus = new StatusInfo();
    private IStatus fThresholdStatus = new StatusInfo();
    private IStatus fEncodingFieldEditorStatus = new StatusInfo();
    private EncodingFieldEditor fEncodingEditor;
    private Composite fEncodingEditorParent;
    private Control[] fAllControls;
    private Control[] fEnabledControls;

    protected static void createSelectionDependency(final Button button, final Control control) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                control.setEnabled(button.getSelection());
            }
        });
        control.setEnabled(button.getSelection());
    }

    protected static String[] getDictionaryCodes(Set set) {
        int n = 0;
        Locale locale = null;
        String[] stringArray = new String[set.size() + 1];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            locale = (Locale)iterator.next();
            stringArray[n++] = locale.toString();
        }
        stringArray[n++] = PREF_VALUE_NO_LOCALE;
        return stringArray;
    }

    protected static String[] getDictionaryLabels(Set set) {
        int n = 0;
        Locale locale = null;
        String[] stringArray = new String[set.size() + 1];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            locale = (Locale)iterator.next();
            stringArray[n++] = locale.getDisplayName();
        }
        stringArray[n++] = PreferencesMessages.SpellingPreferencePage_dictionary_none;
        return stringArray;
    }

    protected static IStatus validateAbsoluteFilePath(String string) {
        StatusInfo statusInfo = new StatusInfo();
        if (string.length() > 0) {
            File file = new File(string);
            if (!(file.exists() || file.isAbsolute() && file.getParentFile().canWrite())) {
                statusInfo.setError(PreferencesMessages.SpellingPreferencePage_dictionary_error);
            } else if (!(!file.exists() || file.isFile() && file.isAbsolute() && file.canRead() && file.canWrite())) {
                statusInfo.setError(PreferencesMessages.SpellingPreferencePage_dictionary_error);
            }
        }
        return statusInfo;
    }

    private static IStatus validateLocale(String string) {
        if (PREF_VALUE_NO_LOCALE.equals(string)) {
            return new StatusInfo();
        }
        Locale locale = SpellCheckEngine.convertToLocale(string);
        if (SpellCheckEngine.findClosestLocale(locale) != null) {
            return new StatusInfo();
        }
        return new StatusInfo(4, PreferencesMessages.SpellingPreferencePage_locale_error);
    }

    protected static IStatus validatePositiveNumber(String string) {
        StatusInfo statusInfo = new StatusInfo();
        if (string.length() == 0) {
            statusInfo.setError(PreferencesMessages.SpellingPreferencePage_empty_threshold);
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    statusInfo.setError(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, string));
            }
        }
        return statusInfo;
    }

    public SpellingConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, SpellingConfigurationBlock.getAllKeys(), iWorkbenchPreferenceContainer);
        IStatus iStatus = SpellingConfigurationBlock.validateAbsoluteFilePath(this.getValue(PREF_SPELLING_USER_DICTIONARY));
        if (iStatus.getSeverity() != 0) {
            this.setValue(PREF_SPELLING_USER_DICTIONARY, PREF_VALUE_NO_LOCALE);
        }
        if ((iStatus = SpellingConfigurationBlock.validateLocale(this.getValue(PREF_SPELLING_LOCALE))).getSeverity() != 0) {
            this.setValue(PREF_SPELLING_LOCALE, SpellCheckEngine.getDefaultLocale().toString());
        }
    }

    protected Combo addComboBox(Composite composite, String string, OptionsConfigurationBlock.Key key, String[] stringArray, String[] stringArray2, int n) {
        OptionsConfigurationBlock.ControlData controlData = new OptionsConfigurationBlock.ControlData(key, stringArray);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        Label label = new Label(composite, 16448);
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Combo combo = new Combo(composite, 8);
        combo.setItems(stringArray2);
        combo.setData((Object)controlData);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener(this.getSelectionListener());
        this.fLabels.put(combo, label);
        String string2 = this.getValue(key);
        Locale locale = SpellCheckEngine.convertToLocale(string2);
        locale = SpellCheckEngine.findClosestLocale(locale);
        if (locale != null) {
            string2 = locale.toString();
        }
        combo.select(controlData.getSelection(string2));
        this.fComboBoxes.add(combo);
        return combo;
    }

    protected Control createContents(Composite composite) {
        Combo combo;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        String[] stringArray = new String[]{"true", "false"};
        Group group = new Group(composite2, 0);
        group.setText(PreferencesMessages.SpellingPreferencePage_group_user);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        arrayList.add(group);
        String string = PreferencesMessages.SpellingPreferencePage_ignore_digits_label;
        Button button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_DIGITS, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_mixed_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_MIXED, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_sentence_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_SENTENCE, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_upper_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_UPPER, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_url_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_URLS, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_non_letters_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_NON_LETTERS, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_single_letters_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_SINGLE_LETTERS, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_java_strings_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_JAVA_STRINGS, stringArray, 0);
        arrayList.add(button);
        string = PreferencesMessages.SpellingPreferencePage_ignore_ampersand_in_properties_label;
        button = this.addCheckBox((Composite)group, string, PREF_SPELLING_IGNORE_AMPERSAND_IN_PROPERTIES, stringArray, 0);
        arrayList.add(button);
        Set set = SpellCheckEngine.getLocalesWithInstalledDictionaries();
        boolean bl = set.size() > 0;
        Group group2 = new Group(composite2, 0);
        if (bl) {
            group2.setText(PreferencesMessages.SpellingPreferencePage_group_dictionaries);
        } else {
            group2.setText(PreferencesMessages.SpellingPreferencePage_group_dictionary);
        }
        group2.setLayout((Layout)new GridLayout(4, false));
        group2.setLayoutData((Object)new GridData(768));
        arrayList.add(group2);
        if (bl) {
            string = PreferencesMessages.SpellingPreferencePage_dictionary_label;
            combo = this.addComboBox((Composite)group2, string, PREF_SPELLING_LOCALE, SpellingConfigurationBlock.getDictionaryCodes(set), SpellingConfigurationBlock.getDictionaryLabels(set), 0);
            combo.setEnabled(set.size() > 0);
            arrayList.add(combo);
            arrayList.add(this.fLabels.get(combo));
            new Label((Composite)group2, 0);
        }
        string = PreferencesMessages.SpellingPreferencePage_workspace_dictionary_label;
        this.fDictionaryPath = this.addTextField((Composite)group2, string, PREF_SPELLING_USER_DICTIONARY, 0, 0);
        combo = (GridData)this.fDictionaryPath.getLayoutData();
        combo.grabExcessHorizontalSpace = true;
        combo.widthHint = pixelConverter.convertWidthInCharsToPixels(40);
        arrayList.add(this.fDictionaryPath);
        arrayList.add(this.fLabels.get(this.fDictionaryPath));
        Button button2 = new Button((Composite)group2, 8);
        button2.setText(PreferencesMessages.SpellingPreferencePage_browse_label);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpellingConfigurationBlock.this.handleBrowseButtonSelected();
            }
        });
        button2.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(button2);
        arrayList.add(button2);
        new Label((Composite)group2, 0);
        Label label = new Label((Composite)group2, 0);
        combo = new GridData(256);
        combo.horizontalSpan = 3;
        label.setLayoutData((Object)combo);
        label.setText(PreferencesMessages.SpellingPreferencePage_user_dictionary_description);
        arrayList.add(label);
        this.createEncodingFieldEditor((Composite)group2, arrayList);
        Group group3 = new Group(composite2, 0);
        group3.setText(PreferencesMessages.SpellingPreferencePage_group_advanced);
        group3.setLayout((Layout)new GridLayout(3, false));
        group3.setLayoutData((Object)new GridData(768));
        arrayList.add(group3);
        string = PreferencesMessages.SpellingPreferencePage_proposals_threshold;
        Text text = this.addTextField((Composite)group3, string, PREF_SPELLING_PROPOSAL_THRESHOLD, 0, 0);
        text.setTextLimit(3);
        combo = new GridData(32);
        combo.widthHint = pixelConverter.convertWidthInCharsToPixels(4);
        text.setLayoutData((Object)combo);
        arrayList.add(text);
        arrayList.add(this.fLabels.get(text));
        this.fAllControls = arrayList.toArray(new Control[arrayList.size()]);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.spelling_configuration_block_context");
        return composite2;
    }

    private void createEncodingFieldEditor(Composite composite, List list) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite, 0);
        label2.setText(PreferencesMessages.SpellingPreferencePage_encoding_label);
        label2.setLayoutData((Object)new GridData(2));
        list.add(label2);
        this.fEncodingEditorParent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fEncodingEditorParent.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.fEncodingEditorParent.setLayoutData((Object)gridData);
        this.fEncodingEditor = new EncodingFieldEditor(PREF_SPELLING_USER_DICTIONARY_ENCODING.getName(), PREF_VALUE_NO_LOCALE, null, this.fEncodingEditorParent);
        PreferenceStore preferenceStore = new PreferenceStore();
        String string = ResourcesPlugin.getEncoding();
        preferenceStore.setDefault(PREF_SPELLING_USER_DICTIONARY_ENCODING.getName(), string);
        String string2 = this.getValue(PREF_SPELLING_USER_DICTIONARY_ENCODING);
        if (string2 != null && string2.length() > 0) {
            preferenceStore.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING.getName(), string2);
        }
        this.fEncodingEditor.setPreferenceStore((IPreferenceStore)preferenceStore);
        DialogPage dialogPage = new DialogPage(){

            public void createControl(Composite composite) {
            }

            public void setErrorMessage(String string) {
                StatusInfo statusInfo = new StatusInfo();
                if (string != null) {
                    statusInfo.setError(string);
                }
                SpellingConfigurationBlock.this.fEncodingFieldEditorStatus = statusInfo;
                SpellingConfigurationBlock.this.fContext.statusChanged(StatusUtil.getMostSevere(new IStatus[]{SpellingConfigurationBlock.this.fThresholdStatus, SpellingConfigurationBlock.this.fFileStatus, SpellingConfigurationBlock.this.fEncodingFieldEditorStatus}));
            }
        };
        this.fEncodingEditor.setPage(dialogPage);
        this.fEncodingEditor.load();
        if (string2 == null || string2.equals(string) || string2.length() == 0) {
            this.fEncodingEditor.loadDefault();
        }
    }

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_SPELLING_USER_DICTIONARY, PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_SPELLING_IGNORE_DIGITS, PREF_SPELLING_IGNORE_MIXED, PREF_SPELLING_IGNORE_SENTENCE, PREF_SPELLING_IGNORE_UPPER, PREF_SPELLING_IGNORE_URLS, PREF_SPELLING_IGNORE_AMPERSAND_IN_PROPERTIES, PREF_SPELLING_IGNORE_NON_LETTERS, PREF_SPELLING_IGNORE_SINGLE_LETTERS, PREF_SPELLING_LOCALE, PREF_SPELLING_PROPOSAL_THRESHOLD, PREF_SPELLING_IGNORE_JAVA_STRINGS};
    }

    protected final String[] getFullBuildDialogStrings(boolean bl) {
        return null;
    }

    public boolean performOk() {
        this.fEncodingEditor.store();
        if (this.fEncodingEditor.presentsDefaultValue()) {
            this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_VALUE_NO_LOCALE);
        } else {
            this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, this.fEncodingEditor.getPreferenceStore().getString(PREF_SPELLING_USER_DICTIONARY_ENCODING.getName()));
        }
        return super.performOk();
    }

    public boolean performApply() {
        this.fEncodingEditor.store();
        if (this.fEncodingEditor.presentsDefaultValue()) {
            this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_VALUE_NO_LOCALE);
        } else {
            this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, this.fEncodingEditor.getPreferenceStore().getString(PREF_SPELLING_USER_DICTIONARY_ENCODING.getName()));
        }
        return super.performApply();
    }

    public void performDefaults() {
        super.performDefaults();
        this.setValue(PREF_SPELLING_USER_DICTIONARY_ENCODING, PREF_VALUE_NO_LOCALE);
        this.fEncodingEditor.getPreferenceStore().setValue(this.fEncodingEditor.getPreferenceName(), ResourcesPlugin.getEncoding());
        this.fEncodingEditor.load();
        this.fEncodingEditor.loadDefault();
    }

    protected void handleBrowseButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.fDictionaryPath.getShell(), 4096);
        fileDialog.setText(PreferencesMessages.SpellingPreferencePage_filedialog_title);
        fileDialog.setFilterPath(this.fDictionaryPath.getText());
        String string = fileDialog.open();
        if (string != null) {
            this.fDictionaryPath.setText(string);
        }
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
        if (key == null || PREF_SPELLING_PROPOSAL_THRESHOLD.equals(key)) {
            this.fThresholdStatus = SpellingConfigurationBlock.validatePositiveNumber(this.getValue(PREF_SPELLING_PROPOSAL_THRESHOLD));
        }
        if (key == null || PREF_SPELLING_USER_DICTIONARY.equals(key)) {
            this.fFileStatus = SpellingConfigurationBlock.validateAbsoluteFilePath(this.getValue(PREF_SPELLING_USER_DICTIONARY));
        }
        this.fContext.statusChanged(StatusUtil.getMostSevere(new IStatus[]{this.fThresholdStatus, this.fFileStatus, this.fEncodingFieldEditorStatus}));
    }

    protected void updateCheckBox(Button button) {
        super.updateCheckBox(button);
        Event event = new Event();
        event.type = 13;
        event.display = button.getDisplay();
        event.widget = button;
        button.notifyListeners(13, event);
    }

    protected void setEnabled(boolean bl) {
        this.fEncodingEditor.setEnabled(bl, this.fEncodingEditorParent);
        if (bl && this.fEnabledControls != null) {
            int n = this.fEnabledControls.length - 1;
            while (n >= 0) {
                this.fEnabledControls[n].setEnabled(true);
                --n;
            }
            this.fEnabledControls = null;
        }
        if (!bl && this.fEnabledControls == null) {
            ArrayList<Control> arrayList = new ArrayList<Control>();
            int n = this.fAllControls.length - 1;
            while (n >= 0) {
                Control control = this.fAllControls[n];
                if (control.isEnabled()) {
                    arrayList.add(control);
                    control.setEnabled(false);
                }
                --n;
            }
            this.fEnabledControls = arrayList.toArray(new Control[arrayList.size()]);
        }
    }
}

