/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PatternConstructor;

public class PropertyKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private String fPropertiesKey;
    private Shell fShell;
    private IStorage fStorage;
    private ITextEditor fEditor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PropertyKeyHyperlink(IRegion iRegion, String string, ITextEditor iTextEditor) {
        Assert.isNotNull((Object)iRegion);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)iTextEditor);
        this.fRegion = iRegion;
        this.fPropertiesKey = string;
        this.fEditor = iTextEditor;
        IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)this.fEditor.getEditorInput();
        this.fShell = this.fEditor.getEditorSite().getShell();
        try {
            this.fStorage = iStorageEditorInput.getStorage();
        }
        catch (CoreException coreException) {
            this.fStorage = null;
        }
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (!this.checkEnabled()) {
            return;
        }
        IResource iResource = (IResource)this.fStorage;
        KeyReference[] keyReferenceArray = null;
        if (iResource != null) {
            keyReferenceArray = this.search((IResource)iResource.getProject(), this.fPropertiesKey);
        }
        if (keyReferenceArray == null) {
            return;
        }
        if (keyReferenceArray.length == 0) {
            String string = PropertiesFileEditorMessages.OpenAction_error_messageNoResult;
            this.showErrorInStatusLine(string);
            return;
        }
        this.open(keyReferenceArray);
    }

    private boolean checkEnabled() {
        return this.fStorage instanceof IResource;
    }

    private void open(KeyReference[] keyReferenceArray) {
        Assert.isLegal((keyReferenceArray != null && keyReferenceArray.length > 0 ? 1 : 0) != 0);
        if (keyReferenceArray.length == 1) {
            this.open(keyReferenceArray[0]);
        } else {
            this.open(this.select(keyReferenceArray));
        }
    }

    private KeyReference select(final KeyReference[] keyReferenceArray) {
        Object[] objectArray;
        Arrays.sort(keyReferenceArray);
        final int n = keyReferenceArray.length;
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider(){

            public String decorateText(String string, Object object) {
                KeyReference keyReference = (KeyReference)object;
                IStorage iStorage = keyReference.storage;
                String string2 = iStorage.getName();
                if (string2 == null) {
                    return string;
                }
                int n3 = 0;
                int n2 = 0;
                while (n2 < n) {
                    if (keyReferenceArray[n2].storage.equals(iStorage)) {
                        ++n3;
                    }
                    ++n2;
                }
                if (n3 > 1) {
                    Object[] objectArray = new Object[]{string2, new Integer(n3)};
                    string2 = Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabelWithMatchCount, objectArray);
                }
                return string2;
            }
        };
        TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(this.fShell, (ILabelProvider)workbenchLabelProvider, (ILabelProvider)new WorkbenchLabelProvider());
        twoPaneElementSelector.setLowerListLabel(PropertiesFileEditorMessages.OpenAction_SelectionDialog_details);
        twoPaneElementSelector.setMultipleSelection(false);
        twoPaneElementSelector.setTitle(PropertiesFileEditorMessages.OpenAction_SelectionDialog_title);
        twoPaneElementSelector.setMessage(PropertiesFileEditorMessages.OpenAction_SelectionDialog_message);
        twoPaneElementSelector.setElements((Object[])keyReferenceArray);
        if (twoPaneElementSelector.open() == 0 && (objectArray = twoPaneElementSelector.getResult()) != null && objectArray.length == 1) {
            return (KeyReference)objectArray[0];
        }
        return null;
    }

    private void open(KeyReference keyReference) {
        if (keyReference == null) {
            return;
        }
        try {
            IEditorPart iEditorPart = EditorUtility.openInEditor(keyReference.storage, true);
            EditorUtility.revealInEditor(iEditorPart, keyReference.offset, keyReference.length);
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, PropertiesFileEditorMessages.OpenAction_error_message, (Throwable)javaModelException));
            ErrorDialog.openError((Shell)this.fShell, (String)this.getErrorDialogTitle(), (String)PropertiesFileEditorMessages.OpenAction_error_messageProblems, (IStatus)javaModelException.getStatus());
        }
        catch (PartInitException partInitException) {
            IWorkbenchAdapter iWorkbenchAdapter;
            String string = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)keyReference.getAdapter(clazz)) != null) {
                string = Messages.format(PropertiesFileEditorMessages.OpenAction_error_messageArgs, new String[]{iWorkbenchAdapter.getLabel((Object)keyReference), partInitException.getLocalizedMessage()});
            }
            if (string == null) {
                string = Messages.format(PropertiesFileEditorMessages.OpenAction_error_message, partInitException.getLocalizedMessage());
            }
            MessageDialog.openError((Shell)this.fShell, (String)PropertiesFileEditorMessages.OpenAction_error_messageProblems, (String)string);
        }
    }

    private String getErrorDialogTitle() {
        return PropertiesFileEditorMessages.OpenAction_error_title;
    }

    private void showError(CoreException coreException) {
        ExceptionHandler.handle(coreException, this.fShell, this.getErrorDialogTitle(), PropertiesFileEditorMessages.OpenAction_error_message);
    }

    private void showErrorInStatusLine(final String string) {
        IEditorStatusLine iEditorStatusLine;
        this.fShell.getDisplay().beep();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)this.fEditor.getAdapter((Class)clazz)) != null) {
            this.fShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    iEditorStatusLine.setMessage(true, string, null);
                }
            });
        }
    }

    private boolean useDoubleQuotedKey() {
        if (this.fStorage == null) {
            return false;
        }
        String string = this.fStorage.getName();
        return string != null && !"about.properties".equals(string) && !"feature.properties".equals(string) && !"plugin.properties".equals(string);
    }

    private KeyReference[] search(final IResource iResource, String string) {
        String string2;
        if (string == null) {
            return new KeyReference[0];
        }
        final ArrayList arrayList = new ArrayList(5);
        final boolean bl = this.useDoubleQuotedKey();
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("\"");
            stringBuffer.append(this.fPropertiesKey);
            stringBuffer.append('\"');
            string2 = stringBuffer.toString();
        } else {
            string2 = this.fPropertiesKey;
        }
        try {
            this.fEditor.getEditorSite().getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    block9: {
                        block8: {
                            if (iProgressMonitor == null) {
                                iProgressMonitor = new NullProgressMonitor();
                            }
                            iProgressMonitor.beginTask("", 5);
                            try {
                                ResultCollector resultCollector = new ResultCollector(arrayList, bl);
                                TextSearchEngine textSearchEngine = TextSearchEngine.create();
                                Pattern pattern = PatternConstructor.createPattern(string2, true, false);
                                textSearchEngine.search(PropertyKeyHyperlink.createScope(iResource), (TextSearchRequestor)resultCollector, pattern, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
                                if (arrayList.size() == 0 && bl) {
                                    IJavaElement iJavaElement = JavaCore.create((IResource)iResource);
                                    if (iJavaElement == null) {
                                        Object var10_6 = null;
                                        break block8;
                                    }
                                    int n = 11;
                                    IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iJavaElement}, (int)n);
                                    SearchPattern searchPattern = SearchPattern.createPattern((String)PropertyKeyHyperlink.this.fPropertiesKey, (int)4, (int)2, (int)10);
                                    try {
                                        new SearchEngine().search(searchPattern, SearchUtils.getDefaultSearchParticipants(), iJavaSearchScope, new SearchRequestor(this, arrayList){
                                            final /* synthetic */ 3 this$1;
                                            private final /* synthetic */ List val$result;
                                            {
                                                this.this$1 = var1_1;
                                                this.val$result = list;
                                            }

                                            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                                                this.val$result.add(new KeyReference((IStorage)searchMatch.getResource(), searchMatch.getOffset(), searchMatch.getLength()));
                                            }
                                        }, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                        break block9;
                                    }
                                    catch (CoreException coreException) {
                                        throw new InvocationTargetException(coreException);
                                    }
                                }
                                iProgressMonitor.worked(1);
                                break block9;
                            }
                            catch (Throwable throwable) {
                                Object var10_7 = null;
                                iProgressMonitor.done();
                                throw throwable;
                            }
                        }
                        iProgressMonitor.done();
                        return;
                    }
                    Object var10_8 = null;
                    iProgressMonitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            String string3 = PropertiesFileEditorMessages.OpenAction_error_messageErrorSearchingKey;
            this.showError(new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, string3, invocationTargetException.getTargetException())));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return arrayList.toArray(new KeyReference[arrayList.size()]);
    }

    private static TextSearchScope createScope(IResource iResource) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = JavaCore.getJavaLikeExtensions();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add("*." + stringArray[n]);
            ++n;
        }
        arrayList.add("*.xml");
        arrayList.add("*.ini");
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        Pattern pattern = PatternConstructor.createPattern(stringArray2, false, false);
        return TextSearchScope.newSearchScope((IResource[])new IResource[]{iResource}, (Pattern)pattern, (boolean)false);
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    private static class KeyReference
    extends PlatformObject
    implements IWorkbenchAdapter,
    Comparable {
        private static final Collator fgCollator = Collator.getInstance();
        private IStorage storage;
        private int offset;
        private int length;

        private KeyReference(IStorage iStorage, int n, int n2) {
            Assert.isNotNull((Object)iStorage);
            this.storage = iStorage;
            this.offset = n;
            this.length = n2;
        }

        public Object getAdapter(Class clazz) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                return this;
            }
            return super.getAdapter(clazz);
        }

        public Object[] getChildren(Object object) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)this.storage.getAdapter((Class)clazz)) != null) {
                return iWorkbenchAdapter.getImageDescriptor((Object)this.storage);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getLabel(Object object) {
            ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            try {
                block6: {
                    String string;
                    iTextFileBufferManager.connect(this.storage.getFullPath(), LocationKind.NORMALIZE, null);
                    try {
                        ITextFileBuffer iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(this.storage.getFullPath(), LocationKind.NORMALIZE);
                        IDocument iDocument = iTextFileBuffer.getDocument();
                        if (iDocument == null) break block6;
                        int n = iDocument.getLineOfOffset(this.offset) + 1;
                        Object[] objectArray = new Object[]{new Integer(n), this.storage.getFullPath()};
                        string = Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabel, objectArray);
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        iTextFileBufferManager.disconnect(this.storage.getFullPath(), LocationKind.NORMALIZE, null);
                        throw throwable;
                    }
                    iTextFileBufferManager.disconnect(this.storage.getFullPath(), LocationKind.NORMALIZE, null);
                    return string;
                }
                Object var7_12 = null;
                iTextFileBufferManager.disconnect(this.storage.getFullPath(), LocationKind.NORMALIZE, null);
                return this.storage.getFullPath().toString();
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException.getStatus());
                return this.storage.getFullPath().toString();
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
            return this.storage.getFullPath().toString();
        }

        public Object getParent(Object object) {
            return null;
        }

        public int compareTo(Object object) {
            String string;
            KeyReference keyReference = (KeyReference)object;
            String string2 = this.storage.getFullPath().toString();
            int n = fgCollator.compare(string2, string = keyReference.storage.getFullPath().toString());
            if (n != 0) {
                return n;
            }
            return this.offset - keyReference.offset;
        }
    }

    private static class ResultCollector
    extends TextSearchRequestor {
        private List fResult;
        private boolean fIsKeyDoubleQuoted;

        public ResultCollector(List list, boolean bl) {
            this.fResult = list;
            this.fIsKeyDoubleQuoted = bl;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess textSearchMatchAccess) throws CoreException {
            int n = textSearchMatchAccess.getMatchOffset();
            int n2 = textSearchMatchAccess.getMatchLength();
            if (this.fIsKeyDoubleQuoted) {
                ++n;
                n2 -= 2;
            }
            this.fResult.add(new KeyReference((IStorage)textSearchMatchAccess.getFile(), n, n2));
            return true;
        }
    }
}

