/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;

class ChangeTypeContentProvider
implements ITreeContentProvider {
    private ChangeTypeRefactoring fGeneralizeType;

    ChangeTypeContentProvider(ChangeTypeRefactoring changeTypeRefactoring) {
        this.fGeneralizeType = changeTypeRefactoring;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof RootType) {
            return ((RootType)object).getChildren();
        }
        Object[] objectArray = this.getDirectSuperTypes((ITypeBinding)object).toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((ITypeBinding)object).getQualifiedName();
                String string2 = ((ITypeBinding)object2).getQualifiedName();
                return string.compareTo(string2);
            }
        });
        return objectArray;
    }

    public Set getDirectSuperTypes(ITypeBinding iTypeBinding) {
        HashSet<ITypeBinding> hashSet = new HashSet<ITypeBinding>();
        if (iTypeBinding.getSuperclass() != null) {
            hashSet.add(iTypeBinding.getSuperclass());
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            hashSet.add(iTypeBindingArray[n]);
            ++n;
        }
        if (this.fGeneralizeType.getOriginalType().isInterface() && iTypeBinding != this.fGeneralizeType.getObject()) {
            hashSet.add(this.fGeneralizeType.getObject());
        }
        return hashSet;
    }

    public Object[] getElements(Object object) {
        Assert.isTrue((boolean)(object instanceof RootType));
        return ((RootType)object).getChildren();
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object getParent(Object object) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    static class RootType {
        private ITypeBinding fRoot;

        RootType(ITypeBinding iTypeBinding) {
            this.fRoot = iTypeBinding;
        }

        public ITypeBinding[] getChildren() {
            return new ITypeBinding[]{this.fRoot};
        }
    }
}

