/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;

public class DelegateUIHelper {
    public static final String DELEGATE_UPDATING = "delegateUpdating";
    public static final String DELEGATE_DEPRECATION = "delegateDeprecation";
    static /* synthetic */ Class class$0;

    public static Button generateDeprecateDelegateCheckbox(Composite composite, Refactoring refactoring) {
        IDelegateUpdating iDelegateUpdating;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iDelegateUpdating = (IDelegateUpdating)refactoring.getAdapter((Class)clazz)) == null || !iDelegateUpdating.canEnableDelegateUpdating()) {
            return null;
        }
        final Button button = DelegateUIHelper.createCheckbox(composite, DelegateUIHelper.getDeprecateDelegateCheckBoxTitle(), DelegateUIHelper.loadDeprecateDelegateSetting(iDelegateUpdating));
        iDelegateUpdating.setDeprecateDelegates(button.getSelection());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iDelegateUpdating.setDeprecateDelegates(button.getSelection());
            }
        });
        return button;
    }

    public static Button generateLeaveDelegateCheckbox(Composite composite, Refactoring refactoring, boolean bl) {
        IDelegateUpdating iDelegateUpdating;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iDelegateUpdating = (IDelegateUpdating)refactoring.getAdapter((Class)clazz)) == null || !iDelegateUpdating.canEnableDelegateUpdating()) {
            return null;
        }
        final Button button = DelegateUIHelper.createCheckbox(composite, iDelegateUpdating.getDelegateUpdatingTitle(bl), DelegateUIHelper.loadLeaveDelegateSetting(iDelegateUpdating));
        iDelegateUpdating.setDelegateUpdating(button.getSelection());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iDelegateUpdating.setDelegateUpdating(button.getSelection());
            }
        });
        return button;
    }

    public static void saveLeaveDelegateSetting(Button button) {
        DelegateUIHelper.saveBooleanSetting(DELEGATE_UPDATING, button);
    }

    public static void saveDeprecateDelegateSetting(Button button) {
        DelegateUIHelper.saveBooleanSetting(DELEGATE_DEPRECATION, button);
    }

    public static boolean loadLeaveDelegateSetting(IDelegateUpdating iDelegateUpdating) {
        return DelegateUIHelper.getBooleanSetting(DELEGATE_UPDATING, iDelegateUpdating.getDelegateUpdating());
    }

    public static boolean loadDeprecateDelegateSetting(IDelegateUpdating iDelegateUpdating) {
        return DelegateUIHelper.getBooleanSetting(DELEGATE_DEPRECATION, iDelegateUpdating.getDeprecateDelegates());
    }

    public static String getDeprecateDelegateCheckBoxTitle() {
        return RefactoringMessages.DelegateCreator_deprecate_delegates;
    }

    private DelegateUIHelper() {
    }

    private static Button createCheckbox(Composite composite, String string, boolean bl) {
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setSelection(bl);
        return button;
    }

    private static boolean getBooleanSetting(String string, boolean bl) {
        String string2 = JavaPlugin.getDefault().getDialogSettings().get(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    private static void saveBooleanSetting(String string, Button button) {
        if (button != null && !button.isDisposed() && button.getEnabled()) {
            JavaPlugin.getDefault().getDialogSettings().put(string, button.getSelection());
        }
    }
}

