/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class MoveMembersWizard
extends RefactoringWizard {
    static /* synthetic */ Class class$0;

    public MoveMembersWizard(MoveRefactoring moveRefactoring) {
        super((Refactoring)moveRefactoring, 4);
        this.setDefaultPageTitle(RefactoringMessages.MoveMembersWizard_page_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveMembersInputPage());
    }

    private static class MoveMembersInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "MoveMembersInputPage";
        private static final long LABEL_FLAGS = JavaElementLabels.ALL_DEFAULT;
        private Combo fDestinationField;
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;
        private static final int MRU_COUNT = 10;
        private static List fgMruDestinations = new ArrayList(10);

        public MoveMembersInputPage() {
            super(PAGE_NAME);
        }

        public void setVisible(boolean bl) {
            if (bl) {
                String string = Messages.format(RefactoringMessages.MoveMembersInputPage_descriptionKey, new String[]{new Integer(this.getMoveProcessor().getMembersToMove().length).toString(), JavaModelUtil.getFullyQualifiedName(this.getMoveProcessor().getDeclaringType())});
                this.setDescription(string);
            }
            super.setVisible(bl);
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            this.addLabel(composite2);
            this.addDestinationControls(composite2);
            this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox(composite2, this.getRefactoring(), this.getMoveProcessor().getMembersToMove().length > 1);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            if (this.fLeaveDelegateCheckBox != null) {
                this.fLeaveDelegateCheckBox.setLayoutData((Object)gridData);
                this.fDeprecateDelegateCheckBox = new Button(composite2, 32);
                gridData = new GridData();
                gridData.horizontalAlignment = 4;
                gridData.horizontalIndent = gridLayout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                gridData.horizontalSpan = 2;
                this.fDeprecateDelegateCheckBox.setLayoutData((Object)gridData);
                this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(this.getMoveProcessor()));
                this.getMoveProcessor().setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ MoveMembersInputPage this$1;
                    {
                        this.this$1 = moveMembersInputPage;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MoveMembersInputPage.access$0(this.this$1).setDeprecateDelegates(MoveMembersInputPage.access$1(this.this$1).getSelection());
                    }
                });
                this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ MoveMembersInputPage this$1;
                    {
                        this.this$1 = moveMembersInputPage;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MoveMembersInputPage.access$1(this.this$1).setEnabled(MoveMembersInputPage.access$2(this.this$1).getSelection());
                    }
                });
            }
            this.setControl((Control)composite2);
            Dialog.applyDialogFont((Control)composite2);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.wst.jsdt.ui.move_members_wizard_page_context");
        }

        public void dispose() {
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            super.dispose();
        }

        private void addLabel(Composite composite) {
            Label label = new Label(composite, 0);
            IMember[] iMemberArray = this.getMoveProcessor().getMembersToMove();
            if (iMemberArray.length == 1) {
                label.setText(Messages.format(RefactoringMessages.MoveMembersInputPage_destination_single, JavaElementLabels.getElementLabel((IJavaElement)iMemberArray[0], LABEL_FLAGS)));
            } else {
                label.setText(Messages.format(RefactoringMessages.MoveMembersInputPage_destination_multi, String.valueOf(iMemberArray.length)));
            }
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
        }

        private void addDestinationControls(Composite composite) {
            this.fDestinationField = new Combo(composite, 2052);
            this.fDestinationField.setFocus();
            this.fDestinationField.setLayoutData((Object)new GridData(768));
            this.fDestinationField.setItems(fgMruDestinations.toArray(new String[fgMruDestinations.size()]));
            this.fDestinationField.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.handleDestinationChanged();
                }

                private void handleDestinationChanged() {
                    IStatus iStatus = JavaConventions.validateJavaTypeName((String)MoveMembersInputPage.access$3(this.this$1).getText());
                    if (iStatus.getSeverity() == 4) {
                        this.error(iStatus.getMessage());
                    } else {
                        try {
                            IStatus iStatus2;
                            IType iType = MoveMembersInputPage.access$0(this.this$1).getDeclaringType();
                            IType iType2 = iType.getJavaProject().findType(MoveMembersInputPage.access$3(this.this$1).getText());
                            if (iType2 == null) {
                                iType2 = iType.getJavaProject().findType(iType.getPackageFragment().getElementName(), MoveMembersInputPage.access$3(this.this$1).getText());
                            }
                            if ((iStatus2 = MoveMembersInputPage.access$4(iType2, MoveMembersInputPage.access$3(this.this$1).getText())).isOK()) {
                                this.this$1.setErrorMessage(null);
                                this.this$1.setPageComplete(true);
                            } else {
                                this.error(iStatus2.getMessage());
                            }
                        }
                        catch (JavaModelException javaModelException) {
                            JavaPlugin.log(javaModelException);
                            this.error(RefactoringMessages.MoveMembersInputPage_invalid_name);
                        }
                    }
                }

                private void error(String string) {
                    this.this$1.setErrorMessage(string);
                    this.this$1.setPageComplete(false);
                }
            });
            if (fgMruDestinations.size() > 0) {
                this.fDestinationField.select(0);
            } else {
                this.setPageComplete(false);
            }
            JavaTypeCompletionProcessor javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
            IPackageFragment iPackageFragment = (IPackageFragment)this.getMoveProcessor().getDeclaringType().getAncestor(4);
            javaTypeCompletionProcessor.setPackageFragment(iPackageFragment);
            ControlContentAssistHelper.createComboContentAssistant(this.fDestinationField, javaTypeCompletionProcessor);
            TextFieldNavigationHandler.install(this.fDestinationField);
            Button button = new Button(composite, 8);
            button.setText(RefactoringMessages.MoveMembersInputPage_browse);
            button.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MoveMembersInputPage.access$5(this.this$1);
                }
            });
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            try {
                String string = this.fDestinationField.getText();
                if (!fgMruDestinations.remove(string) && fgMruDestinations.size() >= 10) {
                    fgMruDestinations.remove(fgMruDestinations.size() - 1);
                }
                fgMruDestinations.add(0, string);
                this.getMoveProcessor().setDestinationTypeFullyQualifiedName(string);
            }
            catch (JavaModelException javaModelException) {
                ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), RefactoringMessages.MoveMembersInputPage_move_Member, RefactoringMessages.MoveMembersInputPage_exception);
            }
        }

        private IJavaSearchScope createWorkspaceSourceScope() {
            IJavaElement[] iJavaElementArray = new IJavaElement[]{this.getMoveProcessor().getDeclaringType().getJavaProject()};
            return SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray, (int)9);
        }

        private void openTypeSelectionDialog() {
            int n = 0;
            IJavaSearchScope iJavaSearchScope = this.createWorkspaceSourceScope();
            FilteredTypesSelectionDialog filteredTypesSelectionDialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), iJavaSearchScope, n);
            filteredTypesSelectionDialog.setTitle(RefactoringMessages.MoveMembersInputPage_choose_Type);
            filteredTypesSelectionDialog.setMessage(RefactoringMessages.MoveMembersInputPage_dialogMessage);
            filteredTypesSelectionDialog.setValidator(new ISelectionStatusValidator(this){
                final /* synthetic */ MoveMembersInputPage this$1;
                {
                    this.this$1 = moveMembersInputPage;
                }

                public IStatus validate(Object[] objectArray) {
                    Assert.isTrue((objectArray.length <= 1 ? 1 : 0) != 0);
                    if (objectArray.length == 0) {
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_Invalid_selection, null);
                    }
                    Object object = objectArray[0];
                    if (!(object instanceof IType)) {
                        return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_Invalid_selection, null);
                    }
                    IType iType = (IType)object;
                    return MoveMembersInputPage.access$4(iType, iType.getElementName());
                }
            });
            filteredTypesSelectionDialog.setInitialPattern(this.createInitialFilter());
            if (filteredTypesSelectionDialog.open() == 1) {
                return;
            }
            IType iType = (IType)filteredTypesSelectionDialog.getFirstResult();
            this.fDestinationField.setText(JavaModelUtil.getFullyQualifiedName(iType));
        }

        private String createInitialFilter() {
            if (!this.fDestinationField.getText().trim().equals("")) {
                return this.fDestinationField.getText();
            }
            return this.getMoveProcessor().getDeclaringType().getElementName();
        }

        private static IStatus validateDestinationType(IType iType, String string) {
            if (iType == null || !iType.exists()) {
                return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(RefactoringMessages.MoveMembersInputPage_not_found, string), null);
            }
            if (iType.isBinary()) {
                return new Status(4, JavaPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_no_binary, null);
            }
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        private MoveStaticMembersProcessor getMoveProcessor() {
            Refactoring refactoring = this.getRefactoring();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (MoveStaticMembersProcessor)refactoring.getAdapter((Class)clazz);
        }

        static /* synthetic */ MoveStaticMembersProcessor access$0(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.getMoveProcessor();
        }

        static /* synthetic */ Button access$1(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.fDeprecateDelegateCheckBox;
        }

        static /* synthetic */ Button access$2(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.fLeaveDelegateCheckBox;
        }

        static /* synthetic */ Combo access$3(MoveMembersInputPage moveMembersInputPage) {
            return moveMembersInputPage.fDestinationField;
        }

        static /* synthetic */ IStatus access$4(IType iType, String string) {
            return MoveMembersInputPage.validateDestinationType(iType, string);
        }

        static /* synthetic */ void access$5(MoveMembersInputPage moveMembersInputPage) {
            moveMembersInputPage.openTypeSelectionDialog();
        }
    }
}

