/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringSavePreferences;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.ListDialog;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;
    private final int fSaveMode;
    public static final int SAVE_ALL_ALWAYS_ASK = 1;
    public static final int SAVE_ALL = 2;
    public static final int SAVE_NON_JAVA_UPDATES = 3;
    public static final int SAVE_JAVA_ONLY_UPDATES = 4;
    public static final int SAVE_NOTHING = 5;

    public RefactoringSaveHelper(int n) {
        Assert.isTrue((n == 1 || n == 2 || n == 3 || n == 4 || n == 5 ? 1 : 0) != 0);
        this.fSaveMode = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        IEditorPart[] iEditorPartArray;
        switch (this.fSaveMode) {
            case 1: 
            case 2: {
                iEditorPartArray = EditorUtility.getDirtyEditors();
                break;
            }
            case 3: {
                iEditorPartArray = EditorUtility.getDirtyEditorsToSave(false);
                break;
            }
            case 4: {
                iEditorPartArray = EditorUtility.getDirtyEditorsToSave(false);
                break;
            }
            case 5: {
                return true;
            }
            default: {
                throw new IllegalStateException(Integer.toString(this.fSaveMode));
            }
        }
        if (iEditorPartArray.length == 0) {
            return true;
        }
        if (!this.askSaveAllDirtyEditors(shell, iEditorPartArray)) {
            return false;
        }
        try {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            boolean bl = iWorkspaceDescription.isAutoBuilding();
            iWorkspaceDescription.setAutoBuilding(false);
            iWorkspace.setDescription(iWorkspaceDescription);
            try {
                block16: {
                    block18: {
                        block17: {
                            if (this.fSaveMode != 1 && this.fSaveMode != 2 && !RefactoringSavePreferences.getSaveAllEditors()) break block17;
                            if (JavaPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) break block16;
                            break block18;
                        }
                        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                                int n = iEditorPartArray.length;
                                iProgressMonitor.beginTask("", n);
                                int n2 = 0;
                                while (n2 < n) {
                                    IEditorPart iEditorPart = iEditorPartArray[n2];
                                    iEditorPart.doSave((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                    if (iProgressMonitor.isCanceled()) {
                                        throw new InterruptedException();
                                    }
                                    ++n2;
                                }
                                iProgressMonitor.done();
                            }
                        };
                        try {
                            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)JavaPlugin.getActiveWorkbenchWindow(), iRunnableWithProgress, null);
                            break block16;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            ExceptionHandler.handle(invocationTargetException, shell, RefactoringMessages.RefactoringStarter_saving, RefactoringMessages.RefactoringStarter_unexpected_exception);
                        }
                    }
                    Object var8_7 = null;
                    iWorkspaceDescription.setAutoBuilding(bl);
                    iWorkspace.setDescription(iWorkspaceDescription);
                    return false;
                }
                this.fFilesSaved = true;
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                iWorkspaceDescription.setAutoBuilding(bl);
                iWorkspace.setDescription(iWorkspaceDescription);
                throw throwable;
            }
            iWorkspaceDescription.setAutoBuilding(bl);
            iWorkspace.setDescription(iWorkspaceDescription);
            return true;
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, shell, RefactoringMessages.RefactoringStarter_saving, RefactoringMessages.RefactoringStarter_unexpected_exception);
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(JavaPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean askSaveAllDirtyEditors(Shell shell, IEditorPart[] iEditorPartArray) {
        boolean bl;
        boolean bl2 = bl = this.fSaveMode != 1;
        if (bl && RefactoringSavePreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog listDialog = new ListDialog(shell){
            {
                this.setShellStyle(this.getShellStyle() | 0x10000);
            }

            protected Control createDialogArea(Composite composite) {
                Composite composite2 = (Composite)super.createDialogArea(composite);
                if (bl) {
                    Button button = new Button(composite2, 32);
                    button.setText(RefactoringMessages.RefactoringStarter_always_save);
                    button.setSelection(RefactoringSavePreferences.getSaveAllEditors());
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(this, button){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ Button val$check;
                        {
                            this.this$1 = var1_1;
                            this.val$check = button;
                        }

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            RefactoringSavePreferences.setSaveAllEditors(this.val$check.getSelection());
                        }
                    });
                    2.applyDialogFont((Control)composite2);
                }
                return composite2;
            }
        };
        listDialog.setTitle(RefactoringMessages.RefactoringStarter_save_all_resources);
        listDialog.setAddCancelButton(true);
        listDialog.setLabelProvider(this.createDialogLabelProvider());
        listDialog.setMessage(RefactoringMessages.RefactoringStarter_must_save);
        listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        listDialog.setInput(Arrays.asList(iEditorPartArray));
        return listDialog.open() == 0;
    }

    public boolean hasFilesSaved() {
        return this.fFilesSaved;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object object) {
                return ((IEditorPart)object).getTitleImage();
            }

            public String getText(Object object) {
                return ((IEditorPart)object).getTitle();
            }
        };
    }
}

