/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;

public class JavaPackageCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private IPackageFragmentRoot fPackageFragmentRoot;
    private CompletionProposalComparator fComparator = new CompletionProposalComparator();
    private ILabelProvider fLabelProvider;
    private char[] fProposalAutoActivationSet;

    public JavaPackageCompletionProcessor() {
        this((ILabelProvider)new JavaElementLabelProvider(256));
    }

    public JavaPackageCompletionProcessor(ILabelProvider iLabelProvider) {
        this.fLabelProvider = iLabelProvider;
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = string.toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl iContentAssistSubjectControl, int n) {
        if (this.fPackageFragmentRoot == null) {
            return null;
        }
        String string = iContentAssistSubjectControl.getDocument().get();
        ICompletionProposal[] iCompletionProposalArray = this.createPackagesProposals(n, string);
        Arrays.sort(iCompletionProposalArray, this.fComparator);
        return iCompletionProposalArray;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        this.fPackageFragmentRoot = iPackageFragmentRoot;
    }

    private ICompletionProposal[] createPackagesProposals(int n, String string) {
        ArrayList<JavaCompletionProposal> arrayList = new ArrayList<JavaCompletionProposal>();
        String string2 = string.substring(0, n);
        try {
            IJavaElement[] iJavaElementArray = this.fPackageFragmentRoot.getChildren();
            int n2 = 0;
            while (n2 < iJavaElementArray.length) {
                IPackageFragment iPackageFragment = (IPackageFragment)iJavaElementArray[n2];
                String string3 = iPackageFragment.getElementName();
                if (string3.length() != 0 && string3.startsWith(string2)) {
                    Image image = this.fLabelProvider.getImage((Object)iPackageFragment);
                    JavaCompletionProposal javaCompletionProposal = new JavaCompletionProposal(string3, 0, string.length(), image, this.fLabelProvider.getText((Object)iPackageFragment), 0);
                    arrayList.add(javaCompletionProposal);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }
}

