/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class DeleteAction
extends SelectionDispatchAction {
    public DeleteAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ReorgMessages.DeleteAction_3);
        this.setDescription(ReorgMessages.DeleteAction_4);
        ISharedImages iSharedImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.delete_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (ReorgUtils.containsOnlyProjects(iStructuredSelection.toList())) {
            this.setEnabled(this.createWorkbenchAction(iStructuredSelection).isEnabled());
            return;
        }
        try {
            this.setEnabled(RefactoringAvailabilityTester.isDeleteAvailable(iStructuredSelection.toArray()));
        }
        catch (CoreException coreException) {
            if (JavaModelUtil.isExceptionToBeLogged(coreException)) {
                JavaPlugin.log(coreException);
            }
            this.setEnabled(false);
        }
    }

    private IAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        DeleteResourceAction deleteResourceAction = new DeleteResourceAction(this.getShell());
        deleteResourceAction.selectionChanged(iStructuredSelection);
        return deleteResourceAction;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (ReorgUtils.containsOnlyProjects(iStructuredSelection.toList())) {
            this.createWorkbenchAction(iStructuredSelection).run();
            return;
        }
        try {
            RefactoringExecutionStarter.startDeleteRefactoring(iStructuredSelection.toArray(), this.getShell());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

