/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.MessageWizardPage;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgQueries;

public class DeleteWizard
extends RefactoringWizard {
    public DeleteWizard(Refactoring refactoring) {
        super(refactoring, 92);
        this.setDefaultPageTitle(RefactoringMessages.DeleteWizard_1);
        ((JavaDeleteProcessor)((DeleteRefactoring)this.getRefactoring()).getProcessor()).setQueries(new ReorgQueries((Wizard)this));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new DeleteInputPage());
    }

    public int getMessageLineWidthInChars() {
        return 0;
    }

    public boolean needsProgressMonitor() {
        DeleteRefactoring deleteRefactoring = (DeleteRefactoring)this.getRefactoring();
        RefactoringProcessor refactoringProcessor = deleteRefactoring.getProcessor();
        if (refactoringProcessor instanceof JavaDeleteProcessor) {
            return ((JavaDeleteProcessor)refactoringProcessor).needsProgressMonitor();
        }
        return super.needsProgressMonitor();
    }

    private static class DeleteInputPage
    extends MessageWizardPage {
        private static final String PAGE_NAME = "DeleteInputPage";
        private static final String DIALOG_SETTINGS_DELETE_SUB_PACKAGES = "deleteSubPackages";
        private Button fDeleteSubPackagesCheckBox;

        public DeleteInputPage() {
            super(PAGE_NAME, true, 2);
        }

        protected String getMessageString() {
            try {
                if (1 == this.numberOfSelectedElements()) {
                    String string = this.createConfirmationStringForOneElement();
                    String string2 = this.getNameOfSingleSelectedElement();
                    return Messages.format(string, new String[]{string2});
                }
                String string = this.createConfirmationStringForManyElements();
                return Messages.format(string, new String[]{String.valueOf(this.numberOfSelectedElements())});
            }
            catch (JavaModelException javaModelException) {
                if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                    JavaPlugin.log(javaModelException);
                }
                this.setPageComplete(false);
                if (javaModelException.isDoesNotExist()) {
                    return RefactoringMessages.DeleteWizard_12;
                }
                return RefactoringMessages.DeleteWizard_2;
            }
        }

        public void createControl(Composite composite) {
            super.createControl(composite);
            if (this.getDeleteProcessor().hasSubPackagesToDelete()) {
                this.addDeleteSubPackagesCheckBox();
            }
        }

        private void addDeleteSubPackagesCheckBox() {
            Composite composite = new Composite((Composite)this.getControl(), 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.horizontalSpacing = 10;
            composite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            composite.setLayoutData((Object)gridData);
            boolean bl = this.getRefactoringSettings().getBoolean(DIALOG_SETTINGS_DELETE_SUB_PACKAGES);
            this.fDeleteSubPackagesCheckBox = new Button(composite, 32);
            this.fDeleteSubPackagesCheckBox.setText(RefactoringMessages.DeleteWizard_also_delete_sub_packages);
            this.fDeleteSubPackagesCheckBox.setSelection(bl);
            this.fDeleteSubPackagesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DeleteInputPage this$1;
                {
                    this.this$1 = deleteInputPage;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DeleteInputPage.access$0(this.this$1).setDeleteSubPackages(DeleteInputPage.access$1(this.this$1).getSelection());
                }
            });
            this.getDeleteProcessor().setDeleteSubPackages(this.fDeleteSubPackagesCheckBox.getSelection());
        }

        private String getNameOfSingleSelectedElement() throws JavaModelException {
            if (this.getSingleSelectedResource() != null) {
                return ReorgUtils.getName(this.getSingleSelectedResource());
            }
            return ReorgUtils.getName(this.getSingleSelectedJavaElement());
        }

        private IJavaElement getSingleSelectedJavaElement() {
            IJavaElement[] iJavaElementArray = this.getSelectedJavaElements();
            return iJavaElementArray.length == 1 ? iJavaElementArray[0] : null;
        }

        private IResource getSingleSelectedResource() {
            IResource[] iResourceArray = this.getSelectedResources();
            return iResourceArray.length == 1 ? iResourceArray[0] : null;
        }

        private int numberOfSelectedElements() {
            return this.getSelectedJavaElements().length + this.getSelectedResources().length;
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getDeleteProcessor().wasCanceled();
        }

        protected boolean saveSettings() {
            if (this.getContainer() instanceof Dialog) {
                return ((Dialog)this.getContainer()).getReturnCode() == 0;
            }
            return true;
        }

        public void dispose() {
            if (this.fDeleteSubPackagesCheckBox != null && this.saveSettings()) {
                this.getRefactoringSettings().put(DIALOG_SETTINGS_DELETE_SUB_PACKAGES, this.fDeleteSubPackagesCheckBox.getSelection());
            }
            super.dispose();
        }

        private String createConfirmationStringForOneElement() throws JavaModelException {
            IJavaElement[] iJavaElementArray = this.getSelectedJavaElements();
            if (iJavaElementArray.length == 1) {
                IJavaElement iJavaElement = iJavaElementArray[0];
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(iJavaElement)) {
                    return RefactoringMessages.DeleteWizard_3;
                }
                if (!DeleteInputPage.isLinkedResource(iJavaElement)) {
                    return RefactoringMessages.DeleteWizard_4;
                }
                if (DeleteInputPage.isLinkedPackageOrPackageFragmentRoot(iJavaElement)) {
                    return RefactoringMessages.DeleteWizard_6;
                }
                return RefactoringMessages.DeleteWizard_5;
            }
            if (DeleteInputPage.isLinked(this.getSelectedResources()[0])) {
                return RefactoringMessages.DeleteWizard_7;
            }
            return RefactoringMessages.DeleteWizard_8;
        }

        private String createConfirmationStringForManyElements() throws JavaModelException {
            IJavaElement[] iJavaElementArray;
            IResource[] iResourceArray = this.getSelectedResources();
            if (!DeleteInputPage.containsLinkedResources(iResourceArray, iJavaElementArray = this.getSelectedJavaElements())) {
                return RefactoringMessages.DeleteWizard_9;
            }
            if (!DeleteInputPage.containsLinkedPackagesOrPackageFragmentRoots(iJavaElementArray)) {
                return RefactoringMessages.DeleteWizard_10;
            }
            return RefactoringMessages.DeleteWizard_11;
        }

        private static boolean isLinkedPackageOrPackageFragmentRoot(IJavaElement iJavaElement) {
            if (iJavaElement instanceof IPackageFragment || iJavaElement instanceof IPackageFragmentRoot) {
                return DeleteInputPage.isLinkedResource(iJavaElement);
            }
            return false;
        }

        private static boolean containsLinkedPackagesOrPackageFragmentRoots(IJavaElement[] iJavaElementArray) {
            int n = 0;
            while (n < iJavaElementArray.length) {
                IJavaElement iJavaElement = iJavaElementArray[n];
                if (DeleteInputPage.isLinkedPackageOrPackageFragmentRoot(iJavaElement)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static boolean containsLinkedResources(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws JavaModelException {
            IJavaElement iJavaElement;
            int n = 0;
            while (n < iJavaElementArray.length) {
                iJavaElement = iJavaElementArray[n];
                if (DeleteInputPage.isLinkedResource(iJavaElement)) {
                    return true;
                }
                if (DeleteInputPage.isDefaultPackageWithLinkedFiles(iJavaElement)) {
                    return true;
                }
                ++n;
            }
            n = 0;
            while (n < iResourceArray.length) {
                iJavaElement = iResourceArray[n];
                if (DeleteInputPage.isLinked((IResource)iJavaElement)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static boolean isDefaultPackageWithLinkedFiles(Object object) throws JavaModelException {
            if (!JavaElementUtil.isDefaultPackage(object)) {
                return false;
            }
            IPackageFragment iPackageFragment = (IPackageFragment)object;
            ICompilationUnit[] iCompilationUnitArray = iPackageFragment.getCompilationUnits();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                if (DeleteInputPage.isLinkedResource((IJavaElement)iCompilationUnitArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static boolean isLinkedResource(IJavaElement iJavaElement) {
            return DeleteInputPage.isLinked(ReorgUtils.getResource(iJavaElement));
        }

        private static boolean isLinked(IResource iResource) {
            return iResource != null && iResource.isLinked();
        }

        private IJavaElement[] getSelectedJavaElements() {
            return this.getDeleteProcessor().getJavaElementsToDelete();
        }

        private IResource[] getSelectedResources() {
            return this.getDeleteProcessor().getResourcesToDelete();
        }

        private JavaDeleteProcessor getDeleteProcessor() {
            return (JavaDeleteProcessor)((DeleteRefactoring)this.getRefactoring()).getProcessor();
        }

        static /* synthetic */ JavaDeleteProcessor access$0(DeleteInputPage deleteInputPage) {
            return deleteInputPage.getDeleteProcessor();
        }

        static /* synthetic */ Button access$1(DeleteInputPage deleteInputPage) {
            return deleteInputPage.fDeleteSubPackagesCheckBox;
        }
    }
}

