/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgUserInputPage;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class ReorgMoveWizard
extends RefactoringWizard {
    static /* synthetic */ Class class$0;

    public ReorgMoveWizard(MoveRefactoring moveRefactoring) {
        super((Refactoring)moveRefactoring, 4 | ReorgMoveWizard.computeHasPreviewPage(moveRefactoring));
        if (ReorgMoveWizard.isTextualMove(moveRefactoring)) {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_textual_move);
        } else {
            this.setDefaultPageTitle(ReorgMessages.ReorgMoveWizard_3);
        }
    }

    private static boolean isTextualMove(MoveRefactoring moveRefactoring) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JavaMoveProcessor javaMoveProcessor = (JavaMoveProcessor)moveRefactoring.getAdapter((Class)clazz);
        return javaMoveProcessor.isTextualMove();
    }

    private static int computeHasPreviewPage(MoveRefactoring moveRefactoring) {
        JavaMoveProcessor javaMoveProcessor;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaMoveProcessor = (JavaMoveProcessor)moveRefactoring.getAdapter((Class)clazz)).canUpdateReferences() || javaMoveProcessor.canEnableQualifiedNameUpdating()) {
            return 0;
        }
        return 16;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveInputPage());
    }

    private static class MoveInputPage
    extends ReorgUserInputPage {
        private static final String PAGE_NAME = "MoveInputPage";
        private Button fReferenceCheckbox;
        private Button fQualifiedNameCheckbox;
        private QualifiedNameComponent fQualifiedNameComponent;
        private ICreateTargetQuery fCreateTargetQuery;
        private Object fDestination;

        public MoveInputPage() {
            super(PAGE_NAME);
        }

        private JavaMoveProcessor getJavaMoveProcessor() {
            Refactoring refactoring = this.getRefactoring();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaMoveProcessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (JavaMoveProcessor)refactoring.getAdapter((Class)clazz);
        }

        protected Object getInitiallySelectedElement() {
            return this.getJavaMoveProcessor().getCommonParentForInputElements();
        }

        protected IJavaElement[] getJavaElements() {
            return this.getJavaMoveProcessor().getJavaElements();
        }

        protected IResource[] getResources() {
            return this.getJavaMoveProcessor().getResources();
        }

        protected IReorgDestinationValidator getDestinationValidator() {
            return this.getJavaMoveProcessor();
        }

        protected boolean performFinish() {
            return super.performFinish() || this.getJavaMoveProcessor().wasCanceled();
        }

        protected RefactoringStatus verifyDestination(Object object) throws JavaModelException {
            JavaMoveProcessor javaMoveProcessor = this.getJavaMoveProcessor();
            RefactoringStatus refactoringStatus = object instanceof IJavaElement ? javaMoveProcessor.setDestination((IJavaElement)object) : (object instanceof IResource ? javaMoveProcessor.setDestination((IResource)object) : RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.ReorgMoveWizard_4));
            this.updateUIStatus();
            this.fDestination = object;
            return refactoringStatus;
        }

        private void updateUIStatus() {
            this.getRefactoringWizard().setForcePreviewReview(false);
            JavaMoveProcessor javaMoveProcessor = this.getJavaMoveProcessor();
            if (this.fReferenceCheckbox != null) {
                this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
                javaMoveProcessor.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
            }
            if (this.fQualifiedNameCheckbox != null) {
                boolean bl = javaMoveProcessor.canEnableQualifiedNameUpdating();
                this.fQualifiedNameCheckbox.setEnabled(bl);
                if (bl) {
                    this.fQualifiedNameComponent.setEnabled(javaMoveProcessor.getUpdateQualifiedNames());
                    if (javaMoveProcessor.getUpdateQualifiedNames()) {
                        this.getRefactoringWizard().setForcePreviewReview(true);
                    }
                } else {
                    this.fQualifiedNameComponent.setEnabled(false);
                }
                javaMoveProcessor.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
            }
        }

        private void addUpdateReferenceComponent(Composite composite) {
            JavaMoveProcessor javaMoveProcessor = this.getJavaMoveProcessor();
            if (!javaMoveProcessor.canUpdateReferences()) {
                return;
            }
            this.fReferenceCheckbox = new Button(composite, 32);
            this.fReferenceCheckbox.setText(ReorgMessages.JdtMoveAction_update_references);
            this.fReferenceCheckbox.setSelection(javaMoveProcessor.getUpdateReferences());
            this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
            this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, javaMoveProcessor){
                final /* synthetic */ MoveInputPage this$1;
                private final /* synthetic */ JavaMoveProcessor val$processor;
                {
                    this.this$1 = moveInputPage;
                    this.val$processor = javaMoveProcessor;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.val$processor.setUpdateReferences(((Button)selectionEvent.widget).getSelection());
                    MoveInputPage.access$0(this.this$1);
                }
            });
        }

        private void addUpdateQualifiedNameComponent(Composite composite, int n) {
            JavaMoveProcessor javaMoveProcessor = this.getJavaMoveProcessor();
            if (!javaMoveProcessor.canEnableQualifiedNameUpdating() || !javaMoveProcessor.canUpdateQualifiedNames()) {
                return;
            }
            this.fQualifiedNameCheckbox = new Button(composite, 32);
            int n2 = n + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
            this.fQualifiedNameCheckbox.setText(RefactoringMessages.RenameInputWizardPage_update_qualified_names);
            this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
            this.fQualifiedNameCheckbox.setSelection(javaMoveProcessor.getUpdateQualifiedNames());
            this.fQualifiedNameComponent = new QualifiedNameComponent(composite, 0, javaMoveProcessor, this.getRefactoringSettings());
            this.fQualifiedNameComponent.setLayoutData(new GridData(768));
            GridData gridData = (GridData)this.fQualifiedNameComponent.getLayoutData();
            gridData.horizontalAlignment = 4;
            gridData.horizontalIndent = n2;
            this.updateQualifiedNameUpdating(javaMoveProcessor, javaMoveProcessor.getUpdateQualifiedNames());
            this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, javaMoveProcessor){
                final /* synthetic */ MoveInputPage this$1;
                private final /* synthetic */ JavaMoveProcessor val$processor;
                {
                    this.this$1 = moveInputPage;
                    this.val$processor = javaMoveProcessor;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = ((Button)selectionEvent.widget).getSelection();
                    MoveInputPage.access$1(this.this$1, this.val$processor, bl);
                }
            });
        }

        private void updateQualifiedNameUpdating(JavaMoveProcessor javaMoveProcessor, boolean bl) {
            this.fQualifiedNameComponent.setEnabled(bl);
            javaMoveProcessor.setUpdateQualifiedNames(bl);
            this.updateUIStatus();
        }

        public void createControl(Composite composite) {
            Composite composite2;
            boolean bl;
            boolean bl2 = bl = !this.getJavaMoveProcessor().hasDestinationSet();
            if (bl) {
                this.fCreateTargetQuery = this.getJavaMoveProcessor().getCreateTargetQuery();
                super.createControl(composite);
                this.getTreeViewer().getTree().setFocus();
                composite2 = (Composite)super.getControl();
            } else {
                this.initializeDialogUnits((Control)composite);
                composite2 = new Composite(composite, 0);
                this.setControl((Control)composite2);
                composite2.setLayout((Layout)new GridLayout());
                Dialog.applyDialogFont((Control)composite2);
            }
            this.addUpdateReferenceComponent(composite2);
            this.addUpdateQualifiedNameComponent(composite2, ((GridLayout)composite2.getLayout()).marginWidth);
            this.setControl((Control)composite2);
            Dialog.applyDialogFont((Control)composite2);
        }

        protected Control addLabel(Composite composite) {
            if (this.fCreateTargetQuery != null) {
                Composite composite2 = new Composite(composite, 0);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 0;
                composite2.setLayout((Layout)gridLayout);
                composite2.setLayoutData((Object)new GridData(768));
                Control control = super.addLabel(composite2);
                control.addTraverseListener(new TraverseListener(this){
                    final /* synthetic */ MoveInputPage this$1;
                    {
                        this.this$1 = moveInputPage;
                    }

                    public void keyTraversed(TraverseEvent traverseEvent) {
                        if (traverseEvent.detail == 128 && traverseEvent.doit) {
                            traverseEvent.detail = 0;
                            this.this$1.getTreeViewer().getTree().setFocus();
                        }
                    }
                });
                Button button = new Button(composite2, 8);
                button.setText(this.fCreateTargetQuery.getNewButtonLabel());
                GridData gridData = new GridData(642);
                gridData.widthHint = SWTUtil.getButtonWidthHint(button);
                button.setLayoutData((Object)gridData);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ MoveInputPage this$1;
                    {
                        this.this$1 = moveInputPage;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MoveInputPage.access$2(this.this$1);
                    }
                });
                return composite2;
            }
            return super.addLabel(composite);
        }

        private boolean canUpdateReferences() {
            return this.getJavaMoveProcessor().canUpdateReferences();
        }

        private void doNewButtonPressed() {
            Object object = this.fCreateTargetQuery.getCreatedTarget(this.fDestination);
            if (object != null) {
                TreeViewer treeViewer = this.getTreeViewer();
                ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
                treeViewer.refresh(iTreeContentProvider.getParent(object));
                treeViewer.setSelection((ISelection)new StructuredSelection(object), true);
                treeViewer.getTree().setFocus();
            }
        }

        static /* synthetic */ void access$0(MoveInputPage moveInputPage) {
            moveInputPage.updateUIStatus();
        }

        static /* synthetic */ void access$1(MoveInputPage moveInputPage, JavaMoveProcessor javaMoveProcessor, boolean bl) {
            moveInputPage.updateQualifiedNameUpdating(javaMoveProcessor, bl);
        }

        static /* synthetic */ void access$2(MoveInputPage moveInputPage) {
            moveInputPage.doNewButtonPressed();
        }
    }
}

