/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;

public class JavaElementProvider
implements IInformationProvider,
IInformationProviderExtension {
    private JavaEditor fEditor;
    private boolean fUseCodeResolve = false;

    public JavaElementProvider(IEditorPart iEditorPart) {
        if (iEditorPart instanceof JavaEditor) {
            this.fEditor = (JavaEditor)iEditorPart;
        }
    }

    public JavaElementProvider(IEditorPart iEditorPart, boolean bl) {
        this(iEditorPart);
        this.fUseCodeResolve = bl;
    }

    public IRegion getSubject(ITextViewer iTextViewer, int n) {
        if (iTextViewer != null && this.fEditor != null) {
            IRegion iRegion = JavaWordFinder.findWord(iTextViewer.getDocument(), n);
            if (iRegion != null) {
                return iRegion;
            }
            return new Region(n, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer iTextViewer, IRegion iRegion) {
        return this.getInformation2(iTextViewer, iRegion).toString();
    }

    public Object getInformation2(ITextViewer iTextViewer, IRegion iRegion) {
        if (this.fEditor == null) {
            return null;
        }
        try {
            IStructuredSelection iStructuredSelection;
            if (this.fUseCodeResolve && !(iStructuredSelection = SelectionConverter.getStructuredSelection((IWorkbenchPart)this.fEditor)).isEmpty()) {
                return iStructuredSelection.getFirstElement();
            }
            iStructuredSelection = SelectionConverter.getElementAtOffset(this.fEditor);
            if (iStructuredSelection != null) {
                return iStructuredSelection;
            }
            return EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }
}

