/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import com.ibm.icu.text.BreakIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.graphics.GC;

public class LineBreakingReader {
    private BufferedReader fReader;
    private GC fGC;
    private int fMaxWidth;
    private String fLine;
    private int fOffset;
    private BreakIterator fLineBreakIterator;
    private boolean fBreakWords;

    public LineBreakingReader(Reader reader, GC gC, int n) {
        this.fReader = new BufferedReader(reader);
        this.fGC = gC;
        this.fMaxWidth = n;
        this.fOffset = 0;
        this.fLine = null;
        this.fLineBreakIterator = BreakIterator.getLineInstance();
        this.fBreakWords = true;
    }

    public boolean isFormattedLine() {
        return this.fLine != null;
    }

    public String readLine() throws IOException {
        String string;
        int n;
        if (this.fLine == null) {
            String string2 = this.fReader.readLine();
            if (string2 == null) {
                return null;
            }
            int n2 = this.fGC.textExtent((String)string2).x;
            if (n2 < this.fMaxWidth) {
                return string2;
            }
            this.fLine = string2;
            this.fLineBreakIterator.setText(string2);
            this.fOffset = 0;
        }
        if ((n = this.findNextBreakOffset(this.fOffset)) != -1) {
            string = this.fLine.substring(this.fOffset, n);
            this.fOffset = this.findWordBegin(n);
            if (this.fOffset == this.fLine.length()) {
                this.fLine = null;
            }
        } else {
            string = this.fLine.substring(this.fOffset);
            this.fLine = null;
        }
        return string;
    }

    private int findNextBreakOffset(int n) {
        int n2 = 0;
        int n3 = this.fLineBreakIterator.following(n);
        while (n3 != -1) {
            String string = this.fLine.substring(n, n3);
            int n4 = this.fGC.textExtent((String)string).x;
            int n5 = n4 + n2;
            if (n5 > this.fMaxWidth) {
                if (n2 > 0) {
                    return n;
                }
                if (!this.fBreakWords) {
                    return n3;
                }
                int n6 = string.length();
                while (n6 >= 0) {
                    string = string.substring(0, --n6);
                    n4 = this.fGC.textExtent((String)string).x;
                    if (n4 + n2 >= this.fMaxWidth) continue;
                    return n + n6;
                }
                return n3;
            }
            n2 = n5;
            n = n3;
            n3 = this.fLineBreakIterator.next();
        }
        return n3;
    }

    private int findWordBegin(int n) {
        while (n < this.fLine.length() && Character.isWhitespace(this.fLine.charAt(n))) {
            ++n;
        }
        return n;
    }
}

