/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class AddTypeParameterProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private CompilationUnit fAstRoot;
    private final String fTypeParamName;
    private final ITypeBinding[] fBounds;

    public AddTypeParameterProposal(ICompilationUnit iCompilationUnit, IBinding iBinding, CompilationUnit compilationUnit, String string, ITypeBinding[] iTypeBindingArray, int n) {
        super("", iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.field_public_obj.gif"));
        Assert.isTrue((iBinding != null && Bindings.isDeclarationBinding(iBinding) ? 1 : 0) != 0);
        Assert.isTrue((iBinding instanceof IMethodBinding || iBinding instanceof ITypeBinding ? 1 : 0) != 0);
        this.fBinding = iBinding;
        this.fAstRoot = compilationUnit;
        this.fTypeParamName = string;
        this.fBounds = iTypeBindingArray;
        if (iBinding instanceof IMethodBinding) {
            boolean bl = this.fAstRoot.findDeclaringNode(iBinding) != null;
            Object[] objectArray = new String[]{this.fTypeParamName, ASTResolving.getMethodSignature((IMethodBinding)iBinding, bl)};
            this.setDisplayName(Messages.format(CorrectionMessages.AddTypeParameterProposal_method_label, objectArray));
        } else {
            Object[] objectArray = new String[]{this.fTypeParamName, ASTResolving.getTypeSignature((ITypeBinding)iBinding)};
            this.setDisplayName(Messages.format(CorrectionMessages.AddTypeParameterProposal_type_label, objectArray));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        List list;
        ListRewrite listRewrite;
        TypeDeclaration typeDeclaration;
        Javadoc javadoc;
        Object object;
        CompilationUnit compilationUnit;
        ASTNode aSTNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode aSTNode2 = null;
        if (aSTNode != null) {
            aSTNode2 = aSTNode;
            this.createImportRewrite(this.fAstRoot);
        } else {
            compilationUnit = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            aSTNode2 = compilationUnit.findDeclaringNode(this.fBinding.getKey());
            this.createImportRewrite(compilationUnit);
        }
        compilationUnit = aSTNode2.getAST();
        TypeParameter typeParameter = compilationUnit.newTypeParameter();
        typeParameter.setName(compilationUnit.newSimpleName(this.fTypeParamName));
        if (this.fBounds != null && this.fBounds.length > 0) {
            object = typeParameter.typeBounds();
            int n = 0;
            while (n < this.fBounds.length) {
                javadoc = this.getImportRewrite().addImport(this.fBounds[n], (AST)compilationUnit);
                object.add(javadoc);
                ++n;
            }
        }
        object = ASTRewrite.create((AST)compilationUnit);
        if (aSTNode2 instanceof TypeDeclaration) {
            typeDeclaration = (TypeDeclaration)aSTNode2;
            listRewrite = object.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            list = typeDeclaration.typeParameters();
            javadoc = typeDeclaration.getJavadoc();
        } else {
            typeDeclaration = (MethodDeclaration)aSTNode2;
            listRewrite = object.getListRewrite(aSTNode2, MethodDeclaration.TYPE_PARAMETERS_PROPERTY);
            list = typeDeclaration.typeParameters();
            javadoc = typeDeclaration.getJavadoc();
        }
        listRewrite.insertLast((ASTNode)typeParameter, null);
        if (javadoc != null && list != null) {
            typeDeclaration = object.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            Set set = JavadocTagsSubProcessor.getPreviousTypeParamNames(list, null);
            String string = String.valueOf('<') + this.fTypeParamName + '>';
            TagElement tagElement = compilationUnit.newTagElement();
            tagElement.setTagName("@param");
            TextElement textElement = compilationUnit.newTextElement();
            textElement.setText(string);
            tagElement.fragments().add(textElement);
            JavadocTagsSubProcessor.insertTag((ListRewrite)typeDeclaration, tagElement, set);
        }
        return object;
    }
}

