/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewAnnotationCreationWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewEnumCreationWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewInterfaceCreationWizard;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.wizards.NewTypeWizardPage;

public class NewCUCompletionUsingWizardProposal
extends ChangeCorrectionProposal {
    public static final int K_CLASS = 1;
    public static final int K_INTERFACE = 2;
    public static final int K_ENUM = 3;
    public static final int K_ANNOTATION = 4;
    private Name fNode;
    private ICompilationUnit fCompilationUnit;
    private int fTypeKind;
    private IJavaElement fTypeContainer;
    private String fTypeNameWithParameters;
    private IType fCreatedType;
    private boolean fShowDialog;

    public NewCUCompletionUsingWizardProposal(ICompilationUnit iCompilationUnit, Name name, int n, IJavaElement iJavaElement, int n2) {
        super("", null, n2, null);
        this.fCompilationUnit = iCompilationUnit;
        this.fNode = name;
        this.fTypeKind = n;
        this.fTypeContainer = iJavaElement;
        this.fTypeNameWithParameters = NewCUCompletionUsingWizardProposal.getTypeName(n, name);
        this.fCreatedType = null;
        String string = ASTNodes.getQualifier(name);
        String string2 = this.fTypeNameWithParameters;
        boolean bl = iJavaElement instanceof IType;
        switch (n) {
            case 1: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.class_obj.gif"));
                if (bl) {
                    if (string.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_description, string2));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_intype_description, new String[]{string2, string}));
                    break;
                }
                if (string.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_description, string2));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_inpackage_description, new String[]{string2, string}));
                break;
            }
            case 2: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.int_obj.gif"));
                if (bl) {
                    if (string.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_description, string2));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_intype_description, new String[]{string2, string}));
                    break;
                }
                if (string.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_description, string2));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_inpackage_description, new String[]{string2, string}));
                break;
            }
            case 3: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.enum_obj.gif"));
                if (bl) {
                    if (string.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_description, string2));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_intype_description, new String[]{string2, string}));
                    break;
                }
                if (string.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_description, string2));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_inpackage_description, new String[]{string2, string}));
                break;
            }
            case 4: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.annotation_obj.gif"));
                if (bl) {
                    if (string.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_description, string2));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_intype_description, new String[]{string2, string}));
                    break;
                }
                if (string.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_description, string2));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_inpackage_description, new String[]{string2, string}));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type kind");
            }
        }
        this.fShowDialog = true;
    }

    private static String getTypeName(int n, Name name) {
        ASTNode aSTNode;
        String string = ASTNodes.getSimpleNameIdentifier(name);
        if ((n == 1 || n == 2) && (aSTNode = name.getParent()).getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
            String string2 = string.startsWith(String.valueOf('T')) ? String.valueOf('S') : String.valueOf('T');
            int n2 = ((ParameterizedType)aSTNode.getParent()).typeArguments().size();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('<');
            if (n2 == 1) {
                stringBuffer.append(string2);
            } else {
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string2).append(n3 + 1);
                    ++n3;
                }
            }
            stringBuffer.append('>');
            return stringBuffer.toString();
        }
        return string;
    }

    public void apply(IDocument iDocument) {
        WizardDialog wizardDialog;
        Object object;
        NewElementWizard newElementWizard = this.createWizard();
        newElementWizard.init(JavaPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.fCompilationUnit));
        IType iType = null;
        if (this.fShowDialog) {
            object = JavaPlugin.getActiveWorkbenchShell();
            wizardDialog = new WizardDialog((Shell)object, (IWizard)newElementWizard);
            PixelConverter pixelConverter = new PixelConverter(JFaceResources.getDialogFont());
            wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
            wizardDialog.create();
            wizardDialog.getShell().setText(CorrectionMessages.NewCUCompletionUsingWizardProposal_dialogtitle);
            this.configureWizardPage(newElementWizard);
            if (wizardDialog.open() == 0) {
                iType = (IType)newElementWizard.getCreatedElement();
            }
        } else {
            newElementWizard.addPages();
            try {
                object = this.configureWizardPage(newElementWizard);
                ((NewTypeWizardPage)((Object)object)).createType(null);
                iType = ((NewTypeWizardPage)((Object)object)).getCreatedType();
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (iType != null) {
            object = iType.getParent();
            if (object instanceof ICompilationUnit) {
                object = object.getParent();
            }
            if (!object.equals(this.fTypeContainer)) {
                try {
                    wizardDialog = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    wizardDialog.addImport(iType.getFullyQualifiedName('.'));
                    JavaModelUtil.applyEdit(this.fCompilationUnit, wizardDialog.rewriteImports(null), false, null);
                }
                catch (CoreException coreException) {}
            }
            this.fCreatedType = iType;
        }
    }

    private NewElementWizard createWizard() {
        switch (this.fTypeKind) {
            case 1: {
                return new NewClassCreationWizard();
            }
            case 2: {
                return new NewInterfaceCreationWizard();
            }
            case 3: {
                return new NewEnumCreationWizard();
            }
            case 4: {
                return new NewAnnotationCreationWizard();
            }
        }
        throw new IllegalArgumentException();
    }

    private NewTypeWizardPage configureWizardPage(NewElementWizard newElementWizard) {
        IWizardPage[] iWizardPageArray = newElementWizard.getPages();
        Assert.isTrue((iWizardPageArray.length > 0 && iWizardPageArray[0] instanceof NewTypeWizardPage ? 1 : 0) != 0);
        NewTypeWizardPage newTypeWizardPage = (NewTypeWizardPage)iWizardPageArray[0];
        this.fillInWizardPageName(newTypeWizardPage);
        this.fillInWizardPageSuperTypes(newTypeWizardPage);
        return newTypeWizardPage;
    }

    private void fillInWizardPageName(NewTypeWizardPage newTypeWizardPage) {
        newTypeWizardPage.setTypeName(this.fTypeNameWithParameters, this.fTypeNameWithParameters.indexOf(60) != -1);
        boolean bl = this.fTypeContainer instanceof IType;
        if (bl) {
            newTypeWizardPage.setEnclosingType((IType)this.fTypeContainer, true);
        } else {
            newTypeWizardPage.setPackageFragment((IPackageFragment)this.fTypeContainer, true);
        }
        newTypeWizardPage.setEnclosingTypeSelection(bl, true);
    }

    private void fillInWizardPageSuperTypes(NewTypeWizardPage newTypeWizardPage) {
        ITypeBinding iTypeBinding = this.getPossibleSuperTypeBinding((ASTNode)this.fNode);
        if ((iTypeBinding = Bindings.normalizeTypeBinding(iTypeBinding)) != null) {
            if (iTypeBinding.isArray()) {
                iTypeBinding = iTypeBinding.getElementType();
            }
            if (iTypeBinding.isTopLevel() || iTypeBinding.isMember()) {
                if (iTypeBinding.isClass() && this.fTypeKind == 1) {
                    newTypeWizardPage.setSuperClass(iTypeBinding.getQualifiedName(), true);
                } else if (iTypeBinding.isInterface()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(iTypeBinding.getQualifiedName());
                    newTypeWizardPage.setSuperInterfaces(arrayList, true);
                }
            }
        }
    }

    private ITypeBinding getPossibleSuperTypeBinding(ASTNode aSTNode) {
        if (this.fTypeKind == 4) {
            return null;
        }
        AST aST = aSTNode.getAST();
        aSTNode = ASTNodes.getNormalizedNode(aSTNode);
        ASTNode aSTNode2 = aSTNode.getParent();
        switch (aSTNode2.getNodeType()) {
            case 31: {
                if (aSTNode.getLocationInParent() != MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) break;
                return aST.resolveWellKnownType("java.lang.Exception");
            }
            case 53: {
                return aST.resolveWellKnownType("java.lang.Exception");
            }
            case 44: {
                if (aSTNode2.getLocationInParent() != CatchClause.EXCEPTION_PROPERTY) break;
                return aST.resolveWellKnownType("java.lang.Exception");
            }
            case 23: 
            case 60: {
                return null;
            }
            case 74: {
                return null;
            }
        }
        return ASTResolving.guessBindingForTypeReference(aSTNode);
    }

    public String getAdditionalProposalInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.fTypeKind) {
            case 1: {
                stringBuffer.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_info);
                break;
            }
            case 2: {
                stringBuffer.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_info);
                break;
            }
            case 3: {
                stringBuffer.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_info);
                break;
            }
            case 4: {
                stringBuffer.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_info);
            }
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<br>");
        if (this.fTypeContainer instanceof IType) {
            stringBuffer.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_enclosingtype);
        } else {
            stringBuffer.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_package);
        }
        stringBuffer.append(" <b>");
        stringBuffer.append(JavaElementLabels.getElementLabel(this.fTypeContainer, 262144L));
        stringBuffer.append("</b><br>");
        stringBuffer.append("public ");
        switch (this.fTypeKind) {
            case 1: {
                stringBuffer.append("class <b>");
                break;
            }
            case 2: {
                stringBuffer.append("interface <b>");
                break;
            }
            case 3: {
                stringBuffer.append("enum <b>");
                break;
            }
            case 4: {
                stringBuffer.append("@interface <b>");
            }
        }
        this.nameToHTML(this.fTypeNameWithParameters, stringBuffer);
        ITypeBinding iTypeBinding = this.getPossibleSuperTypeBinding((ASTNode)this.fNode);
        if (iTypeBinding != null) {
            if (iTypeBinding.isClass()) {
                if (this.fTypeKind == 1) {
                    stringBuffer.append("</b> extends <b>");
                    this.nameToHTML(BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, BindingLabelProvider.DEFAULT_TEXTFLAGS), stringBuffer);
                }
            } else {
                if (this.fTypeKind == 2) {
                    stringBuffer.append("</b> extends <b>");
                } else {
                    stringBuffer.append("</b> implements <b>");
                }
                this.nameToHTML(BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, BindingLabelProvider.DEFAULT_TEXTFLAGS), stringBuffer);
            }
        }
        stringBuffer.append("</b> {<br>}<br>");
        return stringBuffer.toString();
    }

    private void nameToHTML(String string, StringBuffer stringBuffer) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    public boolean isShowDialog() {
        return this.fShowDialog;
    }

    public void setShowDialog(boolean bl) {
        this.fShowDialog = bl;
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    public int getTypeKind() {
        return this.fTypeKind;
    }
}

