/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class QuickAssistLightBulbUpdater {
    private final Annotation fAnnotation;
    private boolean fIsAnnotationShown;
    private ITextEditor fEditor;
    private ITextViewer fViewer;
    private ISelectionListenerWithAST fListener;
    private IPropertyChangeListener fPropertyChangeListener;

    public QuickAssistLightBulbUpdater(ITextEditor iTextEditor, ITextViewer iTextViewer) {
        this.fEditor = iTextEditor;
        this.fViewer = iTextViewer;
        this.fAnnotation = new AssistAnnotation();
        this.fIsAnnotationShown = false;
        this.fPropertyChangeListener = null;
    }

    public boolean isSetInPreferences() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.quickassist.lightbulb");
    }

    private void installSelectionListener() {
        this.fListener = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart iEditorPart, ITextSelection iTextSelection, CompilationUnit compilationUnit) {
                QuickAssistLightBulbUpdater.this.doSelectionChanged(iTextSelection.getOffset(), iTextSelection.getLength(), compilationUnit);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener(this.fEditor, this.fListener);
    }

    private void uninstallSelectionListener() {
        IAnnotationModel iAnnotationModel;
        if (this.fListener != null) {
            SelectionListenerWithASTManager.getDefault().removeListener(this.fEditor, this.fListener);
            this.fListener = null;
        }
        if ((iAnnotationModel = this.getAnnotationModel()) != null) {
            this.removeLightBulb(iAnnotationModel);
        }
    }

    public void install() {
        if (this.isSetInPreferences()) {
            this.installSelectionListener();
        }
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    QuickAssistLightBulbUpdater.this.doPropertyChanged(propertyChangeEvent.getProperty());
                }
            };
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public void uninstall() {
        this.uninstallSelectionListener();
        if (this.fPropertyChangeListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
    }

    protected void doPropertyChanged(String string) {
        if (string.equals("org.eclipse.wst.jsdt.quickassist.lightbulb")) {
            if (this.isSetInPreferences()) {
                ICompilationUnit iCompilationUnit = this.getCompilationUnit();
                if (iCompilationUnit != null) {
                    this.installSelectionListener();
                    Point point = this.fViewer.getSelectedRange();
                    CompilationUnit compilationUnit = ASTProvider.getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_ACTIVE_ONLY, null);
                    if (compilationUnit != null) {
                        this.doSelectionChanged(point.x, point.y, compilationUnit);
                    }
                }
            } else {
                this.uninstallSelectionListener();
            }
        }
    }

    private ICompilationUnit getCompilationUnit() {
        IJavaElement iJavaElement = JavaUI.getEditorInputJavaElement(this.fEditor.getEditorInput());
        if (iJavaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)iJavaElement;
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        return JavaUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return JavaUI.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
    }

    private void doSelectionChanged(int n, int n2, CompilationUnit compilationUnit) {
        IAnnotationModel iAnnotationModel = this.getAnnotationModel();
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        if (iAnnotationModel == null || iCompilationUnit == null) {
            return;
        }
        AssistContext assistContext = new AssistContext(iCompilationUnit, n, n2);
        assistContext.setASTRoot(compilationUnit);
        boolean bl = this.hasQuickFixLightBulb(iAnnotationModel, assistContext.getSelectionOffset());
        if (bl) {
            this.removeLightBulb(iAnnotationModel);
            return;
        }
        this.calculateLightBulb(iAnnotationModel, assistContext);
    }

    private void calculateLightBulb(IAnnotationModel iAnnotationModel, IInvocationContext iInvocationContext) {
        boolean bl = JavaCorrectionProcessor.hasAssists(iInvocationContext);
        if (this.fIsAnnotationShown) {
            iAnnotationModel.removeAnnotation(this.fAnnotation);
        }
        if (bl) {
            iAnnotationModel.addAnnotation(this.fAnnotation, new Position(iInvocationContext.getSelectionOffset(), iInvocationContext.getSelectionLength()));
        }
        this.fIsAnnotationShown = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLightBulb(IAnnotationModel iAnnotationModel) {
        QuickAssistLightBulbUpdater quickAssistLightBulbUpdater = this;
        synchronized (quickAssistLightBulbUpdater) {
            if (this.fIsAnnotationShown) {
                iAnnotationModel.removeAnnotation(this.fAnnotation);
                this.fIsAnnotationShown = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasQuickFixLightBulb(IAnnotationModel iAnnotationModel, int n) {
        try {
            int n2;
            Position position;
            Annotation annotation;
            IDocument iDocument = this.getDocument();
            if (iDocument == null) {
                return false;
            }
            int n3 = iDocument.getLineOfOffset(n);
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!JavaCorrectionProcessor.isQuickFixableType(annotation = (Annotation)iterator.next()) || (position = iAnnotationModel.getPosition(annotation)) == null || (n2 = iDocument.getLineOfOffset(position.getOffset())) != n3 || !JavaCorrectionProcessor.hasCorrections(annotation));
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        return false;
    }

    public static class AssistAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        private static final int LAYER;
        private Image fImage;

        static {
            Annotation annotation = new Annotation("org.eclipse.wst.jsdt.ui.warning", false, null);
            AnnotationPreference annotationPreference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
            LAYER = annotationPreference != null ? annotationPreference.getPresentationLayer() - 1 : 0;
        }

        public int getLayer() {
            return LAYER;
        }

        private Image getImage() {
            if (this.fImage == null) {
                this.fImage = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.quickassist_obj.gif");
            }
            return this.fImage;
        }

        public void paint(GC gC, Canvas canvas, Rectangle rectangle) {
            ImageUtilities.drawImage((Image)this.getImage(), (GC)gC, (Canvas)canvas, (Rectangle)rectangle, (int)0x1000000, (int)128);
        }
    }
}

