/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.CorrectionEngine;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class SuppressWarningsSubProcessor {
    private static final String ADD_SUPPRESSWARNINGS_ID = "org.eclipse.wst.jsdt.ui.correction.addSuppressWarnings";

    public static final boolean hasSuppressWarningsProposal(int n) {
        return CorrectionEngine.getWarningToken((int)n) != null;
    }

    public static void addSuppressWarningsProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) {
        Object object;
        if (iProblemLocation.isError()) {
            return;
        }
        String string = CorrectionEngine.getWarningToken((int)iProblemLocation.getProblemId());
        if (string == null) {
            return;
        }
        ASTNode aSTNode = collection.iterator();
        while (aSTNode.hasNext()) {
            object = aSTNode.next();
            if (!(object instanceof SuppressWarningsProposal) || !string.equals(((SuppressWarningsProposal)object).getWarningToken())) continue;
            return;
        }
        aSTNode = iProblemLocation.getCoveringNode(iInvocationContext.getASTRoot());
        if (aSTNode == null) {
            return;
        }
        if (aSTNode.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            object = aSTNode.getParent();
            if (object.getLocationInParent() == VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
                SuppressWarningsSubProcessor.addSuppressWarningsProposal(iInvocationContext.getCompilationUnit(), object.getParent(), string, -2, collection);
                return;
            }
        } else {
            if (aSTNode.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY) {
                SuppressWarningsSubProcessor.addSuppressWarningsProposal(iInvocationContext.getCompilationUnit(), aSTNode.getParent(), string, -2, collection);
                return;
            }
            if (aSTNode.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY && (aSTNode = ASTResolving.findParentBodyDeclaration(aSTNode)) instanceof FieldDeclaration) {
                aSTNode = aSTNode.getParent();
            }
        }
        if ((object = ASTResolving.findParentBodyDeclaration(aSTNode)) instanceof Initializer) {
            object = ASTResolving.findParentBodyDeclaration(object.getParent());
        }
        if (object != null) {
            SuppressWarningsSubProcessor.addSuppressWarningsProposal(iInvocationContext.getCompilationUnit(), object, string, -3, collection);
        }
    }

    private static String getFirstFragmentName(List list) {
        if (list.size() > 0) {
            return ((VariableDeclarationFragment)list.get(0)).getName().getIdentifier();
        }
        return new String();
    }

    private static void addSuppressWarningsProposal(ICompilationUnit iCompilationUnit, ASTNode aSTNode, String string, int n, Collection collection) {
        String string2;
        ChildListPropertyDescriptor childListPropertyDescriptor = null;
        switch (aSTNode.getNodeType()) {
            case 44: {
                childListPropertyDescriptor = SingleVariableDeclaration.MODIFIERS2_PROPERTY;
                string2 = ((SingleVariableDeclaration)aSTNode).getName().getIdentifier();
                break;
            }
            case 60: {
                childListPropertyDescriptor = VariableDeclarationStatement.MODIFIERS2_PROPERTY;
                string2 = SuppressWarningsSubProcessor.getFirstFragmentName(((VariableDeclarationStatement)aSTNode).fragments());
                break;
            }
            case 55: {
                childListPropertyDescriptor = TypeDeclaration.MODIFIERS2_PROPERTY;
                string2 = ((TypeDeclaration)aSTNode).getName().getIdentifier();
                break;
            }
            case 81: {
                childListPropertyDescriptor = AnnotationTypeDeclaration.MODIFIERS2_PROPERTY;
                string2 = ((AnnotationTypeDeclaration)aSTNode).getName().getIdentifier();
                break;
            }
            case 71: {
                childListPropertyDescriptor = EnumDeclaration.MODIFIERS2_PROPERTY;
                string2 = ((EnumDeclaration)aSTNode).getName().getIdentifier();
                break;
            }
            case 23: {
                childListPropertyDescriptor = FieldDeclaration.MODIFIERS2_PROPERTY;
                string2 = SuppressWarningsSubProcessor.getFirstFragmentName(((FieldDeclaration)aSTNode).fragments());
                break;
            }
            case 28: {
                childListPropertyDescriptor = Initializer.MODIFIERS2_PROPERTY;
                string2 = CorrectionMessages.SuppressWarningsSubProcessor_suppress_warnings_initializer_label;
                break;
            }
            case 31: {
                childListPropertyDescriptor = MethodDeclaration.MODIFIERS2_PROPERTY;
                string2 = String.valueOf(((MethodDeclaration)aSTNode).getName().getIdentifier()) + "()";
                break;
            }
            case 82: {
                childListPropertyDescriptor = AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY;
                string2 = String.valueOf(((AnnotationTypeMemberDeclaration)aSTNode).getName().getIdentifier()) + "()";
                break;
            }
            case 72: {
                childListPropertyDescriptor = EnumConstantDeclaration.MODIFIERS2_PROPERTY;
                string2 = ((EnumConstantDeclaration)aSTNode).getName().getIdentifier();
                break;
            }
            default: {
                JavaPlugin.logErrorMessage("SuppressWarning quick fix: wrong node kind: " + aSTNode.getNodeType());
                return;
            }
        }
        String string3 = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_suppress_warnings_label, new String[]{string, string2});
        SuppressWarningsProposal suppressWarningsProposal = new SuppressWarningsProposal(string, string3, iCompilationUnit, aSTNode, childListPropertyDescriptor, n);
        collection.add(suppressWarningsProposal);
    }

    public static void addUnknownSuppressWarningProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) {
        ASTNode aSTNode = iInvocationContext.getCoveringNode();
        if (!(aSTNode instanceof StringLiteral)) {
            return;
        }
        AST aST = aSTNode.getAST();
        StringLiteral stringLiteral = (StringLiteral)aSTNode;
        String string = stringLiteral.getLiteralValue();
        String[] stringArray = CorrectionEngine.getAllWarningTokens();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (NameMatcher.isSimilarName(string, string2)) {
                StringLiteral stringLiteral2 = aST.newStringLiteral();
                stringLiteral2.setLiteralValue(string2);
                ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
                aSTRewrite.replace((ASTNode)stringLiteral, (ASTNode)stringLiteral2, null);
                String string3 = Messages.format(CorrectionMessages.SuppressWarningsSubProcessor_fix_suppress_token_label, new String[]{string2});
                Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal aSTRewriteCorrectionProposal = new ASTRewriteCorrectionProposal(string3, iInvocationContext.getCompilationUnit(), aSTRewrite, 5, image);
                collection.add(aSTRewriteCorrectionProposal);
            }
            ++n;
        }
    }

    private static class SuppressWarningsProposal
    extends ASTRewriteCorrectionProposal {
        private final String fWarningToken;
        private final ASTNode fNode;
        private final ChildListPropertyDescriptor fProperty;

        public SuppressWarningsProposal(String string, String string2, ICompilationUnit iCompilationUnit, ASTNode aSTNode, ChildListPropertyDescriptor childListPropertyDescriptor, int n) {
            super(string2, iCompilationUnit, (ASTRewrite)null, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.annotation_obj.gif"));
            this.fWarningToken = string;
            this.fNode = aSTNode;
            this.fProperty = childListPropertyDescriptor;
            this.setCommandId(SuppressWarningsSubProcessor.ADD_SUPPRESSWARNINGS_ID);
        }

        public String getWarningToken() {
            return this.fWarningToken;
        }

        protected ASTRewrite getRewrite() throws CoreException {
            NormalAnnotation normalAnnotation;
            Expression expression;
            AST aST = this.fNode.getAST();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            StringLiteral stringLiteral = aST.newStringLiteral();
            stringLiteral.setLiteralValue(this.fWarningToken);
            Annotation annotation = SuppressWarningsProposal.findExistingAnnotation((List)this.fNode.getStructuralProperty((StructuralPropertyDescriptor)this.fProperty));
            if (annotation == null) {
                ListRewrite listRewrite = aSTRewrite.getListRewrite(this.fNode, this.fProperty);
                SingleMemberAnnotation singleMemberAnnotation = aST.newSingleMemberAnnotation();
                String string = this.createImportRewrite((CompilationUnit)this.fNode.getRoot()).addImport("java.lang.SuppressWarnings");
                singleMemberAnnotation.setTypeName(aST.newName(string));
                singleMemberAnnotation.setValue((Expression)stringLiteral);
                listRewrite.insertFirst((ASTNode)singleMemberAnnotation, null);
            } else if (annotation instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
                Expression expression2 = singleMemberAnnotation.getValue();
                if (!SuppressWarningsProposal.addSuppressArgument(aSTRewrite, expression2, stringLiteral)) {
                    aSTRewrite.set((ASTNode)annotation, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)stringLiteral, null);
                }
            } else if (annotation instanceof NormalAnnotation && !SuppressWarningsProposal.addSuppressArgument(aSTRewrite, expression = SuppressWarningsProposal.findValue((normalAnnotation = (NormalAnnotation)annotation).values()), stringLiteral)) {
                ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)normalAnnotation, NormalAnnotation.VALUES_PROPERTY);
                MemberValuePair memberValuePair = aST.newMemberValuePair();
                memberValuePair.setName(aST.newSimpleName("value"));
                memberValuePair.setValue((Expression)stringLiteral);
                listRewrite.insertFirst((ASTNode)memberValuePair, null);
            }
            return aSTRewrite;
        }

        private static boolean addSuppressArgument(ASTRewrite aSTRewrite, Expression expression, StringLiteral stringLiteral) {
            if (expression instanceof ArrayInitializer) {
                ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)expression, ArrayInitializer.EXPRESSIONS_PROPERTY);
                listRewrite.insertLast((ASTNode)stringLiteral, null);
            } else if (expression instanceof StringLiteral) {
                ArrayInitializer arrayInitializer = aSTRewrite.getAST().newArrayInitializer();
                arrayInitializer.expressions().add(aSTRewrite.createMoveTarget((ASTNode)expression));
                arrayInitializer.expressions().add(stringLiteral);
                aSTRewrite.replace((ASTNode)expression, (ASTNode)arrayInitializer, null);
            } else {
                return false;
            }
            return true;
        }

        private static Expression findValue(List list) {
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                MemberValuePair memberValuePair = (MemberValuePair)list.get(n);
                if ("value".equals(memberValuePair.getName().getIdentifier())) {
                    return memberValuePair.getValue();
                }
                ++n;
            }
            return null;
        }

        private static Annotation findExistingAnnotation(List list) {
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                String string;
                Annotation annotation;
                ITypeBinding iTypeBinding;
                Object e = list.get(n);
                if ((e instanceof NormalAnnotation || e instanceof SingleMemberAnnotation) && ((iTypeBinding = (annotation = (Annotation)e).resolveTypeBinding()) != null ? "java.lang.SuppressWarnings".equals(iTypeBinding.getQualifiedName()) : "SuppressWarnings".equals(string = annotation.getTypeName().getFullyQualifiedName()) || "java.lang.SuppressWarnings".equals(string))) {
                    return annotation;
                }
                ++n;
            }
            return null;
        }
    }
}

