/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class TaskMarkerProposal
extends CUCorrectionProposal {
    private IProblemLocation fLocation;

    public TaskMarkerProposal(ICompilationUnit iCompilationUnit, IProblemLocation iProblemLocation, int n) {
        super("", iCompilationUnit, n, null);
        this.fLocation = iProblemLocation;
        this.setDisplayName(CorrectionMessages.TaskMarkerProposal_description);
        this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
    }

    protected void addEdits(IDocument iDocument, TextEdit textEdit) throws CoreException {
        super.addEdits(iDocument, textEdit);
        try {
            Position position = this.getUpdatedPosition(iDocument);
            if (position != null) {
                textEdit.addChild((TextEdit)new ReplaceEdit(position.getOffset(), position.getLength(), ""));
            } else {
                textEdit.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), ""));
            }
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(JavaUIStatus.createError(4, badLocationException));
        }
    }

    private Position getUpdatedPosition(IDocument iDocument) throws BadLocationException {
        int n;
        IScanner iScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        iScanner.setSource(iDocument.get().toCharArray());
        int n2 = this.getSurroundingComment(iScanner);
        if (n2 == 158) {
            return null;
        }
        int n3 = iScanner.getCurrentTokenStartPosition();
        int n4 = iScanner.getCurrentTokenEndPosition() + 1;
        int n5 = n3 + 2;
        int n6 = n4;
        if (n2 == 1003) {
            n5 = n3 + 3;
            n6 = n4 - 2;
        } else if (n2 == 1002) {
            n6 = n4 - 2;
        }
        if (this.hasContent(iDocument, n5, this.fLocation.getOffset()) || this.hasContent(iDocument, n6, this.fLocation.getOffset() + this.fLocation.getLength())) {
            return new Position(this.fLocation.getOffset(), this.fLocation.getLength());
        }
        IRegion iRegion = iDocument.getLineInformationOfOffset(n3);
        int n7 = iRegion.getOffset();
        boolean bl = this.hasContent(iDocument, n7, n3);
        if (bl) {
            n7 = n3;
        }
        if (n2 == 1001) {
            n = bl ? iRegion.getOffset() + iRegion.getLength() : n4;
        } else {
            int n8 = iDocument.getLineOfOffset(n4 - 1);
            if (n8 + 1 == iDocument.getNumberOfLines() || bl) {
                IRegion iRegion2 = iDocument.getLineInformation(n8);
                n = iRegion2.getOffset() + iRegion2.getLength();
            } else {
                IRegion iRegion3 = iDocument.getLineInformation(n8 + 1);
                n = iRegion3.getOffset();
            }
        }
        if (this.hasContent(iDocument, n4, n)) {
            n = n4;
            n7 = n3;
        }
        return new Position(n7, n - n7);
    }

    private int getSurroundingComment(IScanner iScanner) {
        try {
            int n = this.fLocation.getOffset();
            int n2 = n + this.fLocation.getLength();
            int n3 = iScanner.getNextToken();
            while (n3 != 158) {
                if (TokenScanner.isComment(n3)) {
                    int n4 = iScanner.getCurrentTokenStartPosition();
                    int n5 = iScanner.getCurrentTokenEndPosition() + 1;
                    if (n4 <= n && n2 <= n5) {
                        return n3;
                    }
                }
                n3 = iScanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return 158;
    }

    private boolean hasContent(IDocument iDocument, int n, int n2) throws BadLocationException {
        int n3 = n;
        while (n3 < n2) {
            char c = iDocument.getChar(n3);
            if (!Character.isWhitespace(c)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

