/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class UnimplementedMethodsCompletionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fTypeNode;
    private IMethodBinding[] fMethodsToOverride;

    public UnimplementedMethodsCompletionProposal(ICompilationUnit iCompilationUnit, ASTNode aSTNode, int n) {
        super("", iCompilationUnit, (ASTRewrite)null, n, (Image)null);
        this.setDisplayName(CorrectionMessages.UnimplementedMethodsCompletionProposal_description);
        this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fTypeNode = aSTNode;
        this.fMethodsToOverride = null;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        ITypeBinding iTypeBinding;
        IMethodBinding[] iMethodBindingArray;
        AST aST = this.fTypeNode.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            iMethodBindingArray = (IMethodBinding[])this.fTypeNode;
            iTypeBinding = iMethodBindingArray.resolveBinding();
            listRewrite = aSTRewrite.getListRewrite((ASTNode)iMethodBindingArray, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
        } else {
            iMethodBindingArray = (AbstractTypeDeclaration)this.fTypeNode;
            iTypeBinding = iMethodBindingArray.resolveBinding();
            listRewrite = aSTRewrite.getListRewrite((ASTNode)iMethodBindingArray, iMethodBindingArray.getBodyDeclarationsProperty());
        }
        iMethodBindingArray = StubUtility2.getUnimplementedMethods(iTypeBinding);
        this.fMethodsToOverride = iMethodBindingArray;
        CodeGenerationSettings codeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaProject());
        if (iTypeBinding.isAnonymous()) {
            codeGenerationSettings.createComments = false;
        }
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fTypeNode.getRoot());
        ContextSensitiveImportRewriteContext contextSensitiveImportRewriteContext = new ContextSensitiveImportRewriteContext((CompilationUnit)this.fTypeNode.getRoot(), this.fTypeNode.getStartPosition(), importRewrite);
        int n = 0;
        while (n < iMethodBindingArray.length) {
            MethodDeclaration methodDeclaration = StubUtility2.createImplementationStub(this.getCompilationUnit(), aSTRewrite, importRewrite, aST, iMethodBindingArray[n], iTypeBinding.getName(), codeGenerationSettings, iTypeBinding.isInterface(), contextSensitiveImportRewriteContext);
            listRewrite.insertLast((ASTNode)methodDeclaration, null);
            ++n;
        }
        return aSTRewrite;
    }

    public String getAdditionalProposalInfo() {
        try {
            this.getChange();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<b>");
            stringBuffer.append(Messages.format(CorrectionMessages.UnimplementedMethodsCompletionProposal_info, String.valueOf(this.fMethodsToOverride.length)));
            stringBuffer.append("</b><ul>");
            int n = 0;
            while (n < this.fMethodsToOverride.length) {
                stringBuffer.append("<li>");
                stringBuffer.append(BindingLabelProvider.getBindingLabel((IBinding)this.fMethodsToOverride[n], JavaElementLabels.ALL_FULLY_QUALIFIED));
                stringBuffer.append("</li>");
                ++n;
            }
            stringBuffer.append("</ul>");
            return stringBuffer.toString();
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return null;
        }
    }
}

