/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.folding.FoldingMessages;
import org.eclipse.wst.jsdt.internal.ui.text.folding.JavaFoldingStructureProviderDescriptor;
import org.eclipse.wst.jsdt.ui.text.folding.IJavaFoldingStructureProvider;

public class JavaFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new JavaFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String string) {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (JavaFoldingStructureProviderDescriptor)this.fDescriptors.get(string);
        }
    }

    public IJavaFoldingStructureProvider getCurrentFoldingProvider() {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("editor_folding_provider");
        JavaFoldingStructureProviderDescriptor javaFoldingStructureProviderDescriptor = this.getFoldingProviderDescriptor(string);
        if (javaFoldingStructureProviderDescriptor == null) {
            String string2 = Messages.format(FoldingMessages.JavaFoldingStructureProviderRegistry_warning_providerNotFound_resetToDefault, string);
            JavaPlugin.log((IStatus)new Status(2, JavaPlugin.getPluginId(), 0, string2, null));
            String string3 = iPreferenceStore.getDefaultString("editor_folding_provider");
            javaFoldingStructureProviderDescriptor = this.getFoldingProviderDescriptor(string3);
            Assert.isNotNull((Object)javaFoldingStructureProviderDescriptor);
            iPreferenceStore.setToDefault("editor_folding_provider");
        }
        try {
            return javaFoldingStructureProviderDescriptor.createProvider();
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return null;
        }
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        HashMap<String, JavaFoldingStructureProviderDescriptor> hashMap = new HashMap<String, JavaFoldingStructureProviderDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(JavaPlugin.getPluginId(), EXTENSION_POINT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            JavaFoldingStructureProviderDescriptor javaFoldingStructureProviderDescriptor = new JavaFoldingStructureProviderDescriptor(iConfigurationElementArray[n]);
            hashMap.put(javaFoldingStructureProviderDescriptor.getId(), javaFoldingStructureProviderDescriptor);
            ++n;
        }
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(hashMap);
        }
    }
}

