/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.internal.ui.text.ISourceVersionDependent;
import org.eclipse.wst.jsdt.internal.ui.text.JavaPairMatcher;

public class JavaDoubleClickSelector
implements ITextDoubleClickStrategy,
ISourceVersionDependent {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected JavaPairMatcher fPairMatcher = new JavaPairMatcher(BRACKETS);
    protected final AtJavaIdentifierDetector fWordDetector = new AtJavaIdentifierDetector();

    public void doubleClicked(ITextViewer iTextViewer) {
        int n = iTextViewer.getSelectedRange().x;
        if (n < 0) {
            return;
        }
        IDocument iDocument = iTextViewer.getDocument();
        IRegion iRegion = this.fPairMatcher.match(iDocument, n);
        if (iRegion != null && iRegion.getLength() >= 2) {
            iTextViewer.setSelectedRange(iRegion.getOffset() + 1, iRegion.getLength() - 2);
        } else {
            iRegion = this.selectWord(iDocument, n);
            iTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
        }
    }

    protected IRegion selectWord(IDocument iDocument, int n) {
        return this.fWordDetector.getWordSelection(iDocument, n);
    }

    public void setSourceVersion(String string) {
        this.fPairMatcher.setSourceVersion(string);
        this.fWordDetector.setSourceVersion(string);
    }

    private static final class AtJavaIdentifierDetector
    implements ISourceVersionDependent {
        private boolean fSelectAnnotations;
        private static final int UNKNOWN = -1;
        private static final int WS = 0;
        private static final int ID = 1;
        private static final int IDS = 2;
        private static final int AT = 3;
        private static final int FORWARD = 0;
        private static final int BACKWARD = 1;
        private int fState;
        private int fAnchorState;
        private int fDirection;
        private int fStart;
        private int fEnd;

        private AtJavaIdentifierDetector() {
        }

        private void setAnchor(int n) {
            this.fState = -1;
            this.fAnchorState = -1;
            this.fDirection = -1;
            this.fStart = n;
            this.fEnd = n - 1;
        }

        private boolean isAt(char c) {
            return this.fSelectAnnotations && c == '@';
        }

        private boolean isIdentifierStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        private boolean isIdentifierPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        private boolean isWhitespace(char c) {
            return this.fSelectAnnotations && Character.isWhitespace(c);
        }

        public void setSourceVersion(String string) {
            this.fSelectAnnotations = "1.5".compareTo(string) <= 0;
        }

        private boolean backward(char c, int n) {
            this.checkDirection(1);
            switch (this.fState) {
                case 3: {
                    return false;
                }
                case 2: {
                    if (this.isAt(c)) {
                        this.fStart = n;
                        this.fState = 3;
                        return false;
                    }
                    if (this.isWhitespace(c)) {
                        this.fState = 0;
                        return true;
                    }
                }
                case 1: {
                    if (this.isIdentifierStart(c)) {
                        this.fStart = n;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fStart = n;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case 0: {
                    if (this.isWhitespace(c)) {
                        return true;
                    }
                    if (this.isAt(c)) {
                        this.fStart = n;
                        this.fState = 3;
                        return false;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean forward(char c, int n) {
            this.checkDirection(0);
            switch (this.fState) {
                case 0: 
                case 3: {
                    if (this.isWhitespace(c)) {
                        this.fState = 0;
                        return true;
                    }
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = n;
                        this.fState = 2;
                        return true;
                    }
                    return false;
                }
                case 1: 
                case 2: {
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = n;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fEnd = n;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case -1: {
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = n;
                        this.fAnchorState = this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fEnd = n;
                        this.fAnchorState = this.fState = 1;
                        return true;
                    }
                    if (this.isWhitespace(c)) {
                        this.fAnchorState = this.fState = 0;
                        return true;
                    }
                    if (this.isAt(c)) {
                        this.fStart = n;
                        this.fAnchorState = this.fState = 3;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private void checkDirection(int n) {
            if (this.fDirection == n) {
                return;
            }
            if (n == 0) {
                this.fState = this.fStart <= this.fEnd ? this.fAnchorState : -1;
            } else if (n == 1) {
                this.fState = this.fEnd >= this.fStart ? this.fAnchorState : -1;
            }
            this.fDirection = n;
        }

        public IRegion getWordSelection(IDocument iDocument, int n) {
            try {
                char c;
                int n2 = iDocument.getLength();
                this.setAnchor(n);
                int n3 = n;
                while (n3 < n2) {
                    c = iDocument.getChar(n3);
                    if (!this.forward(c, n3)) break;
                    ++n3;
                }
                n3 = n;
                while (n3 >= 0) {
                    c = iDocument.getChar(n3);
                    if (!this.backward(c, n3)) break;
                    --n3;
                }
                return new Region(this.fStart, this.fEnd - this.fStart + 1);
            }
            catch (BadLocationException badLocationException) {
                return new Region(n, 0);
            }
        }
    }
}

