/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.ui.text.java.AbstractProposalSorter;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.osgi.framework.Bundle;

public final class ProposalSorterHandle {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String ACTIVATE = "activate";
    private static final String PERFORMANCE_EVENT = String.valueOf(JavaPlugin.getPluginId()) + "/perf/content_assist_sorters/extensions";
    private static final boolean MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)PERFORMANCE_EVENT);
    private static final String SORT = "sort";
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final IConfigurationElement fElement;
    private AbstractProposalSorter fSorter;

    ProposalSorterHandle(IConfigurationElement iConfigurationElement) throws InvalidRegistryObjectException {
        Assert.isLegal((iConfigurationElement != null ? 1 : 0) != 0);
        this.fElement = iConfigurationElement;
        this.fId = iConfigurationElement.getAttribute(ID);
        this.checkNotNull(this.fId, ID);
        String string = iConfigurationElement.getAttribute(NAME);
        this.fName = string == null ? this.fId : string;
        String string2 = iConfigurationElement.getAttribute(ACTIVATE);
        this.fActivate = Boolean.valueOf(string2);
        this.fClass = iConfigurationElement.getAttribute(CLASS);
        this.checkNotNull(this.fClass, CLASS);
    }

    private void checkNotNull(Object object, String string) throws InvalidRegistryObjectException {
        if (object == null) {
            Object[] objectArray = new Object[]{this.getId(), this.fElement.getContributor().getName(), string};
            String string2 = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, objectArray);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, string2, null);
            JavaPlugin.log((IStatus)status);
            throw new InvalidRegistryObjectException();
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    private synchronized AbstractProposalSorter getSorter() throws CoreException, InvalidRegistryObjectException {
        if (this.fSorter == null && (this.fActivate || this.isPluginLoaded())) {
            this.fSorter = this.createSorter();
        }
        return this.fSorter;
    }

    private boolean isPluginLoaded() throws InvalidRegistryObjectException {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() throws InvalidRegistryObjectException {
        String string = this.fElement.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)string);
        return bundle;
    }

    private AbstractProposalSorter createSorter() throws CoreException, InvalidRegistryObjectException {
        return (AbstractProposalSorter)this.fElement.createExecutableExtension(CLASS);
    }

    public void sortProposals(ContentAssistInvocationContext contentAssistInvocationContext, List list) {
        Status status;
        try {
            AbstractProposalSorter abstractProposalSorter = this.getSorter();
            PerformanceStats performanceStats = this.startMeter(SORT, abstractProposalSorter);
            abstractProposalSorter.beginSorting(contentAssistInvocationContext);
            Collections.sort(list, abstractProposalSorter);
            abstractProposalSorter.endSorting();
            status = this.stopMeter(performanceStats, SORT);
            if (status == null) {
                return;
            }
            status = this.createAPIViolationStatus(SORT);
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            status = this.createExceptionStatus(invalidRegistryObjectException);
        }
        catch (CoreException coreException) {
            status = this.createExceptionStatus(coreException);
        }
        catch (RuntimeException runtimeException) {
            status = this.createExceptionStatus(runtimeException);
        }
        JavaPlugin.log((IStatus)status);
    }

    private IStatus stopMeter(PerformanceStats performanceStats, String string) {
        if (MEASURE_PERFORMANCE) {
            performanceStats.endRun();
            if (performanceStats.isFailure()) {
                return this.createPerformanceStatus(string);
            }
        }
        return null;
    }

    private PerformanceStats startMeter(String string, AbstractProposalSorter abstractProposalSorter) {
        PerformanceStats performanceStats;
        if (MEASURE_PERFORMANCE) {
            performanceStats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)abstractProposalSorter);
            performanceStats.startRun(string);
        } else {
            performanceStats = null;
        }
        return performanceStats;
    }

    private Status createExceptionStatus(InvalidRegistryObjectException invalidRegistryObjectException) {
        String string = this.createBlameMessage();
        String string2 = JavaTextMessages.CompletionProposalComputerDescriptor_reason_invalid;
        return new Status(1, JavaPlugin.getPluginId(), 0, String.valueOf(string) + " " + string2, (Throwable)invalidRegistryObjectException);
    }

    private Status createExceptionStatus(CoreException coreException) {
        String string = this.createBlameMessage();
        String string2 = JavaTextMessages.CompletionProposalComputerDescriptor_reason_instantiation;
        return new Status(4, JavaPlugin.getPluginId(), 0, String.valueOf(string) + " " + string2, (Throwable)coreException);
    }

    private Status createExceptionStatus(RuntimeException runtimeException) {
        String string = this.createBlameMessage();
        String string2 = JavaTextMessages.CompletionProposalComputerDescriptor_reason_runtime_ex;
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(string) + " " + string2, (Throwable)runtimeException);
    }

    private Status createAPIViolationStatus(String string) {
        String string2 = this.createBlameMessage();
        Object[] objectArray = new Object[]{string};
        String string3 = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_API, objectArray);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(string2) + " " + string3, null);
    }

    private Status createPerformanceStatus(String string) {
        String string2 = this.createBlameMessage();
        Object[] objectArray = new Object[]{string};
        String string3 = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_performance, objectArray);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(string2) + " " + string3, null);
    }

    private String createBlameMessage() {
        Object[] objectArray = new Object[]{this.getName(), this.getId()};
        String string = Messages.format(JavaTextMessages.ProposalSorterHandle_blame, objectArray);
        return string;
    }

    public String getErrorMessage() {
        return null;
    }
}

