/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.text.SmartBackspaceManager;

public class SmartSemicolonAutoEditStrategy
implements IAutoEditStrategy {
    private static final String SEMICOLON = ";";
    private static final char SEMICHAR = ';';
    private static final String BRACE = "{";
    private static final char BRACECHAR = '{';
    private char fCharacter;
    private String fPartitioning;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SmartSemicolonAutoEditStrategy(String string) {
        this.fPartitioning = string;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        TextSelection textSelection;
        ITextEditorExtension2 iTextEditorExtension2;
        if (documentCommand.text == null) {
            return;
        }
        if (documentCommand.text.equals(SEMICOLON)) {
            this.fCharacter = (char)59;
        } else if (documentCommand.text.equals(BRACE)) {
            this.fCharacter = (char)123;
        } else {
            return;
        }
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (this.fCharacter == ';' && !iPreferenceStore.getBoolean("smart_semicolon")) {
            return;
        }
        if (this.fCharacter == '{' && !iPreferenceStore.getBoolean("smart_opening_brace")) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (!(iEditorPart instanceof CompilationUnitEditor)) {
            return;
        }
        CompilationUnitEditor compilationUnitEditor = (CompilationUnitEditor)iEditorPart;
        if (compilationUnitEditor.getInsertMode() != ITextEditorExtension3.SMART_INSERT || !compilationUnitEditor.isEditable()) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditorExtension2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iTextEditorExtension2 = (ITextEditorExtension2)compilationUnitEditor.getAdapter(clazz)) != null && !iTextEditorExtension2.validateEditorInputState()) {
            return;
        }
        if (this.isMultilineSelection(iDocument, documentCommand)) {
            return;
        }
        int n = documentCommand.offset;
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            textSelection = new TextSelection(iDocument, iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int n2 = SmartSemicolonAutoEditStrategy.computeCharacterPosition(iDocument, (ITextSelection)textSelection, n - textSelection.getOffset(), this.fCharacter, this.fPartitioning);
        int n3 = n2 + textSelection.getOffset();
        if (n3 < n) {
            return;
        }
        if (this.alreadyPresent(iDocument, this.fCharacter, n3)) {
            return;
        }
        String string = this.adjustSpacing(iDocument, n3, this.fCharacter);
        if (documentCommand.offset == n3 && string.equals(documentCommand.text)) {
            return;
        }
        try {
            SmartBackspaceManager smartBackspaceManager;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.internal.ui.text.SmartBackspaceManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((smartBackspaceManager = (SmartBackspaceManager)compilationUnitEditor.getAdapter(clazz2)) != null && JavaPlugin.getDefault().getPreferenceStore().getBoolean("smart_backspace")) {
                ReplaceEdit replaceEdit = new ReplaceEdit(documentCommand.offset, documentCommand.text.length(), iDocument.get(documentCommand.offset, documentCommand.length));
                SmartBackspaceManager.UndoSpec undoSpec = new SmartBackspaceManager.UndoSpec(documentCommand.offset + documentCommand.text.length(), (IRegion)new Region(documentCommand.offset, 0), new TextEdit[]{replaceEdit}, 0, null);
                DeleteEdit deleteEdit = new DeleteEdit(n3, string.length());
                ReplaceEdit replaceEdit2 = new ReplaceEdit(documentCommand.offset, documentCommand.length, documentCommand.text);
                SmartBackspaceManager.UndoSpec undoSpec2 = new SmartBackspaceManager.UndoSpec(n3 + string.length(), (IRegion)new Region(documentCommand.offset + documentCommand.text.length(), 0), new TextEdit[]{deleteEdit, replaceEdit2}, 2, undoSpec);
                smartBackspaceManager.register(undoSpec2);
            }
            documentCommand.offset = n3;
            documentCommand.length = 0;
            documentCommand.caretOffset = n3;
            documentCommand.text = string;
            documentCommand.doit = true;
            documentCommand.owner = null;
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private boolean isMultilineSelection(IDocument iDocument, DocumentCommand documentCommand) {
        try {
            return iDocument.getNumberOfLines(documentCommand.offset, documentCommand.length) > 1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private String adjustSpacing(IDocument iDocument, int n, char c) {
        int n2;
        if (c == '{' && n > 0 && n <= iDocument.getLength() && (SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2 = n - 1, ")") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "=") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "]") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "try") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "else") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "synchronized") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "static") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "finally") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "do"))) {
            return new String(new char[]{' ', c});
        }
        return new String(new char[]{c});
    }

    private boolean alreadyPresent(IDocument iDocument, char c, int n) {
        int n2 = SmartSemicolonAutoEditStrategy.firstNonWhitespaceForward(iDocument, n, this.fPartitioning, iDocument.getLength());
        try {
            if (n2 != -1 && iDocument.getChar(n2) == c) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    protected static int computeCharacterPosition(IDocument iDocument, ITextSelection iTextSelection, int n, char c, String string) {
        int n2;
        String string2 = iTextSelection.getText();
        if (string2 == null) {
            return 0;
        }
        if (c == '{') {
            n2 = SmartSemicolonAutoEditStrategy.computeArrayInitializationPos(iDocument, iTextSelection, n, string);
            if (n2 == -1) {
                n2 = SmartSemicolonAutoEditStrategy.computeAfterTryDoElse(iDocument, iTextSelection, n);
            }
            if (n2 == -1) {
                n2 = SmartSemicolonAutoEditStrategy.computeAfterParenthesis(iDocument, iTextSelection, n, string);
            }
        } else if (c == ';') {
            if (SmartSemicolonAutoEditStrategy.isForStatement(string2, n)) {
                n2 = -1;
            } else {
                int n3;
                int n4 = SmartSemicolonAutoEditStrategy.nextPartitionOrLineEnd(iDocument, iTextSelection, n, string);
                n2 = SmartSemicolonAutoEditStrategy.startOfWhitespaceBeforeOffset(string2, n4);
                if (n2 > 0 && string2.charAt(n2 - 1) == c) {
                    --n2;
                } else if (n2 > 0 && string2.charAt(n2 - 1) == '}' && (n3 = SmartSemicolonAutoEditStrategy.scanBackward(iDocument, n2 - 1 + iTextSelection.getOffset(), string, -1, new char[]{'{'})) > -1 && n3 < n + iTextSelection.getOffset() && SmartSemicolonAutoEditStrategy.computeArrayInitializationPos(iDocument, iTextSelection, n3 - iTextSelection.getOffset(), string) == -1) {
                    n2 = n;
                }
            }
        } else {
            Assert.isTrue((boolean)false);
            return -1;
        }
        return n2;
    }

    private static int computeArrayInitializationPos(IDocument iDocument, ITextSelection iTextSelection, int n, String string) {
        char c;
        int n2;
        block9: {
            block8: {
                int n3 = n + iTextSelection.getOffset();
                if (n3 == 0) {
                    return -1;
                }
                n2 = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(iDocument, n3 - 1, string, -1);
                if (n2 == -1) {
                    return -1;
                }
                try {
                    c = iDocument.getChar(n2);
                    if (c == '=' || c == ']') break block8;
                    return -1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (n2 == 0) {
                return n;
            }
            if ((n2 = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(iDocument, n2 - 1, string, -1)) != -1) break block9;
            return -1;
        }
        c = iDocument.getChar(n2);
        if (Character.isJavaIdentifierPart(c) || c == ']' || c == '[') {
            return n;
        }
        return -1;
    }

    private static int computeAfterTryDoElse(IDocument iDocument, ITextSelection iTextSelection, int n) {
        int n2 = n + iTextSelection.getOffset();
        if ((n2 = SmartSemicolonAutoEditStrategy.firstWhitespaceToRight(iDocument, n2)) == -1) {
            return -1;
        }
        if (SmartSemicolonAutoEditStrategy.looksLike(iDocument, --n2, "try") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "do") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "synchronized") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "static") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "finally") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n2, "else")) {
            return n2 + 1 - iTextSelection.getOffset();
        }
        return -1;
    }

    private static int computeAfterParenthesis(IDocument iDocument, ITextSelection iTextSelection, int n, String string) {
        int n2;
        int n3;
        int n4;
        int n5 = n + iTextSelection.getOffset();
        int n6 = SmartSemicolonAutoEditStrategy.scanForward(iDocument, n5, string, n4 = iTextSelection.getOffset() + iTextSelection.getLength(), '}');
        if (n6 == -1) {
            n6 = n4;
        }
        int n7 = SmartSemicolonAutoEditStrategy.findClosingParenToLeft(iDocument, n5, string) - 1;
        while ((n7 = SmartSemicolonAutoEditStrategy.scanForward(iDocument, n3 = n7 + 1, string, n6, ')')) != -1 && (n2 = SmartSemicolonAutoEditStrategy.findOpeningParenMatch(iDocument, n7, string)) >= 1) {
            if (n2 > n5) continue;
            if (SmartSemicolonAutoEditStrategy.looksLikeAnonymousClassDef(iDocument, n2 - 1, string)) {
                return n7 + 1 - iTextSelection.getOffset();
            }
            if (SmartSemicolonAutoEditStrategy.looksLikeIfWhileForCatch(iDocument, n2 - 1, string)) {
                return n7 + 1 - iTextSelection.getOffset();
            }
            if (!SmartSemicolonAutoEditStrategy.looksLikeMethodDecl(iDocument, n2 - 1, string)) continue;
            return n7 + 1 - iTextSelection.getOffset();
        }
        return -1;
    }

    private static int findClosingParenToLeft(IDocument iDocument, int n, String string) {
        try {
            if (n < 1) {
                return n;
            }
            int n2 = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(iDocument, n - 1, string, -1);
            if (n2 != -1 && iDocument.getChar(n2) == ')') {
                return n2;
            }
        }
        catch (BadLocationException badLocationException) {}
        return n;
    }

    private static int firstWhitespaceToRight(IDocument iDocument, int n) {
        int n2 = iDocument.getLength();
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n <= n2 ? 1 : 0) != 0);
        try {
            while (n < n2) {
                char c = iDocument.getChar(n);
                if (Character.isWhitespace(c)) {
                    return n;
                }
                ++n;
            }
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private static int firstNonWhitespaceBackward(IDocument iDocument, int n, String string, int n2) {
        Assert.isTrue((n < iDocument.getLength() ? 1 : 0) != 0);
        Assert.isTrue((n2 >= -1 ? 1 : 0) != 0);
        try {
            while (n > n2) {
                char c = iDocument.getChar(n);
                if (!Character.isWhitespace(c) && SmartSemicolonAutoEditStrategy.isDefaultPartition(iDocument, n, string)) {
                    return n;
                }
                --n;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int firstNonWhitespaceForward(IDocument iDocument, int n, String string, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 <= iDocument.getLength() ? 1 : 0) != 0);
        try {
            while (n < n2) {
                char c = iDocument.getChar(n);
                if (!Character.isWhitespace(c) && SmartSemicolonAutoEditStrategy.isDefaultPartition(iDocument, n, string)) {
                    return n;
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int scanBackward(IDocument iDocument, int n, String string, int n2, char[] cArray) {
        Assert.isTrue((n2 >= -1 ? 1 : 0) != 0);
        Assert.isTrue((n < iDocument.getLength() ? 1 : 0) != 0);
        Arrays.sort(cArray);
        try {
            while (n > n2) {
                if (Arrays.binarySearch(cArray, iDocument.getChar(n)) >= 0 && SmartSemicolonAutoEditStrategy.isDefaultPartition(iDocument, n, string)) {
                    return n;
                }
                --n;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int scanForward(IDocument iDocument, int n, String string, int n2, char[] cArray) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 <= iDocument.getLength() ? 1 : 0) != 0);
        Arrays.sort(cArray);
        try {
            while (n < n2) {
                if (Arrays.binarySearch(cArray, iDocument.getChar(n)) >= 0 && SmartSemicolonAutoEditStrategy.isDefaultPartition(iDocument, n, string)) {
                    return n;
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private static int scanForward(IDocument iDocument, int n, String string, int n2, char c) {
        return SmartSemicolonAutoEditStrategy.scanForward(iDocument, n, string, n2, new char[]{c});
    }

    private static boolean isNewMatch(IDocument iDocument, int n, int n2, String string) {
        int n3;
        String string2;
        block6: {
            block5: {
                Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
                Assert.isTrue((n >= 0 ? 1 : 0) != 0);
                Assert.isTrue((n + n2 < iDocument.getLength() + 1 ? 1 : 0) != 0);
                try {
                    string2 = iDocument.get(n, n2);
                    n3 = string2.indexOf("new");
                    while (n3 != -1 && !SmartSemicolonAutoEditStrategy.isDefaultPartition(iDocument, n3 + n, string)) {
                        n3 = string2.indexOf("new", n3 + 2);
                    }
                    if (n3 >= 0) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (n3 == 0 || !Character.isJavaIdentifierPart(string2.charAt(n3 - 1))) break block6;
            return false;
        }
        return n3 + 3 >= n2 || !Character.isJavaIdentifierPart(string2.charAt(n3 + 3));
    }

    private static boolean looksLikeAnonymousClassDef(IDocument iDocument, int n, String string) {
        int n2 = SmartSemicolonAutoEditStrategy.scanBackward(iDocument, n - 1, string, -1, new char[]{',', '(', '='});
        if (n2 == -1 || n < n2 + 5) {
            return false;
        }
        return SmartSemicolonAutoEditStrategy.isNewMatch(iDocument, n2 + 1, n - n2 - 2, string);
    }

    private static boolean isDefaultPartition(IDocument iDocument, int n, String string) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n <= iDocument.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)string, (int)n, (boolean)false);
            return iTypedRegion.getType().equals("__dftl_partition_content_type");
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findOpeningParenMatch(IDocument iDocument, int n, String string) {
        Assert.isTrue((n < iDocument.getLength() ? 1 : 0) != 0);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)SmartSemicolonAutoEditStrategy.isDefaultPartition(iDocument, n, string));
        try {
            Assert.isTrue((iDocument.getChar(n) == ')' ? 1 : 0) != 0);
            int n2 = 1;
            do {
                if ((n = SmartSemicolonAutoEditStrategy.scanBackward(iDocument, n - 1, string, -1, new char[]{')', '('})) == -1) {
                    return -1;
                }
                if (iDocument.getChar(n) == ')') {
                    ++n2;
                    continue;
                }
                --n2;
            } while (n2 != 0);
            return n;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private static boolean looksLikeIfWhileForCatch(IDocument iDocument, int n, String string) {
        if ((n = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(iDocument, n, string, -1)) == -1) {
            return false;
        }
        return SmartSemicolonAutoEditStrategy.looksLike(iDocument, n, "if") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n, "while") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n, "catch") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n, "synchronized") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n, "switch") || SmartSemicolonAutoEditStrategy.looksLike(iDocument, n, "for");
    }

    private static boolean looksLike(IDocument iDocument, int n, String string) {
        int n2;
        block4: {
            n2 = string.length();
            if (n < n2 - 1) {
                return false;
            }
            try {
                if (string.equals(iDocument.get(n - n2 + 1, n2))) break block4;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return n < n2 || !Character.isJavaIdentifierPart(string.charAt(0)) || !Character.isJavaIdentifierPart(iDocument.getChar(n - n2));
    }

    private static boolean looksLikeMethodDecl(IDocument iDocument, int n, String string) {
        if ((n = SmartSemicolonAutoEditStrategy.eatIdentToLeft(iDocument, n, string)) < 1) {
            return false;
        }
        if ((n = SmartSemicolonAutoEditStrategy.eatBrackets(iDocument, n - 1, string)) < 1) {
            return false;
        }
        return (n = SmartSemicolonAutoEditStrategy.eatIdentToLeft(iDocument, n - 1, string)) != -1;
    }

    private static int eatBrackets(IDocument iDocument, int n, String string) {
        int n2 = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(iDocument, n, string, -1);
        try {
            if (n2 > 1 && iDocument.getChar(n2) == ']' && (n2 = SmartSemicolonAutoEditStrategy.firstNonWhitespaceBackward(iDocument, n2 - 1, string, -1)) > 0 && iDocument.getChar(n2) == '[') {
                return n2;
            }
        }
        catch (BadLocationException badLocationException) {}
        return n;
    }

    /*
     * Exception decompiling
     */
    private static int eatIdentToLeft(IDocument var0, int var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int nextPartitionOrLineEnd(IDocument iDocument, ITextSelection iTextSelection, int n, String string) {
        int n2;
        int n3 = n + iTextSelection.getOffset();
        int n4 = n2 = iTextSelection.getOffset() + iTextSelection.getLength();
        int n5 = n3;
        try {
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)string, (int)n4, (boolean)true);
            n5 = SmartSemicolonAutoEditStrategy.getValidPositionForPartition(iDocument, iTypedRegion, n2);
            while (n5 == -1) {
                n4 = iTypedRegion.getOffset() - 1;
                if (n4 < n3) {
                    n5 = n3;
                    break;
                }
                iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)string, (int)n4, (boolean)false);
                n5 = SmartSemicolonAutoEditStrategy.getValidPositionForPartition(iDocument, iTypedRegion, n2);
            }
        }
        catch (BadLocationException badLocationException) {}
        n5 = Math.max(n5, n3);
        return n5 -= iTextSelection.getOffset();
    }

    private static int getValidPositionForPartition(IDocument iDocument, ITypedRegion iTypedRegion, int n) {
        if ("__java_javadoc".equals(iTypedRegion.getType())) {
            return -1;
        }
        if ("__java_multiline_comment".equals(iTypedRegion.getType())) {
            return -1;
        }
        if ("__java_singleline_comment".equals(iTypedRegion.getType())) {
            return -1;
        }
        int n2 = Math.min(n, iTypedRegion.getOffset() + iTypedRegion.getLength());
        if ("__java_character".equals(iTypedRegion.getType())) {
            return n2;
        }
        if ("__java_string".equals(iTypedRegion.getType())) {
            return n2;
        }
        if ("__dftl_partition_content_type".equals(iTypedRegion.getType())) {
            block9: {
                try {
                    if (iDocument.get(iTypedRegion.getOffset(), n2 - iTypedRegion.getOffset()).trim().length() != 0) break block9;
                    return -1;
                }
                catch (BadLocationException badLocationException) {
                    return -1;
                }
            }
            return n2;
        }
        return n2;
    }

    private static boolean isForStatement(String string, int n) {
        int n2 = string.indexOf("for");
        return !(n2 == -1 || n2 != 0 && Character.isJavaIdentifierPart(string.charAt(n2 - 1)) || string.length() != n2 + 3 && Character.isJavaIdentifierPart(string.charAt(n2 + 3)));
    }

    private static int startOfWhitespaceBeforeOffset(String string, int n) {
        int n2 = Math.min(n, string.length());
        while (n2 >= 1) {
            if (!Character.isWhitespace(string.charAt(n2 - 1))) break;
            --n2;
        }
        return n2;
    }
}

