/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlCreatorExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AnnotationExpandHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AnnotationExpansionControl;

public class AnnotationExpandHover
implements IAnnotationHover,
IAnnotationHoverExtension {
    private final IInformationControlCreator fgCreator = new InformationControlCreator();
    protected final IVerticalRulerListener fgListener = new VerticalRulerListener();
    protected CompositeRuler fCompositeRuler;
    protected IDoubleClickListener fDblClickListener;
    protected IAnnotationAccess fAnnotationAccess;

    public AnnotationExpandHover(CompositeRuler compositeRuler, IAnnotationAccess iAnnotationAccess, IDoubleClickListener iDoubleClickListener) {
        this.fCompositeRuler = compositeRuler;
        this.fAnnotationAccess = iAnnotationAccess;
        this.fDblClickListener = iDoubleClickListener;
    }

    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        return null;
    }

    protected Object getHoverInfoForLine(ISourceViewer iSourceViewer, int n) {
        Object object;
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        IDocument iDocument = iSourceViewer.getDocument();
        if (iAnnotationModel == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        HashMap hashMap = new HashMap();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            object = (Annotation)iterator.next();
            Position position = iAnnotationModel.getPosition(object);
            if (position == null || this.compareRulerLine(position, iDocument, n) != 1 || this.isDuplicateMessage(hashMap, position, object.getText())) continue;
            arrayList.add((Annotation)object);
        }
        if (arrayList.size() < 1) {
            return null;
        }
        this.sort(arrayList, iAnnotationModel);
        if (arrayList.size() > 0) {
            this.setLastRulerMouseLocation(iSourceViewer, n);
        }
        object = new AnnotationExpansionControl.AnnotationHoverInput();
        object.fAnnotations = arrayList.toArray(new Annotation[0]);
        object.fViewer = iSourceViewer;
        object.fRulerInfo = this.fCompositeRuler;
        object.fAnnotationListener = this.fgListener;
        object.fDoubleClickListener = this.fDblClickListener;
        object.model = iAnnotationModel;
        return object;
    }

    protected void sort(List list, IAnnotationModel iAnnotationModel) {
        class AnnotationComparator
        implements Comparator {
            final /* synthetic */ AnnotationExpandHover this$0;
            private final /* synthetic */ IAnnotationModel val$model;

            AnnotationComparator(AnnotationExpandHover annotationExpandHover, IAnnotationModel iAnnotationModel) {
                this.this$0 = annotationExpandHover;
                this.val$model = iAnnotationModel;
            }

            public int compare(Object object, Object object2) {
                Annotation annotation = (Annotation)object;
                Annotation annotation2 = (Annotation)object2;
                Position position = this.val$model.getPosition(annotation);
                Position position2 = this.val$model.getPosition(annotation2);
                if (position.offset == position2.offset) {
                    return this.this$0.getOrder(annotation2) - this.this$0.getOrder(annotation);
                }
                return position.offset - position2.offset;
            }
        }
        Collections.sort(list, new AnnotationComparator(this, iAnnotationModel));
    }

    protected int getOrder(Annotation annotation) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension iAnnotationAccessExtension = (IAnnotationAccessExtension)this.fAnnotationAccess;
            return iAnnotationAccessExtension.getLayer(annotation);
        }
        return 0;
    }

    protected boolean isDuplicateMessage(Map map, Position position, String string) {
        if (string == null) {
            return false;
        }
        if (map.containsKey(position)) {
            Object v = map.get(position);
            if (string == null || string.equals(v)) {
                return true;
            }
            if (v instanceof List) {
                List list = (List)v;
                if (list.contains(string)) {
                    return true;
                }
                list.add(string);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(v);
                arrayList.add(string);
                map.put(position, arrayList);
            }
        } else {
            map.put(position, string);
        }
        return false;
    }

    protected void setLastRulerMouseLocation(ISourceViewer iSourceViewer, int n) {
        StyledText styledText;
        if (this.fCompositeRuler != null && (styledText = iSourceViewer.getTextWidget()) != null && !styledText.isDisposed()) {
            if (iSourceViewer instanceof ITextViewerExtension5) {
                int n2 = ((ITextViewerExtension5)iSourceViewer).modelLine2WidgetLine(n);
                Point point = styledText.getLocationAtOffset(styledText.getOffsetAtLine(n2));
                this.fCompositeRuler.setLocationOfLastMouseButtonActivity(0, point.y);
            } else if (iSourceViewer instanceof TextViewer) {
                int n3 = ((TextViewer)iSourceViewer).modelLine2WidgetLine(n);
                Point point = styledText.getLocationAtOffset(styledText.getOffsetAtLine(n3));
                this.fCompositeRuler.setLocationOfLastMouseButtonActivity(0, point.y);
            }
        }
    }

    protected int compareRulerLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int n2;
            block5: {
                try {
                    n2 = iDocument.getLineOfOffset(position.getOffset());
                    if (n != n2) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (n2 <= n && n <= iDocument.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return this.fgCreator;
    }

    public Object getHoverInfo(ISourceViewer iSourceViewer, ILineRange iLineRange, int n) {
        return this.getHoverInfoForLine(iSourceViewer, iLineRange.getStartLine());
    }

    public ILineRange getHoverLineRange(ISourceViewer iSourceViewer, int n) {
        return new LineRange(n, 1);
    }

    public boolean canHandleMouseCursor() {
        return true;
    }

    private class InformationControlCreator
    implements IInformationControlCreator,
    IInformationControlCreatorExtension {
        private InformationControlCreator() {
        }

        public IInformationControl createInformationControl(Shell shell) {
            return new AnnotationExpansionControl(shell, 0, AnnotationExpandHover.this.fAnnotationAccess);
        }

        public boolean canReuse(IInformationControl iInformationControl) {
            return iInformationControl instanceof AnnotationExpansionControl;
        }

        public boolean canReplace(IInformationControlCreator iInformationControlCreator) {
            return iInformationControlCreator == this;
        }
    }

    private class VerticalRulerListener
    implements IVerticalRulerListener {
        private VerticalRulerListener() {
        }

        public void annotationSelected(VerticalRulerEvent verticalRulerEvent) {
            AnnotationExpandHover.this.fCompositeRuler.fireAnnotationSelected(verticalRulerEvent);
        }

        public void annotationDefaultSelected(VerticalRulerEvent verticalRulerEvent) {
            AnnotationExpandHover.this.fCompositeRuler.fireAnnotationDefaultSelected(verticalRulerEvent);
        }

        public void annotationContextMenuAboutToShow(VerticalRulerEvent verticalRulerEvent, Menu menu) {
            AnnotationExpandHover.this.fCompositeRuler.fireAnnotationContextMenuAboutToShow(verticalRulerEvent, menu);
        }
    }
}

