/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.AddWordProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.ChangeCaseProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.DisableSpellCheckingProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.WordIgnoreProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellEvent;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class JavaSpellingProblem
extends SpellingProblem {
    private ISpellEvent fSpellEvent;
    private IDocument fDocument;

    public JavaSpellingProblem(ISpellEvent iSpellEvent, IDocument iDocument) {
        Assert.isLegal((iDocument != null ? 1 : 0) != 0);
        Assert.isLegal((iSpellEvent != null ? 1 : 0) != 0);
        this.fSpellEvent = iSpellEvent;
        this.fDocument = iDocument;
    }

    public int getOffset() {
        return this.fSpellEvent.getBegin();
    }

    public int getLength() {
        return this.fSpellEvent.getEnd() - this.fSpellEvent.getBegin() + 1;
    }

    public String getMessage() {
        if (this.isSentenceStart() && this.isDictionaryMatch()) {
            return Messages.format(JavaUIMessages.Spelling_error_case_label, new String[]{this.fSpellEvent.getWord()});
        }
        return Messages.format(JavaUIMessages.Spelling_error_label, new String[]{this.fSpellEvent.getWord()});
    }

    public ICompletionProposal[] getProposals() {
        String[] stringArray = this.getArguments();
        if (stringArray == null) {
            return new ICompletionProposal[0];
        }
        if (stringArray[0].indexOf(38) != -1 && this.isIgnoringAmpersand()) {
            return new ICompletionProposal[0];
        }
        int n = PreferenceConstants.getPreferenceStore().getInt("spelling_proposal_threshold");
        int n2 = 0;
        List list = null;
        RankedWordProposal rankedWordProposal = null;
        ICompletionProposal[] iCompletionProposalArray = null;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ISpellCheckEngine iSpellCheckEngine = SpellCheckEngine.getInstance();
        ISpellChecker iSpellChecker = iSpellCheckEngine.getSpellChecker();
        if (iSpellChecker != null) {
            AssistContext assistContext = new AssistContext(null, this.getOffset(), this.getLength());
            boolean bl4 = bl = stringArray[0].charAt(0) == '<' || stringArray[0].charAt(0) == '@';
            if (bl3 && bl2 && !bl) {
                iCompletionProposalArray = new IJavaCompletionProposal[]{new ChangeCaseProposal(stringArray, this.getOffset(), this.getLength(), assistContext, iSpellCheckEngine.getLocale())};
            } else {
                list = new ArrayList(iSpellChecker.getProposals(stringArray[0], bl3));
                n2 = list.size();
                if (n > 0 && n2 > n) {
                    Collections.sort(list);
                    list = list.subList(n2 - n - 1, n2 - 1);
                    n2 = list.size();
                }
                boolean bl5 = !bl ? iSpellChecker.acceptsWords() || AddWordProposal.canAskToConfigure() : false;
                iCompletionProposalArray = new IJavaCompletionProposal[n2 + (bl5 ? 3 : 2)];
                n3 = 0;
                while (n3 < n2) {
                    rankedWordProposal = (RankedWordProposal)list.get(n3);
                    iCompletionProposalArray[n3] = new WordCorrectionProposal(rankedWordProposal.getText(), stringArray, this.getOffset(), this.getLength(), assistContext, rankedWordProposal.getRank());
                    ++n3;
                }
                if (bl5) {
                    iCompletionProposalArray[n3++] = new AddWordProposal(stringArray[0], assistContext);
                }
                iCompletionProposalArray[n3++] = new WordIgnoreProposal(stringArray[0], assistContext);
                iCompletionProposalArray[n3++] = new DisableSpellCheckingProposal(assistContext);
            }
        }
        return iCompletionProposalArray;
    }

    private boolean isIgnoringAmpersand() {
        return PreferenceConstants.getPreferenceStore().getBoolean("spelling_ignore_ampersand_in_properties");
    }

    public String[] getArguments() {
        String string;
        String string2 = "";
        String string3 = "";
        try {
            string = this.fDocument.get(this.getOffset(), this.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        try {
            IRegion iRegion = this.fDocument.getLineInformationOfOffset(this.getOffset());
            int n = this.getOffset() + this.getLength();
            string2 = this.fDocument.get(iRegion.getOffset(), this.getOffset() - iRegion.getOffset());
            string3 = this.fDocument.get(n + 1, iRegion.getOffset() + iRegion.getLength() - n);
        }
        catch (BadLocationException badLocationException) {}
        return new String[]{string, string2, string3, this.isSentenceStart() ? Boolean.toString(true) : Boolean.toString(false), this.isDictionaryMatch() ? Boolean.toString(true) : Boolean.toString(false)};
    }

    public boolean isDictionaryMatch() {
        return this.fSpellEvent.isMatch();
    }

    public boolean isSentenceStart() {
        return this.fSpellEvent.isStart();
    }
}

