/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.PropertiesFileSpellCheckIterator;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckIterator;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class PropertiesFileSpellingEngine
extends SpellingEngine {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void check(IDocument iDocument, IRegion[] iRegionArray, ISpellChecker iSpellChecker, ISpellingProblemCollector iSpellingProblemCollector, IProgressMonitor iProgressMonitor) {
        SpellingEngine.SpellEventListener spellEventListener = new SpellingEngine.SpellEventListener(iSpellingProblemCollector, iDocument);
        boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("spelling_ignore_ampersand_in_properties");
        try {
            try {
                iSpellChecker.addListener(spellEventListener);
                ArrayList<ITypedRegion> arrayList = new ArrayList<ITypedRegion>();
                int n = 0;
                while (n < iRegionArray.length) {
                    arrayList.addAll(Arrays.asList(TextUtilities.computePartitioning((IDocument)iDocument, (String)"___pf_partitioning", (int)iRegionArray[n].getOffset(), (int)iRegionArray[n].getLength(), (boolean)false)));
                    ++n;
                }
                ITypedRegion[] iTypedRegionArray = arrayList.toArray(new ITypedRegion[arrayList.size()]);
                int n2 = 0;
                while (n2 < iTypedRegionArray.length) {
                    String string;
                    ITypedRegion iTypedRegion = iTypedRegionArray[n2];
                    if ("__pf_comment".equals(iTypedRegion.getType())) {
                        while (n2 < iTypedRegionArray.length - 1) {
                            string = iTypedRegionArray[n2 + 1];
                            int n3 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                            int n4 = string.getOffset() - n3;
                            if (!"__pf_comment".equals(string.getType()) && !this.isWhitespace(iDocument, string.getOffset(), string.getLength()) || !this.isWhitespace(iDocument, n3, n4)) break;
                            iTypedRegion = new TypedRegion(iTypedRegion.getOffset(), string.getOffset() + string.getLength() - iTypedRegion.getOffset(), iTypedRegion.getType());
                            ++n2;
                        }
                    }
                    if ("__pf_comment".equals(string = iTypedRegion.getType()) || !bl && "__pf_roperty_value".equals(string)) {
                        Locale locale = iSpellChecker.getLocale();
                        iSpellChecker.execute(new SpellCheckIterator(iDocument, (IRegion)iTypedRegion, locale));
                    } else if (bl && "__pf_roperty_value".equals(string)) {
                        Locale locale = iSpellChecker.getLocale();
                        iSpellChecker.execute(new PropertiesFileSpellCheckIterator(iDocument, (IRegion)iTypedRegion, locale));
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
            Object var15_21 = null;
            iSpellChecker.removeListener(spellEventListener);
            return;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            iSpellChecker.removeListener(spellEventListener);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isWhitespace(IDocument iDocument, int n, int n2) {
        try {
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isWhitespace(iDocument.getChar(n + n3))) {
                    return false;
                }
                ++n3;
            }
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
            return false;
        }
    }
}

