/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.template.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaDocContext;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.InclusivePositionUpdater;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateContentAssistMessages;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.VariablePosition;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class TemplateProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final Image fImage;
    private IRegion fRegion;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;

    public TemplateProposal(Template template, TemplateContext templateContext, IRegion iRegion, Image image) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)templateContext);
        Assert.isNotNull((Object)iRegion);
        this.fTemplate = template;
        this.fContext = templateContext;
        this.fImage = image;
        this.fRegion = iRegion;
        this.fDisplayString = null;
        this.fRelevance = this.computeRelevance();
    }

    private int computeRelevance() {
        int n = 8;
        try {
            if (this.fContext instanceof DocumentTemplateContext) {
                DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
                IDocument iDocument = documentTemplateContext.getDocument();
                String string = iDocument.get(this.fRegion.getOffset(), this.fRegion.getLength());
                if (this.fTemplate.getName().startsWith(string)) {
                    n += 10;
                }
                if (this.fTemplate.getName().equalsIgnoreCase(string)) {
                    n += 4;
                }
                if (this.fContext instanceof JavaDocContext) {
                    n += 31;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return n * 16 + 1;
    }

    public final void apply(IDocument iDocument) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        try {
            MultiVariableGuess multiVariableGuess;
            TemplateVariable[] templateVariableArray;
            IDocument iDocument;
            int n3;
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            try {
                this.beginCompoundChange(iTextViewer);
                try {
                    templateBuffer = this.fContext.evaluate(this.fTemplate);
                }
                catch (TemplateException templateException) {
                    this.fSelectedRegion = this.fRegion;
                    Object var10_6 = null;
                    this.endCompoundChange(iTextViewer);
                    return;
                }
                n3 = this.getReplaceOffset();
                int n4 = this.getReplaceEndOffset();
                n4 = Math.max(n4, n2);
                iDocument = iTextViewer.getDocument();
                if (n4 > iDocument.getLength()) {
                    n4 = n2;
                }
                templateVariableArray = templateBuffer.getString();
                iDocument.replace(n3, n4 - n3, (String)templateVariableArray);
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                this.endCompoundChange(iTextViewer);
                throw throwable;
            }
            {
                multiVariableGuess = null;
                this.endCompoundChange(iTextViewer);
            }
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            templateVariableArray = templateBuffer.getVariables();
            multiVariableGuess = this.fContext instanceof CompilationUnitContext ? ((CompilationUnitContext)this.fContext).getMultiVariableGuess() : null;
            boolean bl = false;
            int n5 = 0;
            while (true) {
                TemplateVariable templateVariable;
                if (n5 == templateVariableArray.length) {
                    if (!bl) {
                        this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + n3, 0);
                        return;
                    }
                    linkedModeModel.forceInstall();
                    JavaEditor javaEditor = this.getJavaEditor();
                    if (javaEditor != null) {
                        linkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(javaEditor));
                    }
                    templateVariable = new EditorLinkedModeUI(linkedModeModel, iTextViewer);
                    templateVariable.setExitPosition(iTextViewer, this.getCaretOffset(templateBuffer) + n3, 0, Integer.MAX_VALUE);
                    templateVariable.enter();
                    this.fSelectedRegion = templateVariable.getSelectedRegion();
                    return;
                }
                templateVariable = templateVariableArray[n5];
                if (!templateVariable.isUnambiguous()) {
                    VariablePosition variablePosition;
                    LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
                    int[] nArray = templateVariable.getOffsets();
                    int n6 = templateVariable.getLength();
                    if (multiVariableGuess != null && templateVariable instanceof MultiVariable) {
                        variablePosition = new VariablePosition(iDocument, nArray[0] + n3, n6, multiVariableGuess, (MultiVariable)templateVariable);
                        multiVariableGuess.addSlave(variablePosition);
                    } else {
                        String[] stringArray = templateVariable.getValues();
                        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[stringArray.length];
                        int n7 = 0;
                        while (true) {
                            if (n7 >= stringArray.length) {
                                variablePosition = iCompletionProposalArray.length > 1 ? new ProposalPosition(iDocument, nArray[0] + n3, n6, iCompletionProposalArray) : new LinkedPosition(iDocument, nArray[0] + n3, n6);
                            }
                            this.ensurePositionCategoryInstalled(iDocument, linkedModeModel);
                            Position position = new Position(nArray[0] + n3, n6);
                            iDocument.addPosition(this.getCategory(), position);
                            iCompletionProposalArray[n7] = new PositionBasedCompletionProposal(stringArray[n7], position, n6);
                            ++n7;
                        }
                    }
                    int n8 = 0;
                    while (true) {
                        if (n8 == nArray.length) {
                            linkedModeModel.addGroup(linkedPositionGroup);
                            bl = true;
                            break;
                        }
                        if (n8 == 0) {
                            linkedPositionGroup.addPosition((LinkedPosition)variablePosition);
                        } else {
                            linkedPositionGroup.addPosition(new LinkedPosition(iDocument, nArray[n8] + n3, n6));
                        }
                        ++n8;
                    }
                }
                ++n5;
            }
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badLocationException));
            this.fSelectedRegion = this.fRegion;
            return;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            JavaPlugin.log(badPositionCategoryException);
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badPositionCategoryException));
            this.fSelectedRegion = this.fRegion;
        }
    }

    private void endCompoundChange(ITextViewer iTextViewer) {
        if (iTextViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)iTextViewer;
            IRewriteTarget iRewriteTarget = iTextViewerExtension.getRewriteTarget();
            iRewriteTarget.endCompoundChange();
        }
    }

    private void beginCompoundChange(ITextViewer iTextViewer) {
        if (iTextViewer instanceof ITextViewerExtension) {
            ITextViewerExtension iTextViewerExtension = (ITextViewerExtension)iTextViewer;
            IRewriteTarget iRewriteTarget = iTextViewerExtension.getRewriteTarget();
            iRewriteTarget.beginCompoundChange();
        }
    }

    private JavaEditor getJavaEditor() {
        IEditorPart iEditorPart = JavaPlugin.getActivePage().getActiveEditor();
        if (iEditorPart instanceof JavaEditor) {
            return (JavaEditor)iEditorPart;
        }
        return null;
    }

    private int getReplaceOffset() {
        int n;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
            n = documentTemplateContext.getStart();
        } else {
            n = this.fRegion.getOffset();
        }
        return n;
    }

    private int getReplaceEndOffset() {
        int n;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
            n = documentTemplateContext.getEnd();
        } else {
            n = this.fRegion.getOffset() + this.fRegion.getLength();
        }
        return n;
    }

    private void ensurePositionCategoryInstalled(final IDocument iDocument, LinkedModeModel linkedModeModel) {
        if (!iDocument.containsPositionCategory(this.getCategory())) {
            iDocument.addPositionCategory(this.getCategory());
            final InclusivePositionUpdater inclusivePositionUpdater = new InclusivePositionUpdater(this.getCategory());
            iDocument.addPositionUpdater((IPositionUpdater)inclusivePositionUpdater);
            linkedModeModel.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel linkedModeModel, int n) {
                    try {
                        iDocument.removePositionCategory(TemplateProposal.this.getCategory());
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                    iDocument.removePositionUpdater((IPositionUpdater)inclusivePositionUpdater);
                }

                public void suspend(LinkedModeModel linkedModeModel) {
                }

                public void resume(LinkedModeModel linkedModeModel, int n) {
                }
            });
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer templateBuffer) {
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        int n = 0;
        while (n != templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            if (templateVariable.getType().equals("cursor")) {
                return templateVariable.getOffsets()[0];
            }
            ++n;
        }
        return templateBuffer.getString().length();
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        TemplateBuffer templateBuffer;
        try {
            this.fContext.setReadOnly(true);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            this.handleException(JavaPlugin.getActiveWorkbenchShell(), new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, "", (Throwable)badLocationException)));
            return null;
        }
        Document document = new Document(templateBuffer.getString());
        IndentUtil.indentLines((IDocument)document, (ILineRange)new LineRange(0, document.getNumberOfLines()), null, null);
        return document.get();
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            Object[] objectArray = new String[]{this.fTemplate.getName(), this.fTemplate.getDescription()};
            this.fDisplayString = Messages.format(TemplateContentAssistMessages.TemplateProposal_displayString, objectArray);
        }
        return this.fDisplayString;
    }

    public void setDisplayString(String string) {
        this.fDisplayString = string;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception exception) {
        MessageDialog.openError((Shell)shell, (String)TemplateContentAssistMessages.TemplateEvaluator_error_title, (String)exception.getMessage());
    }

    private void handleException(Shell shell, CoreException coreException) {
        ExceptionHandler.handle(coreException, shell, TemplateContentAssistMessages.TemplateEvaluator_error_title, null);
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int n) {
        this.fRelevance = n;
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    public IInformationControlCreator getInformationControlCreator() {
        JavaEditor javaEditor = this.getJavaEditor();
        int n = javaEditor instanceof IWorkbenchPartOrientation ? ((IWorkbenchPartOrientation)javaEditor).getOrientation() : 0x2000000;
        return new TemplateInformationControlCreator(n);
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        try {
            int n2 = this.getReplaceOffset();
            if (n >= n2) {
                String string = iDocument.get(n2, n - n2);
                String string2 = this.fTemplate.getName().toLowerCase();
                boolean bl = string2.startsWith(string.toLowerCase());
                if (!bl && this.fContext instanceof JavaDocContext && string2.startsWith("<")) {
                    bl = string2.startsWith(string.toLowerCase(), 1);
                }
                return bl;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        if (this.isSelectionTemplate()) {
            return "";
        }
        return this.fTemplate.getName();
    }

    public int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.getReplaceOffset();
    }

    public boolean isAutoInsertable() {
        if (this.isSelectionTemplate()) {
            return false;
        }
        return this.fTemplate.isAutoInsertable();
    }

    private boolean isSelectionTemplate() {
        DocumentTemplateContext documentTemplateContext;
        return this.fContext instanceof DocumentTemplateContext && (documentTemplateContext = (DocumentTemplateContext)this.fContext).getCompletionLength() > 0;
    }
}

